/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.OS;
import java.util.EnumSet;

public enum CapturableState {
    GET_LAST_ERROR(1, EnumSet.of(OS.Windows)),
    WSA_GET_LAST_ERROR(2, EnumSet.of(OS.Windows)),
    ERRNO(4, EnumSet.allOf(OS.class));

    private final int mask;
    private final EnumSet<OS> supportedOS;

    private CapturableState(int mask, EnumSet<OS> supportedOS) {
        this.mask = mask;
        this.supportedOS = supportedOS;
    }

    public boolean isSupported(OS os) {
        return this.supportedOS.contains((Object)os);
    }

    public static EnumSet<CapturableState> fromMask(int m) {
        EnumSet<CapturableState> set = EnumSet.noneOf(CapturableState.class);
        int leftOver = 0;
        for (CapturableState state : CapturableState.values()) {
            if ((state.mask & m) == 0) continue;
            leftOver &= ~state.mask;
            set.add(state);
        }
        if (leftOver != 0) {
            throw EspressoError.unimplemented("Unknown CapturableState mask: 0x%08x".formatted(leftOver));
        }
        return set;
    }

    public static int toMask(EnumSet<CapturableState> states) {
        int m = 0;
        for (CapturableState state : states) {
            m |= state.mask;
        }
        return m;
    }
}

