/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama.x64;

import com.oracle.truffle.espresso.runtime.panama.ArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.DefaultArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import com.oracle.truffle.espresso.runtime.panama.x64.X64Platform;
import com.oracle.truffle.espresso.runtime.panama.x64.X64Regs;

public final class SysVx64
extends X64Platform {
    public static final SysVx64 INSTANCE = new SysVx64();
    public static final VMStorage[] CALL_INT_REGS = new VMStorage[]{X64Regs.rdi, X64Regs.rsi, X64Regs.rdx, X64Regs.rcx, X64Regs.r8, X64Regs.r9};
    public static final VMStorage[] CALL_FLOAT_REGS = new VMStorage[]{X64Regs.xmm0, X64Regs.xmm1, X64Regs.xmm2, X64Regs.xmm3, X64Regs.xmm4, X64Regs.xmm5, X64Regs.xmm6, X64Regs.xmm7};

    private SysVx64() {
    }

    @Override
    public boolean ignoreDownCallArgument(VMStorage reg) {
        return X64Regs.rax.equals(reg);
    }

    @Override
    public ArgumentsCalculator getArgumentsCalculator() {
        return new DefaultArgumentsCalculator(this, CALL_INT_REGS, CALL_FLOAT_REGS, X64Regs.rax, X64Regs.xmm0);
    }
}

