/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodPredicate;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.vm.VM;

@EspressoSubstitutions
public final class Target_java_lang_Object {
    @Substitution(hasReceiver=true, isTrivial=true)
    public static int hashCode(@JavaType(value=Object.class) StaticObject self, @Inject EspressoLanguage lang) {
        return VM.JVM_IHashCode(self, lang);
    }

    @Substitution(hasReceiver=true, isTrivial=true)
    public static @JavaType(value=Class.class) StaticObject getClass(@JavaType(value=Object.class) StaticObject self) {
        return self.getKlass().mirror();
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=Object.class) StaticObject clone(@JavaType(value=Object.class) StaticObject self, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        return VM.JVM_Clone(self, language, meta, profiler);
    }

    @Substitution(hasReceiver=true)
    public static void wait(@JavaType(value=Object.class) StaticObject self, long time, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        meta.getVM().JVM_MonitorWait(self, time, meta, profiler);
    }

    @Substitution(hasReceiver=true)
    public static void notify(@JavaType(value=Object.class) StaticObject self, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        meta.getVM().JVM_MonitorNotify(self, profiler);
    }

    @Substitution(hasReceiver=true)
    public static void notifyAll(@JavaType(value=Object.class) StaticObject self, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        meta.getVM().JVM_MonitorNotifyAll(self, profiler);
    }

    @Substitution(hasReceiver=true, methodName="<init>", isTrivial=true)
    static abstract class Init
    extends SubstitutionNode {
        Init() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1);

        static boolean hasFinalizer(StaticObject self, EspressoContext context) {
            return ((ObjectKlass)self.getKlass()).hasFinalizer(context);
        }

        @Specialization(guards={"!hasFinalizer(self, getContext())"})
        void noFinalizer(@JavaType(value=Object.class) StaticObject self) {
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        void registerFinalizer(@JavaType(value=Object.class) StaticObject self, @Cached(value="getMeta().java_lang_ref_Finalizer_register.getCallTarget()") CallTarget register, @Cached IndirectCallNode indirectCallNode) {
            indirectCallNode.call(register, new Object[]{self});
        }
    }

    public static final class InitGuard
    implements InlinedMethodPredicate {
        public static final InlinedMethodPredicate INSTANCE = new InitGuard();

        @Override
        public boolean isValid(EspressoContext context, Method.MethodVersion version, VirtualFrame frame, InlinedMethodNode node) {
            StaticObject receiver = node.peekReceiver(frame);
            return !Init.hasFinalizer(receiver, context);
        }
    }
}

