/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import java.lang.invoke.MethodType;

@EspressoSubstitutions
public final class Target_jdk_internal_foreign_abi_NativeEntryPoint {
    @Substitution
    public static void registerNatives() {
    }

    @Substitution
    public static long makeDowncallStub(@JavaType(value=MethodType.class) StaticObject methodType, @JavaType(internalName="Ljdk/internal/foreign/abi/ABIDescriptor;") StaticObject abi, @JavaType(internalName="[Ljdk/internal/foreign/abi/VMStorage;") StaticObject encArgMoves, @JavaType(internalName="[Ljdk/internal/foreign/abi/VMStorage;") StaticObject encRetMoves, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition, @Inject EspressoContext context, @Inject Meta meta) {
        Klass[] pTypes = Target_jdk_internal_foreign_abi_NativeEntryPoint.getPTypes(methodType, meta);
        Klass rType = meta.java_lang_invoke_MethodType_rtype.getObject(methodType).getMirrorKlass(meta);
        VMStorage[] inputRegs = VMStorage.fromGuestArray(encArgMoves, meta);
        VMStorage[] outRegs = VMStorage.fromGuestArray(encRetMoves, meta);
        assert (inputRegs.length == pTypes.length);
        return context.getDowncallStubs().makeStub(pTypes, rType, inputRegs, outRegs, needsReturnBuffer, capturedStateMask, needsTransition);
    }

    static Klass[] getPTypes(StaticObject methodType, Meta meta) {
        EspressoLanguage language = meta.getLanguage();
        StaticObject guestPTypes = meta.java_lang_invoke_MethodType_ptypes.getObject(methodType);
        int numParamTypes = guestPTypes.length(language);
        Klass[] pTypes = new Klass[numParamTypes];
        for (int i = 0; i < numParamTypes; ++i) {
            pTypes[i] = ((StaticObject)guestPTypes.get(language, i)).getMirrorKlass(meta);
        }
        return pTypes;
    }

    @Substitution
    public static boolean freeDowncallStub0(long downcallStub, @Inject EspressoContext context) {
        return context.getDowncallStubs().freeStub(downcallStub);
    }
}

