/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.npe;

import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.BytecodeSwitch;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.LanguageAccess;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import com.oracle.truffle.espresso.vm.npe.MessageBuildHelper;
import com.oracle.truffle.espresso.vm.npe.SimulatedStack;
import com.oracle.truffle.espresso.vm.npe.StackObject;
import com.oracle.truffle.espresso.vm.npe.StackType;
import java.util.ArrayList;
import java.util.Iterator;

final class Analysis
implements LanguageAccess {
    private final EspressoLanguage lang;
    final Method m;
    private final int targetBci;
    private final int maxStack;
    final BytecodeStream bs;
    private final SimulatedStack[] stacks;
    private boolean allDone = false;
    private boolean newStackInfo = false;
    private int entries = 0;
    private static final int MAX_ENTRIES = 100000;

    static Analysis analyze(Method m, int bci) {
        return new Analysis(m, bci);
    }

    String buildMessage() {
        return MessageBuildHelper.buildCause(this, this.targetBci);
    }

    @Override
    public EspressoLanguage getLanguage() {
        return this.lang;
    }

    private Analysis(Method m, int targetBci) {
        this.m = m;
        this.targetBci = targetBci;
        this.bs = new BytecodeStream(m.getOriginalCode());
        this.stacks = new SimulatedStack[this.bs.endBCI()];
        this.maxStack = m.getMethodVersion().getMaxStackSize();
        this.lang = m.getLanguage();
        this.analyze();
    }

    private void analyze() {
        this.registerStack(new SimulatedStack(this.maxStack), 0);
        for (ExceptionHandler handler : this.m.getExceptionHandlers()) {
            int bci = handler.getHandlerBCI();
            this.registerStack(new SimulatedStack(this.maxStack).push(-1, StackType.OBJECT), bci);
        }
        do {
            this.allDone = true;
            this.newStackInfo = false;
            int bci = 0;
            while (bci < this.bs.endBCI()) {
                int nextBci = this.bs.nextBCI(bci);
                this.processInstr(bci, nextBci);
                if (this.entries > 100000) {
                    return;
                }
                bci = nextBci;
            }
        } while (!this.allDone && this.newStackInfo);
    }

    private void processInstr(int bci, int nextBci) {
        SimulatedStack origStack = this.stacks[bci];
        if (origStack == null) {
            this.allDone = false;
            return;
        }
        SimulatedStack stack = new SimulatedStack(origStack, this.maxStack);
        ArrayList<Integer> branches = new ArrayList<Integer>(2);
        boolean endOfFlow = false;
        int opcode = this.bs.currentBC(bci);
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 187: {
                stack.push(bci, StackType.rtype(opcode));
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                stack.pop();
                stack.pop();
                stack.push(bci, StackType.rtype(opcode));
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                stack.setLocalSlotWritten(this.bs.readLocalIndex(bci));
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                break;
            }
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                stack.setLocalSlotWritten(0);
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                stack.setLocalSlotWritten(1);
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                break;
            }
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                stack.setLocalSlotWritten(2);
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                break;
            }
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                stack.setLocalSlotWritten(3);
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 194: 
            case 195: {
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                break;
            }
            case 89: {
                stack.pushRaw(stack.top(0));
                break;
            }
            case 90: {
                StackObject top0 = stack.top(0);
                StackObject top1 = stack.top(1);
                stack.pop(2);
                stack.pushRaw(top0).pushRaw(top1).pushRaw(top0);
                break;
            }
            case 91: {
                StackObject top0 = stack.top(0);
                StackObject top1 = stack.top(1);
                StackObject top2 = stack.top(2);
                stack.pop(3);
                stack.pushRaw(top0).pushRaw(top2).pushRaw(top1).pushRaw(top0);
                break;
            }
            case 92: {
                stack.pushRaw(stack.top(1));
                stack.pushRaw(stack.top(1));
                break;
            }
            case 93: {
                StackObject top0 = stack.top(0);
                StackObject top1 = stack.top(1);
                StackObject top2 = stack.top(2);
                stack.pop(3);
                stack.pushRaw(top1).pushRaw(top0).pushRaw(top2).pushRaw(top1).pushRaw(top0);
                break;
            }
            case 94: {
                StackObject top0 = stack.top(0);
                StackObject top1 = stack.top(1);
                StackObject top2 = stack.top(2);
                StackObject top3 = stack.top(3);
                stack.pop(4);
                stack.pushRaw(top1).pushRaw(top0).pushRaw(top3).pushRaw(top2).pushRaw(top1).pushRaw(top0);
                break;
            }
            case 95: {
                StackObject top0 = stack.top(0);
                StackObject top1 = stack.top(1);
                stack.pop(2);
                stack.pushRaw(top0).pushRaw(top1);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                StackType rtype = StackType.rtype(opcode);
                stack.pop(-Bytecodes.stackEffectOf(opcode) + rtype.slots());
                stack.push(bci, rtype);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                branches.add(this.bs.readBranchDest(bci));
                break;
            }
            case 167: 
            case 200: {
                branches.add(this.bs.readBranchDest(bci));
                endOfFlow = true;
                break;
            }
            case 168: 
            case 201: {
                stack.push(bci, StackType.ADDRESS);
                branches.add(this.bs.readBranchDest(bci));
                endOfFlow = true;
                break;
            }
            case 169: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                endOfFlow = true;
                break;
            }
            case 170: 
            case 171: {
                stack.pop();
                BytecodeSwitch helper = BytecodeSwitch.get(opcode);
                assert (helper != null);
                branches.add(helper.defaultOffset(this.bs, bci));
                for (int i = 0; i < helper.numberOfCases(this.bs, bci); ++i) {
                    branches.add(helper.targetAt(this.bs, bci, i));
                }
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 193: {
                stack.pop();
                stack.push(bci, StackType.rtype(opcode));
                break;
            }
            case 197: {
                stack.pop(this.bs.readUByte(bci + 3));
                stack.push(bci, StackType.ARRAY);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                char cpi = this.bs.readCPI(bci);
                ConstantPool.Tag tag = this.m.getConstantPool().tagAt(cpi);
                stack.push(bci, StackType.forTag(tag));
                break;
            }
            case 178: 
            case 180: {
                Symbol<Symbol.Type> type = this.getFieldType(bci);
                stack.pop(-Bytecodes.stackEffectOf(opcode));
                stack.push(bci, StackType.forType(type));
                break;
            }
            case 179: 
            case 181: {
                Symbol<Symbol.Type> type = this.getFieldType(bci);
                int slots = StackType.forType(type).slots();
                stack.pop(-Bytecodes.stackEffectOf(opcode) + slots);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                Symbol<Symbol.Type>[] parsed = this.getInvokeSignature(bci, opcode);
                stack.pop(Signatures.slotsForParameters(parsed));
                if (opcode != 184 && opcode != 186) {
                    stack.pop();
                }
                stack.push(bci, StackType.forType(Signatures.returnType(parsed)));
                break;
            }
        }
        if (!endOfFlow) {
            this.registerStack(stack, nextBci);
        }
        Iterator iterator = branches.iterator();
        while (iterator.hasNext()) {
            int branch = (Integer)iterator.next();
            this.registerStack(stack, branch);
        }
    }

    Symbol<Symbol.Name> getFieldName(int bci) {
        char cpi = this.bs.readCPI(bci);
        return this.m.getConstantPool().fieldAt(cpi).getName(this.m.getConstantPool());
    }

    Symbol<Symbol.Type> getFieldType(int bci) {
        char cpi = this.bs.readCPI(bci);
        return this.m.getConstantPool().fieldAt(cpi).getType(this.m.getConstantPool());
    }

    Symbol<Symbol.Name> getInvokeName(int bci, int opcode) {
        assert (Bytecodes.isInvoke(opcode));
        char cpi = this.bs.readCPI(bci);
        if (opcode == 186) {
            return this.m.getConstantPool().indyAt(cpi).getName(this.m.getConstantPool());
        }
        return this.m.getConstantPool().methodAt(cpi).getName(this.m.getConstantPool());
    }

    Symbol<Symbol.Type>[] getInvokeSignature(int bci, int opcode) {
        assert (Bytecodes.isInvoke(opcode));
        char cpi = this.bs.readCPI(bci);
        Symbol<Symbol.Signature> sig = opcode == 186 ? this.m.getConstantPool().indyAt(cpi).getSignature(this.m.getConstantPool()) : this.m.getConstantPool().methodAt(cpi).getSignature(this.m.getConstantPool());
        return this.getSignatures().parsed(sig);
    }

    SimulatedStack stackAt(int bci) {
        return this.stacks[bci];
    }

    private void registerStack(SimulatedStack stack, int nextBci) {
        SimulatedStack oldStack = this.stacks[nextBci];
        if (oldStack == null) {
            this.newStackInfo = true;
            this.entries += stack.size();
        }
        this.stacks[nextBci] = SimulatedStack.merge(stack, oldStack);
    }
}

