/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.hierarchy;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;

final class ClassHierarchyAssumptionImpl
implements ClassHierarchyAssumption {
    static final ClassHierarchyAssumption AlwaysValid = new ClassHierarchyAssumptionImpl(Assumption.ALWAYS_VALID);
    static final ClassHierarchyAssumption NeverValid = new ClassHierarchyAssumptionImpl(Assumption.NEVER_VALID);
    private final Assumption underlying;

    private ClassHierarchyAssumptionImpl(Assumption underlyingAssumption) {
        this.underlying = underlyingAssumption;
    }

    private ClassHierarchyAssumptionImpl(String assumptionName) {
        this.underlying = Truffle.getRuntime().createAssumption(assumptionName);
    }

    ClassHierarchyAssumptionImpl(ObjectKlass klass) {
        this(klass.getNameAsString() + " has no concrete subclasses");
    }

    ClassHierarchyAssumptionImpl(Method method) {
        this(method.toString() + " is leaf");
    }

    @Override
    public Assumption getAssumption() {
        return this.underlying;
    }
}

