/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.runtime.Attribute;

public final class MethodParametersAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.MethodParameters;
    public static final MethodParametersAttribute EMPTY = new MethodParametersAttribute(NAME, Entry.EMPTY_ARRAY);
    private final Entry[] entries;

    public Entry[] getEntries() {
        return this.entries;
    }

    public MethodParametersAttribute(Symbol<Symbol.Name> name, Entry[] entries) {
        super(name, null);
        this.entries = entries;
    }

    @Override
    public boolean sameAs(Attribute other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.sameAs(other)) {
            return false;
        }
        MethodParametersAttribute that = (MethodParametersAttribute)other;
        return this.entriesSameAs(that.entries);
    }

    private boolean entriesSameAs(Entry[] otherEntries) {
        if (this.entries.length != otherEntries.length) {
            return false;
        }
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i].sameAs(otherEntries[i])) continue;
            return false;
        }
        return true;
    }

    public static final class Entry {
        public static final Entry[] EMPTY_ARRAY = new Entry[0];
        private final int nameIndex;
        private final int accessFlags;

        public Entry(int nameIndex, int accessFlags) {
            this.nameIndex = nameIndex;
            this.accessFlags = accessFlags;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getAccessFlags() {
            return this.accessFlags;
        }

        public boolean sameAs(Entry otherEntry) {
            return this.nameIndex == otherEntry.nameIndex && this.accessFlags == otherEntry.accessFlags;
        }
    }
}

