/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.InterfaceMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.Objects;

public interface ClassMethodRefConstant
extends MethodRefConstant {
    public static ClassMethodRefConstant create(int classIndex, int nameAndTypeIndex) {
        return new Indexes(classIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.METHOD_REF;
    }

    public static final class Indexes
    extends MethodRefConstant.Indexes
    implements ClassMethodRefConstant,
    Resolvable {
        Indexes(int classIndex, int nameAndTypeIndex) {
            super(classIndex, nameAndTypeIndex);
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            Symbol<Symbol.Signature> signature;
            METHODREF_RESOLVE_COUNT.inc();
            EspressoContext context = pool.getContext();
            Klass holderKlass = this.getResolvedHolderKlass(accessingKlass, pool);
            Meta meta = context.getMeta();
            if (holderKlass.isInterface()) {
                throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, meta.toGuestString(this.getName(pool)));
            }
            Symbol<Symbol.Name> name = this.getName(pool);
            Method method = holderKlass.lookupMethod(name, signature = this.getSignature(pool));
            if (method == null) {
                throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, meta.toGuestString(holderKlass.getNameAsString() + "." + String.valueOf(this.getName(pool)) + String.valueOf(signature)));
            }
            MemberRefConstant.doAccessCheck(accessingKlass, holderKlass, method, meta);
            if (!method.isPolySignatureIntrinsic()) {
                method.checkLoadingConstraints(accessingKlass.getDefiningClassLoader(), method.getDeclaringKlass().getDefiningClassLoader());
            }
            return new Resolved(method);
        }

        @Override
        public void validate(ConstantPool pool) {
            Symbol<? extends Symbol.Descriptor> descriptor;
            int len;
            super.validate(pool);
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateMethod(pool, false, true);
            Symbol<Symbol.Name> name = pool.nameAndTypeAt(this.nameAndTypeIndex).getName(pool);
            if (Symbol.Name._init_.equals(name) && ((len = (descriptor = pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool)).length()) <= 2 || descriptor.byteAt(len - 2) != 41 || descriptor.byteAt(len - 1) != 86)) {
                throw ConstantPool.classFormatError("<init> method should have ()V signature");
            }
        }
    }

    public static final class Resolved
    implements InterfaceMethodRefConstant,
    Resolvable.ResolvedConstant {
        private final Method resolved;

        Resolved(Method resolved) {
            this.resolved = Objects.requireNonNull(resolved);
        }

        @Override
        public Method value() {
            return this.resolved;
        }

        @Override
        public Symbol<Symbol.Name> getHolderKlassName(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("Method already resolved");
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            return this.resolved.getRawSignature();
        }
    }
}

