/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.StepConfig;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.jdwp.api.CallFrame;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.JDWPOptions;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.MonitorStackInfo;
import com.oracle.truffle.espresso.jdwp.api.VMEventListener;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerCommand;
import com.oracle.truffle.espresso.jdwp.impl.EventFilters;
import com.oracle.truffle.espresso.jdwp.impl.FieldBreakpointEvent;
import com.oracle.truffle.espresso.jdwp.impl.FieldBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.GCPrevention;
import com.oracle.truffle.espresso.jdwp.impl.JDWPInstrument;
import com.oracle.truffle.espresso.jdwp.impl.MethodBreakpointEvent;
import com.oracle.truffle.espresso.jdwp.impl.NoSuchSourceLineException;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import com.oracle.truffle.espresso.jdwp.impl.SimpleLock;
import com.oracle.truffle.espresso.jdwp.impl.SourceLocation;
import com.oracle.truffle.espresso.jdwp.impl.StepInfo;
import com.oracle.truffle.espresso.jdwp.impl.SteppingInfo;
import com.oracle.truffle.espresso.jdwp.impl.SuspendedInfo;
import com.oracle.truffle.espresso.jdwp.impl.ThreadJob;
import com.oracle.truffle.espresso.jdwp.impl.ThreadSuspension;
import com.oracle.truffle.espresso.jdwp.impl.TypeTag;
import com.oracle.truffle.espresso.jdwp.impl.UnknownSuspendedInfo;
import com.oracle.truffle.espresso.jdwp.impl.VirtualMachine;
import com.oracle.truffle.espresso.jdwp.impl.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Pattern;

public final class DebuggerController
implements ContextsListener {
    private static final StepConfig STEP_CONFIG = StepConfig.newBuilder().suspendAnchors(SourceElement.ROOT, new SuspendAnchor[]{SuspendAnchor.AFTER}).build();
    private final Map<Object, SimpleLock> suspendLocks = Collections.synchronizedMap(new HashMap());
    private final Map<Object, SuspendedInfo> suspendedInfos = Collections.synchronizedMap(new HashMap());
    private final Map<Object, SteppingInfo> commandRequestIds = new HashMap<Object, SteppingInfo>();
    private final Map<Object, ThreadJob<?>> threadJobs = new HashMap();
    private final Map<Object, FieldBreakpointEvent> fieldBreakpointExpected = new HashMap<Object, FieldBreakpointEvent>();
    private final Map<Object, MethodBreakpointEvent> methodBreakpointExpected = new HashMap<Object, MethodBreakpointEvent>();
    private final Map<Breakpoint, BreakpointInfo> breakpointInfos = new HashMap<Breakpoint, BreakpointInfo>();
    private JDWPOptions options;
    private DebuggerSession debuggerSession;
    private final JDWPInstrument instrument;
    private Ids<Object> ids;
    private JDWPContext context;
    private final VirtualMachine vm;
    private Debugger debugger;
    private final GCPrevention gcPrevention;
    private final ThreadSuspension threadSuspension;
    private final EventFilters eventFilters;
    private VMEventListener eventListener;
    private TruffleContext truffleContext;
    private Object initialThread;
    private final TruffleLogger jdwpLogger;

    public DebuggerController(JDWPInstrument instrument, TruffleLogger logger) {
        this.instrument = instrument;
        this.vm = new VirtualMachineImpl();
        this.gcPrevention = new GCPrevention();
        this.threadSuspension = new ThreadSuspension();
        this.eventFilters = new EventFilters();
        this.jdwpLogger = logger;
    }

    public void initialize(Debugger debug, JDWPOptions jdwpOptions, JDWPContext jdwpContext, Object thread, VMEventListener vmEventListener) {
        this.debugger = debug;
        this.options = jdwpOptions;
        this.context = jdwpContext;
        this.ids = jdwpContext.getIds();
        this.eventListener = vmEventListener;
        this.initialThread = thread;
        this.debuggerSession = debug.startSession((SuspendedCallback)new SuspendedCallbackImpl(), new SourceElement[]{SourceElement.ROOT, SourceElement.STATEMENT});
        this.debuggerSession.setSteppingFilter(SuspensionFilter.newBuilder().ignoreLanguageContextInitialization(true).build());
        this.instrument.init(jdwpContext);
    }

    public void reInitialize() {
        this.initialize(this.debugger, this.options, this.context, this.initialThread, this.eventListener);
    }

    public JDWPContext getContext() {
        return this.context;
    }

    public SuspendedInfo getSuspendedInfo(Object thread) {
        return this.suspendedInfos.get(thread);
    }

    public boolean isSuspend() {
        return this.options.suspend;
    }

    public boolean isServer() {
        return this.options.server;
    }

    public int getListeningPort() {
        return Integer.parseInt(this.options.port);
    }

    public String getHost() {
        return this.options.host;
    }

    public void setCommandRequestId(Object thread, int commandRequestId, byte suspendPolicy, boolean isPopFrames, boolean isForceEarlyReturn, DebuggerCommand.Kind stepKind) {
        this.fine(() -> "Adding step command request in thread " + this.getThreadName(thread) + " with ID: " + commandRequestId);
        this.commandRequestIds.put(thread, new SteppingInfo(commandRequestId, suspendPolicy, isPopFrames, isForceEarlyReturn, stepKind));
    }

    public void submitLineBreakpoint(DebuggerCommand command) {
        SourceLocation location = command.getSourceLocation();
        try {
            Breakpoint bp = Breakpoint.newBuilder((Source)location.getSource()).lineIs(location.getLineNumber()).build();
            bp.setEnabled(true);
            int ignoreCount = command.getRequestFilter().getIgnoreCount();
            if (ignoreCount > 0) {
                bp.setIgnoreCount(ignoreCount);
            }
            this.mapBreakpoint(bp, command.getBreakpointInfo());
            this.fine(() -> "Submitting breakpoint at " + bp.getLocationDescription());
            this.debuggerSession.install(bp);
            this.fine(() -> "Breakpoint submitted at " + bp.getLocationDescription());
        }
        catch (NoSuchSourceLineException ex) {
            this.warning(() -> "Failed submitting breakpoint at non-existing location: " + String.valueOf(location));
        }
    }

    public void submitMethodEntryBreakpoint(DebuggerCommand debuggerCommand) {
        KlassRef[] klasses = debuggerCommand.getRequestFilter().getKlassRefPatterns();
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        for (KlassRef klass : klasses) {
            for (MethodRef method : klass.getDeclaredMethodRefs()) {
                int line = method.getFirstLine();
                Breakpoint bp = line != -1 ? Breakpoint.newBuilder((Source)method.getSource()).lineIs(line).build() : Breakpoint.newBuilder((SourceSection)method.getSource().createUnavailableSection()).build();
                breakpoints.add(bp);
            }
        }
        BreakpointInfo breakpointInfo = debuggerCommand.getBreakpointInfo();
        for (Breakpoint breakpoint : breakpoints) {
            this.mapBreakpoint(breakpoint, breakpointInfo);
            this.debuggerSession.install(breakpoint);
        }
    }

    public void submitExceptionBreakpoint(DebuggerCommand command) {
        Breakpoint bp = Breakpoint.newExceptionBuilder((boolean)command.getBreakpointInfo().isCaught(), (boolean)command.getBreakpointInfo().isUnCaught()).build();
        bp.setEnabled(true);
        int ignoreCount = command.getBreakpointInfo().getFilter().getIgnoreCount();
        if (ignoreCount > 0) {
            bp.setIgnoreCount(ignoreCount);
        }
        this.mapBreakpoint(bp, command.getBreakpointInfo());
        this.debuggerSession.install(bp);
        this.fine(() -> "exception breakpoint submitted");
    }

    @CompilerDirectives.TruffleBoundary
    private void mapBreakpoint(Breakpoint bp, BreakpointInfo info) {
        this.breakpointInfos.put(bp, info);
        info.addBreakpoint(bp);
    }

    public void clearBreakpoints() {
        for (Breakpoint breakpoint : this.debuggerSession.getBreakpoints()) {
            breakpoint.dispose();
        }
    }

    public void stepOut(RequestFilter filter) {
        Object thread = filter.getStepInfo().getGuestThread();
        this.fine(() -> "STEP_OUT for thread: " + this.getThreadName(thread));
        SuspendedInfo susp = this.suspendedInfos.get(thread);
        if (susp != null && !(susp instanceof UnknownSuspendedInfo)) {
            this.doStepOut(susp);
        } else {
            this.fine(() -> "not STEPPING OUT for thread: " + this.getThreadName(thread));
        }
    }

    private void doStepOut(SuspendedInfo susp) {
        MethodRef method;
        RootNode callerRoot = susp.getCallerRootNode();
        int stepOutBCI = this.context.getNextBCI(callerRoot, susp.getCallerFrame());
        SteppingInfo steppingInfo = this.commandRequestIds.get(susp.getThread());
        if (steppingInfo != null && stepOutBCI != -1 && (method = this.context.getMethodFromRootNode(callerRoot)) != null) {
            KlassRef klass = method.getDeclaringKlassRef();
            steppingInfo.setStepOutBCI(this.context.getIds().getIdAsLong(klass), this.context.getIds().getIdAsLong(method), stepOutBCI);
        }
    }

    public void clearStepCommand(StepInfo stepInfo) {
        this.commandRequestIds.remove(stepInfo.getGuestThread());
    }

    public boolean popFrames(Object guestThread, CallFrame frameToPop, int packetId) {
        SuspendedInfo susp = this.suspendedInfos.get(guestThread);
        if (susp != null && !(susp instanceof UnknownSuspendedInfo)) {
            susp.getEvent().prepareUnwindFrame(frameToPop.getDebugStackFrame());
            this.setCommandRequestId(guestThread, packetId, (byte)1, true, false, DebuggerCommand.Kind.SPECIAL_STEP);
            this.resume(guestThread, false);
            return true;
        }
        return false;
    }

    public boolean forceEarlyReturn(Object guestThread, CallFrame frame, Object returnValue) {
        SuspendedInfo susp = this.suspendedInfos.get(guestThread);
        if (susp != null && !(susp instanceof UnknownSuspendedInfo)) {
            susp.getEvent().prepareUnwindFrame(frame.getDebugStackFrame(), frame.asDebugValue(returnValue));
            susp.setForceEarlyReturnInProgress();
            this.setCommandRequestId(guestThread, -1, (byte)0, false, true, DebuggerCommand.Kind.SPECIAL_STEP);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume(Object thread, boolean sessionClosed) {
        SimpleLock lock;
        SimpleLock simpleLock = lock = this.getSuspendLock(thread);
        synchronized (simpleLock) {
            this.fine(() -> "Called resume thread: " + this.getThreadName(thread) + " with suspension count: " + this.threadSuspension.getSuspensionCount(thread));
            if (this.threadSuspension.getSuspensionCount(thread) == 0) {
                return true;
            }
            this.threadSuspension.resumeThread(thread);
            int suspensionCount = this.threadSuspension.getSuspensionCount(thread);
            if (suspensionCount == 0) {
                DebuggerCommand.Kind stepKind;
                SuspendedInfo suspendedInfo = this.getSuspendedInfo(thread);
                SteppingInfo steppingInfo = this.commandRequestIds.get(thread);
                if (steppingInfo == null) {
                    if (!sessionClosed) {
                        try {
                            this.fine(() -> "calling underlying resume method for thread: " + this.getThreadName(thread));
                            this.debuggerSession.resume(this.getContext().asHostThread(thread));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to resume thread: " + this.getThreadName(thread), e);
                        }
                    }
                } else if (suspendedInfo != null && !suspendedInfo.isForceEarlyReturnInProgress() && (stepKind = steppingInfo.getStepKind()) != null) {
                    switch (stepKind) {
                        case STEP_INTO: {
                            suspendedInfo.getEvent().prepareStepInto(STEP_CONFIG);
                            break;
                        }
                        case STEP_OVER: {
                            suspendedInfo.getEvent().prepareStepOver(STEP_CONFIG);
                            break;
                        }
                        case STEP_OUT: {
                            suspendedInfo.getEvent().prepareStepOut(STEP_CONFIG);
                            break;
                        }
                        case SUBMIT_EXCEPTION_BREAKPOINT: 
                        case SUBMIT_LINE_BREAKPOINT: 
                        case SPECIAL_STEP: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("should not reach here");
                        }
                    }
                }
                this.fine(() -> "resume call, clearing suspended info on: " + this.getThreadName(thread));
                this.suspendedInfos.put(thread, null);
                this.fine(() -> "Waking up thread: " + this.getThreadName(thread));
                this.threadSuspension.removeHardSuspendedThread(thread);
                lock.release();
                lock.notifyAll();
                return true;
            }
            this.fine(() -> "Not resuming thread: " + this.getThreadName(thread) + " with suspension count: " + this.threadSuspension.getSuspensionCount(thread));
            return false;
        }
    }

    public Object[] getVisibleGuestThreads() {
        Object[] allThreads = this.context.getAllGuestThreads();
        ArrayList<Object> visibleThreads = new ArrayList<Object>(allThreads.length);
        for (Object thread : allThreads) {
            if (this.instrument.isVMThread(this.context.asHostThread(thread))) continue;
            visibleThreads.add(thread);
        }
        return visibleThreads.toArray(new Object[visibleThreads.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceResumeAll() {
        for (Object thread : this.getVisibleGuestThreads()) {
            SimpleLock suspendLock;
            boolean resumed = false;
            SimpleLock simpleLock = suspendLock = this.getSuspendLock(thread);
            synchronized (simpleLock) {
                while (!resumed) {
                    resumed = this.resume(thread, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll() {
        for (Object thread : this.getVisibleGuestThreads()) {
            SimpleLock suspendLock;
            SimpleLock simpleLock = suspendLock = this.getSuspendLock(thread);
            synchronized (simpleLock) {
                this.resume(thread, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Object guestThread) {
        SimpleLock suspendLock;
        SimpleLock simpleLock = suspendLock = this.getSuspendLock(guestThread);
        synchronized (simpleLock) {
            this.fine(() -> "suspend called for guestThread: " + this.getThreadName(guestThread) + " with suspension count " + this.threadSuspension.getSuspensionCount(guestThread));
            if (this.threadSuspension.getSuspensionCount(guestThread) > 0) {
                this.threadSuspension.suspendThread(guestThread);
                return;
            }
            try {
                this.fine(() -> "State: " + String.valueOf((Object)this.getContext().asHostThread(guestThread).getState()));
                this.fine(() -> "calling underlying suspend method for guestThread: " + this.getThreadName(guestThread));
                this.debuggerSession.suspend(this.getContext().asHostThread(guestThread));
                this.threadSuspension.addHardSuspendedThread(guestThread);
                if (this.suspendedInfos.get(guestThread) == null) {
                    this.suspendedInfos.put(guestThread, new UnknownSuspendedInfo(guestThread, this.getContext()));
                }
            }
            catch (Exception e) {
                this.fine(() -> "not able to suspend guestThread: " + this.getThreadName(guestThread));
            }
        }
    }

    public void immediateSuspend(Object eventThread, byte suspendPolicy, Callable<Void> callBack) {
        assert (eventThread == this.context.asGuestThread(Thread.currentThread()));
        switch (suspendPolicy) {
            case 2: {
                for (Object thread : this.getVisibleGuestThreads()) {
                    if (this.context.asGuestThread(Thread.currentThread()) == thread) continue;
                    this.suspend(thread);
                }
                this.suspend(eventThread, (byte)1, Collections.singletonList(callBack), true);
                break;
            }
            case 1: {
                this.suspend(eventThread, (byte)1, Collections.singletonList(callBack), true);
            }
        }
    }

    public void suspendAll() {
        this.fine(() -> "Called suspendAll");
        for (Object thread : this.getVisibleGuestThreads()) {
            this.suspend(thread);
        }
    }

    private synchronized SimpleLock getSuspendLock(Object thread) {
        SimpleLock lock = this.suspendLocks.get(thread);
        if (lock == null) {
            lock = new SimpleLock();
            this.suspendLocks.put(thread, lock);
        }
        return lock;
    }

    private String getThreadName(Object thread) {
        return this.getContext().getThreadName(thread);
    }

    public void disposeDebugger(final boolean prepareReconnect) {
        if (!prepareReconnect && this.eventListener.vmDied()) {
            this.suspend(this.context.asGuestThread(Thread.currentThread()), (byte)1, Collections.emptyList(), true);
        }
        new Thread(new Runnable(){
            final /* synthetic */ DebuggerController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.instrument.reset(prepareReconnect);
            }
        }).start();
    }

    public void endSession() {
        try {
            this.debuggerSession.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public JDWPOptions getOptions() {
        return this.options;
    }

    public void prepareFieldBreakpoint(FieldBreakpointEvent event) {
        this.fieldBreakpointExpected.put(Thread.currentThread(), event);
    }

    public void prepareMethodBreakpoint(MethodBreakpointEvent event) {
        this.methodBreakpointExpected.put(Thread.currentThread(), event);
    }

    public VirtualMachine getVirtualMachine() {
        return this.vm;
    }

    public GCPrevention getGCPrevention() {
        return this.gcPrevention;
    }

    public ThreadSuspension getThreadSuspension() {
        return this.threadSuspension;
    }

    public EventFilters getEventFilters() {
        return this.eventFilters;
    }

    public VMEventListener getEventListener() {
        return this.eventListener;
    }

    public Object enterTruffleContext() {
        if (this.truffleContext != null) {
            return this.truffleContext.enter(null);
        }
        return null;
    }

    public void leaveTruffleContext(Object previous) {
        if (this.truffleContext != null) {
            this.truffleContext.leave(null, previous);
        }
    }

    public void onLanguageContextInitialized(TruffleContext con, LanguageInfo language) {
        this.truffleContext = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(final Object thread, byte suspendPolicy, List<Callable<Void>> jobs, boolean forceSuspend) {
        SimpleLock suspendLock;
        this.fine(() -> "suspending from callback in thread: " + this.getThreadName(thread));
        SimpleLock simpleLock = suspendLock = this.getSuspendLock(thread);
        synchronized (simpleLock) {
            suspendLock.acquire();
        }
        switch (suspendPolicy) {
            case 0: {
                DebuggerController.runJobs(jobs);
                break;
            }
            case 1: {
                this.fine(() -> "Suspend EVENT_THREAD");
                this.suspendEventThread(thread, forceSuspend, jobs);
                break;
            }
            case 2: {
                this.fine(() -> "Suspend ALL");
                Thread suspendThread = new Thread(new Runnable(){
                    final /* synthetic */ DebuggerController this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        for (Object activeThread : this.this$0.getVisibleGuestThreads()) {
                            if (activeThread == thread) continue;
                            this.this$0.fine(() -> "Request thread suspend for other thread: " + this.this$0.getThreadName(activeThread));
                            this.this$0.suspend(activeThread);
                        }
                    }
                });
                suspendThread.start();
                this.suspendEventThread(thread, forceSuspend, jobs);
            }
        }
    }

    private static void runJobs(List<Callable<Void>> jobs) {
        for (Callable<Void> job : jobs) {
            try {
                job.call();
            }
            catch (Exception e) {
                throw new RuntimeException("failed to send event to debugger", e);
            }
        }
    }

    private void suspendEventThread(Object thread, boolean forceSuspend, List<Callable<Void>> jobs) {
        this.fine(() -> "Suspending event thread: " + this.getThreadName(thread) + " with new suspension count: " + this.threadSuspension.getSuspensionCount(thread));
        this.lockThread(thread, forceSuspend, true, jobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockThread(Object thread, boolean forceSuspend, boolean isFirstCall, List<Callable<Void>> jobs) {
        SimpleLock lock = this.getSuspendLock(thread);
        this.checkThreadJobsAndRun(thread, forceSuspend);
        SimpleLock simpleLock = lock;
        synchronized (simpleLock) {
            if (!forceSuspend && !this.threadSuspension.isHardSuspended(thread)) {
                return;
            }
            try {
                if (lock.isLocked() && isFirstCall) {
                    this.threadSuspension.suspendThread(thread);
                    DebuggerController.runJobs(jobs);
                }
                while (lock.isLocked()) {
                    this.fine(() -> "lock.wait() for thread: " + this.getThreadName(thread));
                    this.threadSuspension.removeHardSuspendedThread(thread);
                    lock.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.checkThreadJobsAndRun(thread, forceSuspend);
        this.getGCPrevention().releaseActiveWhileSuspended(thread);
        this.fine(() -> "lock wakeup for thread: " + this.getThreadName(thread));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreadJobsAndRun(Object thread, boolean forceSuspend) {
        if (this.threadJobs.containsKey(thread)) {
            SimpleLock suspendLock;
            SimpleLock simpleLock = suspendLock = this.getSuspendLock(thread);
            synchronized (simpleLock) {
                suspendLock.acquire();
            }
            ThreadJob<?> job = this.threadJobs.remove(thread);
            byte suspensionStrategy = job.getSuspensionStrategy();
            if (suspensionStrategy == 2) {
                Object[] allThreads;
                for (Object activeThread : allThreads = this.getVisibleGuestThreads()) {
                    if (activeThread == thread) continue;
                    this.resume(activeThread, false);
                }
                job.runJob();
                for (Object activeThread : allThreads) {
                    if (activeThread == thread) continue;
                    this.suspend(activeThread);
                }
            } else {
                job.runJob();
            }
            this.lockThread(thread, forceSuspend, false, Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postJobForThread(ThreadJob<?> job) {
        SimpleLock lock;
        SimpleLock simpleLock = lock = this.getSuspendLock(job.getThread());
        synchronized (simpleLock) {
            this.threadJobs.put(job.getThread(), job);
            lock.release();
            lock.notifyAll();
        }
    }

    public CallFrame[] captureCallFramesBeforeBlocking(final Object guestThread) {
        final ArrayList callFrames = new ArrayList();
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(this){
            final /* synthetic */ DebuggerController this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitFrame(FrameInstance frameInstance) {
                CallTarget callTarget;
                Node currentNode;
                long lastLineBCI;
                RootNode root = this.this$0.getRootNode(frameInstance);
                if (root == null) {
                    return null;
                }
                MethodRef method = this.this$0.getContext().getMethodFromRootNode(root);
                if (method == null) {
                    return null;
                }
                KlassRef klass = method.getDeclaringKlassRef();
                long klassId = this.this$0.ids.getIdAsLong(klass);
                long methodId = this.this$0.ids.getIdAsLong(method);
                byte typeTag = TypeTag.getKind(klass);
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE);
                long codeIndex = -1L;
                try {
                    codeIndex = this.this$0.context.readBCIFromFrame(root, frame);
                }
                catch (Throwable t) {
                    this.this$0.fine(() -> "Unable to read current BCI from frame in method: " + klass.getNameAsString() + "." + method.getNameAsString());
                }
                if (codeIndex == -1L) {
                    codeIndex = 0L;
                }
                if (codeIndex > (lastLineBCI = method.getBCIFromLine(method.getLastLine()))) {
                    codeIndex = lastLineBCI;
                }
                if ((currentNode = frameInstance.getCallNode()) == null && (callTarget = frameInstance.getCallTarget()) instanceof RootCallTarget) {
                    currentNode = ((RootCallTarget)callTarget).getRootNode();
                }
                if (currentNode instanceof RootNode) {
                    currentNode = this.this$0.context.getInstrumentableNode((RootNode)currentNode);
                }
                callFrames.add(new CallFrame(this.this$0.context.getIds().getIdAsLong(guestThread), typeTag, klassId, method, methodId, codeIndex, frame, currentNode, root, null, this.this$0.context, this.this$0));
                return null;
            }
        });
        CallFrame[] result = callFrames.toArray(new CallFrame[callFrames.size()]);
        MonitorStackInfo[] ownedMonitorInfos = this.context.getOwnedMonitors(result);
        HashMap<Object, Integer> entryCounts = new HashMap<Object, Integer>(ownedMonitorInfos.length);
        for (MonitorStackInfo ownedMonitorInfo : ownedMonitorInfos) {
            Object monitor = ownedMonitorInfo.getMonitor();
            entryCounts.put(monitor, this.context.getMonitorEntryCount(monitor));
        }
        this.suspendedInfos.put(guestThread, new SuspendedInfo(this.context, result, guestThread, entryCounts));
        return result;
    }

    private RootNode getRootNode(FrameInstance frameInstance) {
        CallTarget callTarget = frameInstance.getCallTarget();
        if (callTarget == null) {
            return null;
        }
        if (callTarget instanceof RootCallTarget) {
            RootCallTarget rootCallTarget = (RootCallTarget)callTarget;
            RootNode rootNode = rootCallTarget.getRootNode();
            try {
                this.context.readBCIFromFrame(rootNode, frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY));
            }
            catch (Throwable t) {
                return null;
            }
            return rootNode;
        }
        return null;
    }

    public void cancelBlockingCallFrames(Object guestThread) {
        this.suspendedInfos.remove(guestThread);
    }

    private boolean isSingleSteppingSuspended() {
        return this.context.isSingleSteppingDisabled();
    }

    public void info(Supplier<String> supplier) {
        this.jdwpLogger.info(supplier);
    }

    public void fine(Supplier<String> supplier) {
        this.jdwpLogger.fine(supplier);
    }

    public void finest(Supplier<String> supplier) {
        this.jdwpLogger.finest(supplier);
    }

    public void warning(Supplier<String> supplier) {
        this.jdwpLogger.warning(supplier);
    }

    public void severe(Supplier<String> supplier) {
        this.jdwpLogger.severe(supplier);
    }

    public void severe(String message, Throwable error) {
        this.jdwpLogger.log(Level.SEVERE, message, error);
    }

    public void onContextCreated(TruffleContext con) {
    }

    public void onLanguageContextCreated(TruffleContext con, LanguageInfo language) {
    }

    public void onLanguageContextFinalized(TruffleContext con, LanguageInfo language) {
    }

    public void onLanguageContextDisposed(TruffleContext con, LanguageInfo language) {
    }

    public void onContextClosed(TruffleContext con) {
    }

    private class SuspendedCallbackImpl
    implements SuspendedCallback {
        private SuspendedCallbackImpl() {
        }

        public void onSuspend(SuspendedEvent event) {
            MethodBreakpointEvent methodEvent;
            CallFrame[] callFrames;
            Thread hostThread = Thread.currentThread();
            if (DebuggerController.this.instrument.isVMThread(hostThread)) {
                return;
            }
            if (!DebuggerController.this.instrument.hasConnection()) {
                return;
            }
            final Object currentThread = DebuggerController.this.getContext().asGuestThread(hostThread);
            DebuggerController.this.fine(() -> "Suspended at: " + String.valueOf(event.getSourceSection()) + " in thread: " + DebuggerController.this.getThreadName(currentThread));
            final SteppingInfo steppingInfo = DebuggerController.this.commandRequestIds.remove(currentThread);
            if (steppingInfo != null) {
                if (steppingInfo.isForceEarlyReturn()) {
                    DebuggerController.this.fine(() -> "not suspending here due to force early return: " + String.valueOf(event.getSourceSection()));
                    return;
                }
                callFrames = this.createCallFrames(DebuggerController.this.ids.getIdAsLong(currentThread), event.getStackFrames(), 1, steppingInfo);
                if (this.checkExclusionFilters(steppingInfo, event, currentThread, callFrames[0])) {
                    DebuggerController.this.fine(() -> "not suspending here: " + String.valueOf(event.getSourceSection()));
                    DebuggerController.this.commandRequestIds.put(currentThread, steppingInfo);
                    return;
                }
            }
            RootNode callerRootNode = (callFrames = this.createCallFrames(DebuggerController.this.ids.getIdAsLong(currentThread), event.getStackFrames(), -1, steppingInfo)).length > 1 ? callFrames[1].getRootNode() : null;
            SuspendedInfo suspendedInfo = new SuspendedInfo(DebuggerController.this, event, callFrames, currentThread, callerRootNode);
            DebuggerController.this.suspendedInfos.put(currentThread, suspendedInfo);
            byte suspendPolicy = 1;
            ArrayList<Callable<Void>> jobs = new ArrayList<Callable<Void>>();
            boolean hit = false;
            boolean handledLineBreakpoint = false;
            HashSet<Breakpoint> handled = new HashSet<Breakpoint>(event.getBreakpoints().size());
            for (Breakpoint bp : event.getBreakpoints()) {
                if (handled.contains(bp)) continue;
                final BreakpointInfo info = DebuggerController.this.breakpointInfos.get(bp);
                suspendPolicy = info.getSuspendPolicy();
                if (info.isLineBreakpoint()) {
                    if (handledLineBreakpoint) continue;
                    handledLineBreakpoint = true;
                    hit = true;
                    Object thread = info.getThread();
                    if (thread == null || thread == currentThread) {
                        jobs.add(new Callable<Void>(this){
                            final /* synthetic */ SuspendedCallbackImpl this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public Void call() {
                                this.this$1.DebuggerController.this.eventListener.breakpointHit(info, callFrames[0], currentThread);
                                return null;
                            }
                        });
                    }
                } else if (info.isExceptionBreakpoint()) {
                    Throwable exception = event.getException().getRawException(DebuggerController.this.context.getLanguageClass());
                    if (exception == null) {
                        DebuggerController.this.fine(() -> "Unable to retrieve raw exception for " + String.valueOf(event.getException()));
                        return;
                    }
                    final Object guestException = DebuggerController.this.getContext().getGuestException(exception);
                    DebuggerController.this.fine(() -> "checking exception breakpoint for exception: " + String.valueOf(exception));
                    KlassRef klass = info.getKlass();
                    if (klass == null) {
                        hit = true;
                    } else if (klass == null || DebuggerController.this.getContext().isInstanceOf(guestException, klass)) {
                        Pattern[] negativePatterns;
                        DebuggerController.this.fine(() -> "Exception type matched the klass type: " + klass.getNameAsString());
                        Pattern[] positivePatterns = info.getFilter().getIncludePatterns();
                        if (!(positivePatterns != null && positivePatterns.length != 0 && !this.matchLocation(positivePatterns, callFrames[0]) || (negativePatterns = info.getFilter().getExcludePatterns()) != null && negativePatterns.length != 0 && this.matchLocation(negativePatterns, callFrames[0]))) {
                            hit = true;
                        }
                    }
                    if (hit) {
                        DebuggerController.this.fine(() -> "Breakpoint hit in thread: " + DebuggerController.this.getThreadName(currentThread));
                        jobs.add(new Callable<Void>(this){
                            final /* synthetic */ SuspendedCallbackImpl this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public Void call() {
                                this.this$1.DebuggerController.this.eventListener.exceptionThrown(info, currentThread, guestException, callFrames);
                                return null;
                            }
                        });
                    } else {
                        DebuggerController.this.suspendedInfos.put(currentThread, null);
                        return;
                    }
                }
                handled.add(bp);
            }
            final FieldBreakpointEvent fieldEvent = DebuggerController.this.fieldBreakpointExpected.remove(Thread.currentThread());
            if (fieldEvent != null) {
                FieldBreakpointInfo info = fieldEvent.getInfo();
                if (info.isAccessBreakpoint()) {
                    hit = true;
                    jobs.add(new Callable<Void>(this){
                        final /* synthetic */ SuspendedCallbackImpl this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public Void call() {
                            this.this$1.DebuggerController.this.eventListener.fieldAccessBreakpointHit(fieldEvent, currentThread, callFrames[0]);
                            return null;
                        }
                    });
                } else if (info.isModificationBreakpoint()) {
                    hit = true;
                    jobs.add(new Callable<Void>(this){
                        final /* synthetic */ SuspendedCallbackImpl this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public Void call() {
                            this.this$1.DebuggerController.this.eventListener.fieldModificationBreakpointHit(fieldEvent, currentThread, callFrames[0]);
                            return null;
                        }
                    });
                }
            }
            if ((methodEvent = DebuggerController.this.methodBreakpointExpected.remove(Thread.currentThread())) != null) {
                hit = true;
                jobs.add(new Callable<Void>(this){
                    final /* synthetic */ SuspendedCallbackImpl this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Void call() {
                        this.this$1.DebuggerController.this.eventListener.methodBreakpointHit(methodEvent, currentThread, callFrames[0]);
                        return null;
                    }
                });
            }
            if (steppingInfo != null) {
                jobs.add(new Callable<Void>(this){
                    final /* synthetic */ SuspendedCallbackImpl this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Void call() {
                        this.this$1.DebuggerController.this.eventListener.stepCompleted(steppingInfo, callFrames[0]);
                        return null;
                    }
                });
            }
            DebuggerController.this.suspend(currentThread, suspendPolicy, jobs, hit || steppingInfo != null);
        }

        private boolean matchLocation(Pattern[] patterns, CallFrame callFrame) {
            KlassRef klass = (KlassRef)DebuggerController.this.ids.fromId((int)callFrame.getClassId());
            for (Pattern pattern : patterns) {
                DebuggerController.this.fine(() -> "Matching klass: " + klass.getNameAsString() + " against pattern: " + pattern.pattern());
                if (!pattern.pattern().matches(klass.getNameAsString().replace('/', '.'))) continue;
                return true;
            }
            return false;
        }

        private boolean checkExclusionFilters(SteppingInfo info, SuspendedEvent event, Object thread, CallFrame frame) {
            if (info != null) {
                if (DebuggerController.this.isSingleSteppingSuspended()) {
                    this.continueStepping(event, info, thread);
                    return true;
                }
                if (frame == null) {
                    return false;
                }
                RequestFilter requestFilter = DebuggerController.this.eventFilters.getRequestFilter(info.getRequestId());
                if (requestFilter != null && requestFilter.getStepInfo() != null) {
                    Object thisObject;
                    Object filterObject;
                    if (requestFilter.getThisFilterId() != 0L && (filterObject = DebuggerController.this.context.getIds().fromId((int)requestFilter.getThisFilterId())) != (thisObject = frame.getThisValue())) {
                        this.continueStepping(event, info, thread);
                        return true;
                    }
                    KlassRef klass = (KlassRef)DebuggerController.this.context.getIds().fromId((int)frame.getClassId());
                    if (klass != null && requestFilter.isKlassExcluded(klass)) {
                        this.continueStepping(event, info, thread);
                        return true;
                    }
                }
            }
            return false;
        }

        private void continueStepping(SuspendedEvent event, SteppingInfo steppingInfo, Object thread) {
            switch (steppingInfo.getStepKind()) {
                case STEP_INTO: {
                    event.prepareStepOut(STEP_CONFIG).prepareStepInto(STEP_CONFIG);
                    break;
                }
                case STEP_OVER: {
                    event.prepareStepOver(STEP_CONFIG);
                    break;
                }
                case STEP_OUT: {
                    SuspendedInfo info = DebuggerController.this.getSuspendedInfo(thread);
                    if (info == null) break;
                    DebuggerController.this.doStepOut(info);
                    break;
                }
            }
        }

        private CallFrame[] createCallFrames(long threadId, Iterable<DebugStackFrame> stackFrames, int frameLimit, SteppingInfo steppingInfo) {
            LinkedList<CallFrame> list = new LinkedList<CallFrame>();
            int frameCount = 0;
            for (DebugStackFrame frame : stackFrames) {
                RootNode root;
                Node rawNode;
                if (frame.getSourceSection() == null || (rawNode = frame.getRawNode(DebuggerController.this.context.getLanguageClass())) == null || (root = rawNode.getRootNode()) == null) continue;
                Frame rawFrame = frame.getRawFrame(DebuggerController.this.context.getLanguageClass(), FrameInstance.FrameAccess.READ_WRITE);
                MethodRef method = DebuggerController.this.context.getMethodFromRootNode(root);
                KlassRef klass = method.getDeclaringKlassRef();
                long klassId = DebuggerController.this.ids.getIdAsLong(klass);
                long methodId = DebuggerController.this.ids.getIdAsLong(method);
                byte typeTag = TypeTag.getKind(klass);
                long codeIndex = frameCount == 0 && steppingInfo != null && steppingInfo.isStepOutFrame(methodId, klassId) ? steppingInfo.getStepOutBCI() : DebuggerController.this.context.getBCI(rawNode, rawFrame);
                list.addLast(new CallFrame(threadId, typeTag, klassId, method, methodId, codeIndex, rawFrame, rawNode, root, frame, DebuggerController.this.context, DebuggerController.this));
                if (frameLimit == -1 || ++frameCount < frameLimit) continue;
                return list.toArray(new CallFrame[list.size()]);
            }
            return list.toArray(new CallFrame[list.size()]);
        }
    }
}

