/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.espresso.jdwp.api.CallFrame;
import com.oracle.truffle.espresso.jdwp.api.FieldRef;
import com.oracle.truffle.espresso.jdwp.api.JDWPConstantPool;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.LineNumberTableRef;
import com.oracle.truffle.espresso.jdwp.api.LocalRef;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.ModuleRef;
import com.oracle.truffle.espresso.jdwp.api.MonitorStackInfo;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.jdwp.api.TagConstants;
import com.oracle.truffle.espresso.jdwp.impl.CommandResult;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerConnection;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.Packet;
import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import com.oracle.truffle.espresso.jdwp.impl.SuspendedInfo;
import com.oracle.truffle.espresso.jdwp.impl.ThreadJob;
import com.oracle.truffle.espresso.jdwp.impl.TypeTag;
import com.oracle.truffle.espresso.jdwp.impl.UnknownSuspendedInfo;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class JDWP {
    public static final String JAVA_LANG_OBJECT = "Ljava/lang/Object;";
    private static final boolean CAN_GET_INSTANCE_INFO = false;
    private static final long SUSPEND_TIMEOUT = 400L;
    private static final int ACC_SYNTHETIC = 4096;
    private static final int JDWP_SYNTHETIC = -268435456;

    private JDWP() {
    }

    private static SuspendedInfo awaitSuspendedInfo(DebuggerController controller, Object thread, SuspendedInfo suspendedInfo) {
        SuspendedInfo result = suspendedInfo;
        Thread hostThread = controller.getContext().asHostThread(thread);
        if (hostThread.getState() == Thread.State.RUNNABLE) {
            controller.fine(() -> "Awaiting suspended info for thread " + controller.getContext().getThreadName(thread));
            long timeout = System.currentTimeMillis() + 400L;
            while (result instanceof UnknownSuspendedInfo && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(10L);
                    result = controller.getSuspendedInfo(thread);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (result instanceof UnknownSuspendedInfo) {
            controller.fine(() -> "Still no suspended info for thread " + controller.getContext().getThreadName(thread));
        }
        return result;
    }

    private static Object readValue(byte valueKind, PacketStream input, JDWPContext context) {
        switch (valueKind) {
            case 90: {
                return input.readBoolean();
            }
            case 66: {
                return input.readByte();
            }
            case 83: {
                return input.readShort();
            }
            case 67: {
                return Character.valueOf(input.readChar());
            }
            case 73: {
                return input.readInt();
            }
            case 70: {
                return Float.valueOf(input.readFloat());
            }
            case 74: {
                return input.readLong();
            }
            case 68: {
                return input.readDouble();
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                return context.getIds().fromId((int)input.readLong());
            }
        }
        throw new RuntimeException("Should not reach here!");
    }

    private static Object readValue(PacketStream input, JDWPContext context) {
        byte valueKind = input.readByte();
        switch (valueKind) {
            case 86: {
                return Void.TYPE;
            }
            case 90: {
                return input.readBoolean();
            }
            case 66: {
                return input.readByte();
            }
            case 83: {
                return input.readShort();
            }
            case 67: {
                return Character.valueOf(input.readChar());
            }
            case 73: {
                return input.readInt();
            }
            case 70: {
                return Float.valueOf(input.readFloat());
            }
            case 74: {
                return input.readLong();
            }
            case 68: {
                return input.readDouble();
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                return context.getIds().fromId((int)input.readLong());
            }
        }
        throw new RuntimeException("Should not reach here!");
    }

    public static void writeValue(byte tag, Object value, PacketStream reply, boolean tagged, JDWPContext context) {
        if (tagged) {
            reply.writeByte(tag);
        }
        switch (tag) {
            case 90: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeBoolean(unboxed > 0L);
                    break;
                }
                reply.writeBoolean((Boolean)value);
                break;
            }
            case 66: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeByte((byte)unboxed);
                    break;
                }
                reply.writeByte((Byte)value);
                break;
            }
            case 83: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeShort((short)unboxed);
                    break;
                }
                reply.writeShort((Short)value);
                break;
            }
            case 67: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeChar((char)unboxed);
                    break;
                }
                reply.writeChar(((Character)value).charValue());
                break;
            }
            case 73: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeInt((int)unboxed);
                    break;
                }
                reply.writeInt((Integer)value);
                break;
            }
            case 70: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeFloat(unboxed);
                    break;
                }
                reply.writeFloat(((Float)value).floatValue());
                break;
            }
            case 74: {
                reply.writeLong((Long)value);
                break;
            }
            case 68: {
                if (value.getClass() == Long.class) {
                    long unboxed = (Long)value;
                    reply.writeDouble(unboxed);
                    break;
                }
                reply.writeDouble((Double)value);
                break;
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                if (value == null || value == context.getNullObject()) {
                    reply.writeLong(0L);
                    break;
                }
                reply.writeLong(context.getIds().getIdAsLong(value));
                break;
            }
            default: {
                throw new RuntimeException("Should not reach here!");
            }
        }
    }

    private static void writeMethodResult(PacketStream reply, JDWPContext context, ThreadJob.JobResult<?> result, Object thread, DebuggerController controller) {
        if (result.getException() != null) {
            reply.writeByte((byte)76);
            reply.writeLong(0L);
            reply.writeByte((byte)76);
            Object guestException = context.getGuestException(result.getException());
            reply.writeLong(context.getIds().getIdAsLong(guestException));
            if (controller.getThreadSuspension().getSuspensionCount(thread) > 0) {
                controller.getGCPrevention().setActiveWhileSuspended(thread, guestException);
            }
        } else {
            Object value = context.toGuest(result.getResult());
            if (value != null) {
                byte tag = context.getTag(value);
                JDWP.writeValue(tag, value, reply, true, context);
                if (controller.getThreadSuspension().getSuspensionCount(thread) > 0) {
                    controller.getGCPrevention().setActiveWhileSuspended(thread, value);
                }
            } else {
                reply.writeByte((byte)76);
                reply.writeLong(0L);
            }
            reply.writeByte((byte)76);
            reply.writeLong(0L);
        }
    }

    static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    private static int checkSyntheticFlag(int modBits) {
        int mod = modBits;
        if (JDWP.isSynthetic(modBits)) {
            mod &= 0xFFFFEFFF;
            mod |= 0xF0000000;
        }
        return mod;
    }

    private static int getArgCount(String signature) {
        int startIndex = signature.indexOf(40) + 1;
        int endIndex = signature.indexOf(41);
        String parameterSig = signature.substring(startIndex, endIndex);
        int currentCount = 0;
        int currentIndex = 0;
        char[] charArray = parameterSig.toCharArray();
        block7: while (currentIndex < charArray.length) {
            switch (charArray[currentIndex]) {
                case 'D': 
                case 'J': {
                    currentCount += 2;
                    ++currentIndex;
                    continue block7;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++currentCount;
                    ++currentIndex;
                    continue block7;
                }
                case 'L': {
                    ++currentCount;
                    currentIndex = parameterSig.indexOf(59, currentIndex) + 1;
                    continue block7;
                }
                case 'T': {
                    throw new RuntimeException("unexpected type variable");
                }
                case '[': {
                    ++currentCount;
                    currentIndex += JDWP.parseArrayType(parameterSig, charArray, currentIndex + 1);
                    continue block7;
                }
            }
            throw new RuntimeException("should not reach here");
        }
        return currentCount;
    }

    private static int parseArrayType(String signature, char[] charArray, int currentIndex) {
        switch (charArray[currentIndex]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return 2;
            }
            case 'L': {
                return 2 + signature.indexOf(59, currentIndex) - currentIndex;
            }
            case 'T': {
                throw new RuntimeException("unexpected type variable");
            }
            case '[': {
                return 1 + JDWP.parseArrayType(signature, charArray, currentIndex + 1);
            }
        }
        throw new RuntimeException("should not reach here");
    }

    private static KlassRef verifyRefType(long refTypeId, PacketStream reply, JDWPContext context) {
        KlassRef klass;
        try {
            klass = (KlassRef)context.getIds().fromId((int)refTypeId);
        }
        catch (ClassCastException ex) {
            reply.errorCode(21);
            return null;
        }
        return klass;
    }

    private static ModuleRef verifyModule(long moduleId, PacketStream reply, JDWPContext context) {
        ModuleRef module;
        try {
            module = (ModuleRef)context.getIds().fromId((int)moduleId);
        }
        catch (ClassCastException ex) {
            reply.errorCode(42);
            return null;
        }
        return module;
    }

    private static FieldRef verifyFieldRef(long fieldId, PacketStream reply, JDWPContext context) {
        FieldRef field;
        try {
            field = (FieldRef)context.getIds().fromId((int)fieldId);
        }
        catch (ClassCastException ex) {
            reply.errorCode(25);
            return null;
        }
        return field;
    }

    private static MethodRef verifyMethodRef(long methodId, PacketStream reply, JDWPContext context) {
        MethodRef method;
        try {
            method = (MethodRef)context.getIds().fromId((int)methodId);
        }
        catch (ClassCastException ex) {
            reply.errorCode(23);
            return null;
        }
        return method;
    }

    private static Object verifyThread(long threadId, PacketStream reply, JDWPContext context, boolean checkTerminated) {
        Object thread = context.getIds().fromId((int)threadId);
        if (thread == null) {
            reply.errorCode(20);
            return null;
        }
        if (thread == context.getNullObject() || !context.isValidThread(thread, checkTerminated)) {
            reply.errorCode(10);
            return null;
        }
        return thread;
    }

    private static Object verifyThreadGroup(long threadGroupId, PacketStream reply, JDWPContext context) {
        Object threadGroup = context.getIds().fromId((int)threadGroupId);
        if (threadGroup == null || threadGroup == context.getNullObject()) {
            reply.errorCode(20);
            return null;
        }
        if (!context.isValidThreadGroup(threadGroup)) {
            reply.errorCode(11);
            return null;
        }
        return threadGroup;
    }

    private static Object verifyArray(long arrayId, PacketStream reply, JDWPContext context) {
        Object array = context.getIds().fromId((int)arrayId);
        if (array == context.getNullObject()) {
            reply.errorCode(20);
            return null;
        }
        if (!context.isArray(array)) {
            reply.errorCode(508);
            return null;
        }
        return array;
    }

    private static boolean verifyArrayLength(Object array, int maxIndex, PacketStream reply, JDWPContext context) {
        if (!context.verifyArrayLength(array, maxIndex)) {
            reply.errorCode(504);
            return false;
        }
        return true;
    }

    private static Object verifyString(long objectId, PacketStream reply, JDWPContext context) {
        Object string = context.getIds().fromId((int)objectId);
        if (!context.isString(string)) {
            reply.errorCode(506);
            return null;
        }
        return string;
    }

    private static Object verifyClassLoader(long classLoaderId, PacketStream reply, JDWPContext context) {
        Object classLoader = context.getIds().fromId((int)classLoaderId);
        if (!context.isValidClassLoader(classLoader)) {
            reply.errorCode(507);
            return null;
        }
        return classLoader;
    }

    private static CallFrame verifyCallFrame(long frameId, PacketStream reply, JDWPContext context) {
        Object frame = context.getIds().fromId((int)frameId);
        if (!(frame instanceof CallFrame)) {
            reply.errorCode(30);
            return null;
        }
        return (CallFrame)frame;
    }

    private static Object verifyClassObject(long classObjectId, PacketStream reply, JDWPContext context) {
        Object object = context.getIds().fromId((int)classObjectId);
        if (object == context.getNullObject()) {
            reply.errorCode(20);
            return null;
        }
        return object;
    }

    static class Event {
        public static final int ID = 64;

        Event() {
        }

        static class COMPOSITE {
            public static final int ID = 100;

            COMPOSITE() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.errorCode(99);
                return new CommandResult(reply);
            }
        }
    }

    static class ModuleReference {
        public static final int ID = 18;

        ModuleReference() {
        }

        static class CLASSLOADER {
            public static final int ID = 2;

            CLASSLOADER() {
            }

            public static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long moduleId = input.readLong();
                ModuleRef module = JDWP.verifyModule(moduleId, reply, context);
                if (module == null) {
                    return new CommandResult(reply);
                }
                Object loader = module.classLoader();
                if (loader == null || loader == context.getNullObject()) {
                    reply.writeLong(0L);
                } else {
                    reply.writeLong(context.getIds().getIdAsLong(loader));
                }
                return new CommandResult(reply);
            }
        }

        static class NAME {
            public static final int ID = 1;

            NAME() {
            }

            public static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long moduleId = input.readLong();
                ModuleRef module = JDWP.verifyModule(moduleId, reply, context);
                if (module == null) {
                    return new CommandResult(reply);
                }
                reply.writeString(module.jdwpName());
                return new CommandResult(reply);
            }
        }
    }

    static class ClassObjectReference {
        public static final int ID = 17;

        ClassObjectReference() {
        }

        static class REFLECTED_TYPE {
            public static final int ID = 1;

            REFLECTED_TYPE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long classObjectId = input.readLong();
                Object classObject = JDWP.verifyClassObject(classObjectId, reply, context);
                if (classObject == null) {
                    return new CommandResult(reply);
                }
                KlassRef klass = context.getReflectedType(classObject);
                reply.writeByte(TypeTag.getKind(klass));
                reply.writeLong(context.getIds().getIdAsLong(klass));
                return new CommandResult(reply);
            }
        }
    }

    static class StackFrame {
        public static final int ID = 16;

        StackFrame() {
        }

        static class POP_FRAMES {
            public static final int ID = 4;

            POP_FRAMES() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object thread = JDWP.verifyThread(input.readLong(), reply, controller.getContext(), true);
                CallFrame frame = JDWP.verifyCallFrame(input.readLong(), reply, controller.getContext());
                if (thread == null || frame == null) {
                    return new CommandResult(reply);
                }
                int suspensionCount = controller.getThreadSuspension().getSuspensionCount(thread);
                if (suspensionCount < 1) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                if (!controller.popFrames(thread, frame, packet.id)) {
                    reply.errorCode(30);
                    return new CommandResult(reply);
                }
                return null;
            }
        }

        static class THIS_OBJECT {
            public static final int ID = 3;

            THIS_OBJECT() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                JDWPContext context = controller.getContext();
                Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                long frameId = input.readLong();
                CallFrame frame = JDWP.verifyCallFrame(frameId, reply, context);
                if (frame == null) {
                    return new CommandResult(reply);
                }
                Object thisValue = null;
                if (!Modifier.isStatic(frame.getMethod().getModifiers())) {
                    thisValue = frame.getThisValue();
                }
                if (thisValue == CallFrame.INVALID_VALUE) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                reply.writeByte((byte)76);
                if (thisValue != null) {
                    reply.writeLong(context.getIds().getIdAsLong(thisValue));
                } else {
                    reply.writeLong(0L);
                }
                return new CommandResult(reply);
            }
        }

        static class SET_VALUES {
            public static final int ID = 2;

            SET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                if (JDWP.verifyThread(input.readLong(), reply, context, true) == null) {
                    return new CommandResult(reply);
                }
                long frameId = input.readLong();
                int slots = input.readInt();
                CallFrame frame = JDWP.verifyCallFrame(frameId, reply, context);
                if (frame == null) {
                    return new CommandResult(reply);
                }
                for (int i = 0; i < slots; ++i) {
                    String identifier = "" + input.readInt();
                    byte kind = input.readByte();
                    Object value = JDWP.readValue(kind, input, context);
                    frame.setVariable(value, identifier);
                }
                return new CommandResult(reply);
            }
        }

        static class GET_VALUES {
            public static final int ID = 1;

            GET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                if (JDWP.verifyThread(input.readLong(), reply, context, true) == null) {
                    return new CommandResult(reply);
                }
                long frameId = input.readLong();
                int slots = input.readInt();
                reply.writeInt(slots);
                CallFrame frame = JDWP.verifyCallFrame(frameId, reply, context);
                if (frame == null) {
                    return new CommandResult(reply);
                }
                try {
                    for (int i = 0; i < slots; ++i) {
                        int slot = input.readInt();
                        Object value = frame.getVariable("" + slot);
                        if (value == CallFrame.INVALID_VALUE) {
                            reply.errorCode(20);
                            return new CommandResult(reply);
                        }
                        byte sigbyte = input.readByte();
                        if (sigbyte == 76) {
                            sigbyte = context.getTag(value);
                        }
                        JDWP.writeValue(sigbyte, value, reply, true, context);
                    }
                }
                catch (InteropException | ArrayIndexOutOfBoundsException ex) {
                    reply.errorCode(35);
                    return new CommandResult(reply);
                }
                return new CommandResult(reply);
            }
        }
    }

    static class EventRequest {
        public static final int ID = 15;

        EventRequest() {
        }

        static class CLEAR_ALL_BREAKPOINTS {
            public static final int ID = 3;

            CLEAR_ALL_BREAKPOINTS() {
            }
        }

        static class CLEAR {
            public static final int ID = 2;

            CLEAR() {
            }
        }

        static class SET {
            public static final int ID = 1;

            SET() {
            }
        }
    }

    static class ClassLoaderReference {
        public static final int ID = 14;

        ClassLoaderReference() {
        }

        static class VISIBLE_CLASSES {
            public static final int ID = 1;

            VISIBLE_CLASSES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long classLoaderId = input.readLong();
                Object classLoader = JDWP.verifyClassLoader(classLoaderId, reply, context);
                if (classLoader == null) {
                    return new CommandResult(reply);
                }
                List<? extends KlassRef> klasses = context.getInitiatedClasses(classLoader);
                reply.writeInt(klasses.size());
                for (KlassRef klassRef : klasses) {
                    reply.writeByte(TypeTag.getKind(klassRef));
                    reply.writeLong(context.getIds().getIdAsLong(klassRef));
                }
                return new CommandResult(reply);
            }
        }
    }

    static class ArrayReference {
        public static final int ID = 13;

        ArrayReference() {
        }

        static class SET_VALUES {
            public static final int ID = 3;

            SET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long arrayId = input.readLong();
                int index = input.readInt();
                int values = input.readInt();
                Object array = JDWP.verifyArray(arrayId, reply, context);
                if (array == null || !JDWP.verifyArrayLength(array, index + values, reply, context)) {
                    return new CommandResult(reply);
                }
                byte tag = context.getTypeTag(array);
                SET_VALUES.setArrayValues(context, input, index, values, array, tag);
                return new CommandResult(reply);
            }

            private static void setArrayValues(JDWPContext context, PacketStream input, int index, int values, Object array, byte tag) {
                block11: for (int i = index; i < index + values; ++i) {
                    switch (tag) {
                        case 90: {
                            boolean bool = input.readBoolean();
                            byte[] boolArray = (byte[])context.getUnboxedArray(array);
                            boolArray[i] = bool ? (byte)1 : 0;
                            continue block11;
                        }
                        case 66: {
                            byte b = input.readByte();
                            byte[] byteArray = (byte[])context.getUnboxedArray(array);
                            byteArray[i] = b;
                            continue block11;
                        }
                        case 83: {
                            short s = input.readShort();
                            short[] shortArray = (short[])context.getUnboxedArray(array);
                            shortArray[i] = s;
                            continue block11;
                        }
                        case 67: {
                            char c = input.readChar();
                            char[] charArray = (char[])context.getUnboxedArray(array);
                            charArray[i] = c;
                            continue block11;
                        }
                        case 73: {
                            int j = input.readInt();
                            int[] intArray = (int[])context.getUnboxedArray(array);
                            intArray[i] = j;
                            continue block11;
                        }
                        case 70: {
                            float f = input.readFloat();
                            float[] floatArray = (float[])context.getUnboxedArray(array);
                            floatArray[i] = f;
                            continue block11;
                        }
                        case 74: {
                            long l = input.readLong();
                            long[] longArray = (long[])context.getUnboxedArray(array);
                            longArray[i] = l;
                            continue block11;
                        }
                        case 68: {
                            double d = input.readDouble();
                            double[] doubleArray = (double[])context.getUnboxedArray(array);
                            doubleArray[i] = d;
                            continue block11;
                        }
                        case 76: 
                        case 91: 
                        case 115: {
                            Object value = context.getIds().fromId((int)input.readLong());
                            context.setArrayValue(array, i, value);
                            continue block11;
                        }
                        default: {
                            throw new RuntimeException("should not reach here");
                        }
                    }
                }
            }
        }

        static class GET_VALUES {
            public static final int ID = 2;

            GET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                long arrayId = input.readLong();
                int index = input.readInt();
                int length = input.readInt();
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object array = JDWP.verifyArray(arrayId, reply, context);
                if (array == null || !JDWP.verifyArrayLength(array, length, reply, context)) {
                    return new CommandResult(reply);
                }
                byte tag = context.getTypeTag(array);
                boolean isPrimitive = TagConstants.isPrimitive(tag);
                reply.writeByte(tag);
                reply.writeInt(length);
                for (int i = index; i < index + length; ++i) {
                    Object theValue = context.getArrayValue(array, i);
                    byte valueTag = context.getTag(theValue);
                    JDWP.writeValue(valueTag, theValue, reply, !isPrimitive, context);
                }
                return new CommandResult(reply);
            }
        }

        static class LENGTH {
            public static final int ID = 1;

            LENGTH() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long arrayId = input.readLong();
                Object array = JDWP.verifyArray(arrayId, reply, context);
                if (array == null) {
                    return new CommandResult(reply);
                }
                int arrayLength = context.getArrayLength(array);
                if (arrayLength == -1) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                reply.writeInt(arrayLength);
                return new CommandResult(reply);
            }
        }
    }

    static class ThreadGroupReference {
        public static final int ID = 12;

        ThreadGroupReference() {
        }

        static class CHILDREN {
            public static final int ID = 3;

            CHILDREN() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadGroupId = input.readLong();
                Object threadGroup = JDWP.verifyThreadGroup(threadGroupId, reply, context);
                if (threadGroup == null) {
                    return new CommandResult(reply);
                }
                ArrayList<Object> children = new ArrayList<Object>();
                for (Object thread : controller.getVisibleGuestThreads()) {
                    Object otherGroup = context.getThreadGroup(thread);
                    if (otherGroup != threadGroup) continue;
                    children.add(thread);
                }
                reply.writeInt(children.size());
                for (Object e : children) {
                    reply.writeLong(context.getIds().getIdAsLong(e));
                }
                reply.writeInt(0);
                return new CommandResult(reply);
            }
        }

        static class PARENT {
            public static final int ID = 2;

            PARENT() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadGroupId = input.readLong();
                Object thread = JDWP.verifyThreadGroup(threadGroupId, reply, context);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                reply.writeLong(0L);
                return new CommandResult(reply);
            }
        }

        static class NAME {
            public static final int ID = 1;

            NAME() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadGroupId = input.readLong();
                Object threadGroup = JDWP.verifyThreadGroup(threadGroupId, reply, context);
                if (threadGroup == null) {
                    return new CommandResult(reply);
                }
                reply.writeString("main");
                return new CommandResult(reply);
            }
        }
    }

    static class ThreadReference {
        public static final int ID = 11;

        ThreadReference() {
        }

        static class IS_VIRTUAL {
            public static final int ID = 15;

            IS_VIRTUAL() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, controller.getContext(), false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                reply.writeBoolean(controller.getContext().isVirtualThread(thread));
                return new CommandResult(reply);
            }
        }

        static class FORCE_EARLY_RETURN {
            public static final int ID = 14;

            FORCE_EARLY_RETURN() {
            }

            static CommandResult createReply(Packet packet, final DebuggerController controller) {
                CallFrame topFrame;
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                PacketStream input = new PacketStream(packet);
                Object thread = JDWP.verifyThread(input.readLong(), reply, controller.getContext(), true);
                if (thread == null) {
                    reply.errorCode(10);
                    return new CommandResult(reply);
                }
                SuspendedInfo info = controller.getSuspendedInfo(thread);
                if (info == null) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                if (info instanceof UnknownSuspendedInfo && (info = JDWP.awaitSuspendedInfo(controller, thread, info)) instanceof UnknownSuspendedInfo) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                SuspendedInfo suspendedInfo = info;
                Object returnValue = JDWP.readValue(input, controller.getContext());
                if (returnValue == Void.TYPE) {
                    returnValue = controller.getContext().getNullObject();
                }
                CallFrame callFrame = topFrame = suspendedInfo.getStackFrames().length > 0 ? suspendedInfo.getStackFrames()[0] : null;
                if (!controller.forceEarlyReturn(thread, topFrame, returnValue)) {
                    reply.errorCode(32);
                }
                ThreadJob<Void> job = new ThreadJob<Void>(thread, new Callable<Void>(){

                    @Override
                    public Void call() {
                        controller.getContext().clearFrameMonitors(topFrame);
                        return null;
                    }
                });
                controller.postJobForThread(job);
                job.getResult();
                return new CommandResult(reply);
            }
        }

        static class OWNED_MONITORS_STACK_DEPTH_INFO {
            public static final int ID = 13;

            OWNED_MONITORS_STACK_DEPTH_INFO() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                JDWPContext context = controller.getContext();
                PacketStream input = new PacketStream(packet);
                Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                SuspendedInfo suspendedInfo = controller.getSuspendedInfo(thread);
                if (suspendedInfo instanceof UnknownSuspendedInfo && (suspendedInfo = JDWP.awaitSuspendedInfo(controller, thread, suspendedInfo)) instanceof UnknownSuspendedInfo) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                MonitorStackInfo[] ownedMonitorInfos = context.getOwnedMonitors(suspendedInfo.getStackFrames());
                ArrayList<MonitorStackInfo> filtered = new ArrayList<MonitorStackInfo>(ownedMonitorInfos.length);
                for (MonitorStackInfo ownedMonitor : ownedMonitorInfos) {
                    Object monitor = ownedMonitor.getMonitor();
                    if (context.getMonitorOwnerThread(monitor) != thread) continue;
                    filtered.add(ownedMonitor);
                }
                reply.writeInt(filtered.size());
                for (MonitorStackInfo ownedMonitorInfo : filtered) {
                    reply.writeByte(context.getTag(ownedMonitorInfo.getMonitor()));
                    reply.writeLong(context.getIds().getIdAsLong(ownedMonitorInfo.getMonitor()));
                    reply.writeInt(ownedMonitorInfo.getStackDepth());
                }
                return new CommandResult(reply);
            }
        }

        static class SUSPEND_COUNT {
            public static final int ID = 12;

            SUSPEND_COUNT() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, controller.getContext(), false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int suspensionCount = controller.getThreadSuspension().getSuspensionCount(thread);
                controller.fine(() -> "suspension count: " + suspensionCount + " returned for thread: " + controller.getContext().getThreadName(thread));
                reply.writeInt(suspensionCount);
                return new CommandResult(reply);
            }
        }

        static class INTERRUPT {
            public static final int ID = 11;

            INTERRUPT() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, context, false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                context.interruptThread(thread);
                return new CommandResult(reply);
            }
        }

        static class STOP {
            public static final int ID = 10;

            STOP() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, context, false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                long throwableId = input.readLong();
                Object throwable = context.getIds().fromId((int)throwableId);
                context.stopThread(thread, throwable);
                return new CommandResult(reply);
            }
        }

        static class CURRENT_CONTENDED_MONITOR {
            public static final int ID = 9;

            CURRENT_CONTENDED_MONITOR() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                JDWPContext context = controller.getContext();
                Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    reply.errorCode(10);
                    return new CommandResult(reply);
                }
                Object currentContendedMonitor = controller.getEventListener().getCurrentContendedMonitor(thread);
                if (currentContendedMonitor == null) {
                    reply.writeByte((byte)76);
                    reply.writeLong(0L);
                } else {
                    reply.writeByte(context.getTag(currentContendedMonitor));
                    reply.writeLong(context.getIds().getIdAsLong(currentContendedMonitor));
                }
                return new CommandResult(reply);
            }
        }

        static class OWNED_MONITORS {
            public static final int ID = 8;

            OWNED_MONITORS() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                JDWPContext context = controller.getContext();
                Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    reply.errorCode(10);
                    return new CommandResult(reply);
                }
                SuspendedInfo info = controller.getSuspendedInfo(thread);
                if (info == null) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                if (info instanceof UnknownSuspendedInfo && (info = JDWP.awaitSuspendedInfo(controller, thread, info)) instanceof UnknownSuspendedInfo) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                MonitorStackInfo[] ownedMonitors = context.getOwnedMonitors(info.getStackFrames());
                ArrayList<Object> filtered = new ArrayList<Object>(ownedMonitors.length);
                for (MonitorStackInfo ownedMonitor : ownedMonitors) {
                    Object monitor = ownedMonitor.getMonitor();
                    if (context.getMonitorOwnerThread(monitor) != thread) continue;
                    filtered.add(monitor);
                }
                reply.writeInt(filtered.size());
                for (Object e : filtered) {
                    reply.writeByte(context.getTag(e));
                    reply.writeLong(context.getIds().getIdAsLong(e));
                }
                return new CommandResult(reply);
            }
        }

        static class FRAME_COUNT {
            public static final int ID = 7;

            FRAME_COUNT() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, controller.getContext(), true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                SuspendedInfo suspendedInfo = controller.getSuspendedInfo(thread);
                if (suspendedInfo == null) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                if (suspendedInfo instanceof UnknownSuspendedInfo) {
                    suspendedInfo = JDWP.awaitSuspendedInfo(controller, thread, suspendedInfo);
                }
                int length = suspendedInfo.getStackFrames().length;
                reply.writeInt(suspendedInfo.getStackFrames().length);
                controller.fine(() -> "current frame count: " + length + " for thread: " + controller.getContext().getThreadName(thread));
                return new CommandResult(reply);
            }
        }

        static class FRAMES {
            public static final int ID = 6;

            FRAMES() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                int length;
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, controller.getContext(), true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int startFrame = input.readInt();
                int requestedLength = length = input.readInt();
                controller.fine(() -> "requesting frames for thread: " + controller.getContext().getThreadName(thread));
                controller.fine(() -> "startFrame requested: " + startFrame);
                controller.fine(() -> "Number of frames requested: " + requestedLength);
                SuspendedInfo suspendedInfo = controller.getSuspendedInfo(thread);
                if (suspendedInfo == null) {
                    controller.fine(() -> "THREAD_NOT_SUSPENDED: " + controller.getContext().getThreadName(thread));
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                if (suspendedInfo instanceof UnknownSuspendedInfo) {
                    controller.fine(() -> "Unknown suspension info for thread: " + controller.getContext().getThreadName(thread));
                    suspendedInfo = JDWP.awaitSuspendedInfo(controller, thread, suspendedInfo);
                    if (suspendedInfo instanceof UnknownSuspendedInfo) {
                        reply.errorCode(13);
                        return new CommandResult(reply);
                    }
                }
                CallFrame[] frames = suspendedInfo.getStackFrames();
                if (length == -1 || length > frames.length) {
                    length = frames.length;
                }
                reply.writeInt(length);
                int finalLength = length;
                controller.fine(() -> "returning " + finalLength + " frames for thread: " + controller.getContext().getThreadName(thread));
                for (int i = startFrame; i < startFrame + length; ++i) {
                    CallFrame frame = frames[i];
                    reply.writeLong(controller.getContext().getIds().getIdAsLong(frame));
                    reply.writeByte(frame.getTypeTag());
                    reply.writeLong(frame.getClassId());
                    reply.writeLong(frame.getMethod().isObsolete() ? 0L : controller.getContext().getIds().getIdAsLong(frame.getMethod()));
                    reply.writeLong(frame.getCodeIndex());
                }
                return new CommandResult(reply);
            }
        }

        static class THREAD_GROUP {
            public static final int ID = 5;

            THREAD_GROUP() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, context, false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                Object threadGroup = context.getThreadGroup(thread);
                reply.writeLong(context.getIds().getIdAsLong(threadGroup));
                return new CommandResult(reply);
            }
        }

        static class STATUS {
            public static final int ID = 4;
            public static final int JVMTI_THREAD_STATE_ALIVE = 1;
            public static final int JVMTI_THREAD_STATE_TERMINATED = 2;
            public static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
            public static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
            public static final int JVMTI_THREAD_STATE_WAITING = 128;
            public static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
            public static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;
            public static final int JVMTI_JAVA_LANG_THREAD_STATE_MASK = 1207;

            STATUS() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                JDWPContext context = controller.getContext();
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, context, false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int jvmtiThreadStatus = context.getThreadStatus(thread);
                int threadStatus = STATUS.getThreadStatus(jvmtiThreadStatus);
                reply.writeInt(threadStatus);
                int suspended = controller.getThreadSuspension().getSuspensionCount(thread) > 0 ? 1 : 0;
                reply.writeInt(suspended);
                controller.fine(() -> "status command for thread: " + context.getThreadName(thread) + " with status: " + threadStatus + " suspended: " + suspended);
                return new CommandResult(reply);
            }

            private static int getThreadStatus(int jvmtiThreadStatus) {
                int masked = jvmtiThreadStatus & 0x4B7;
                if ((masked & 2) != 0) {
                    return 0;
                }
                if ((masked & 1) != 0) {
                    if ((masked & 4) != 0) {
                        return 1;
                    }
                    if ((masked & 0x400) != 0) {
                        return 4;
                    }
                    return 1;
                }
                if ((masked & 0x80) != 0) {
                    return 4;
                }
                if (masked == 0) {
                    return 1;
                }
                return 1;
            }
        }

        static class RESUME {
            public static final int ID = 3;

            RESUME() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, controller.getContext(), false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                controller.fine(() -> "resume thread packet for thread: " + controller.getContext().getThreadName(thread));
                controller.resume(thread, false);
                return new CommandResult(reply);
            }
        }

        static class SUSPEND {
            public static final int ID = 2;

            SUSPEND() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, controller.getContext(), false);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                controller.fine(() -> "suspend thread packet for thread: " + controller.getContext().getThreadName(thread));
                controller.suspend(thread);
                return new CommandResult(reply);
            }
        }

        static class NAME {
            public static final int ID = 1;

            NAME() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long threadId = input.readLong();
                Object thread = JDWP.verifyThread(threadId, reply, context, false);
                if (thread == null) {
                    controller.fine(() -> "null thread discovered with ID: " + threadId);
                    return new CommandResult(reply);
                }
                String threadName = context.getThreadName(thread);
                reply.writeString(threadName);
                controller.fine(() -> "thread name: " + threadName);
                return new CommandResult(reply);
            }
        }
    }

    static class StringReference {
        public static final int ID = 10;

        StringReference() {
        }

        static class VALUE {
            public static final int ID = 1;

            VALUE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long objectId = input.readLong();
                Object string = JDWP.verifyString(objectId, reply, context);
                if (string == null) {
                    return new CommandResult(reply);
                }
                if (string == context.getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                reply.writeString(context.getStringValue(string));
                return new CommandResult(reply);
            }
        }
    }

    static class ObjectReference {
        public static final int ID = 9;

        ObjectReference() {
        }

        static class REFERRING_OBJECTS {
            public static final int ID = 10;

            REFERRING_OBJECTS() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.errorCode(99);
                return new CommandResult(reply);
            }
        }

        static class IS_COLLECTED {
            public static final int ID = 9;

            IS_COLLECTED() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                long objectId = input.readLong();
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object object = context.getIds().fromId((int)objectId);
                if (object == context.getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                reply.writeBoolean(object == context.getNullObject());
                return new CommandResult(reply);
            }
        }

        static class ENABLE_COLLECTION {
            public static final int ID = 8;

            ENABLE_COLLECTION() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                long objectId = input.readLong();
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object object = controller.getContext().getIds().fromId((int)objectId);
                if (object == controller.getContext().getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                controller.getGCPrevention().enableGC(object);
                return new CommandResult(reply);
            }
        }

        static class DISABLE_COLLECTION {
            public static final int ID = 7;

            DISABLE_COLLECTION() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                long objectId = input.readLong();
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object object = controller.getContext().getIds().fromId((int)objectId);
                if (object == null || object == controller.getContext().getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                controller.getGCPrevention().disableGC(object);
                return new CommandResult(reply);
            }
        }

        static class INVOKE_METHOD {
            public static final int ID = 6;

            INVOKE_METHOD() {
            }

            static CommandResult createReply(final Packet packet, final DebuggerController controller, final DebuggerConnection connection) {
                PacketStream input = new PacketStream(packet);
                final PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                controller.fine(() -> "Invoke method through jdwp");
                final JDWPContext context = controller.getContext();
                long objectId = input.readLong();
                long threadId = input.readLong();
                final Object thread = JDWP.verifyThread(threadId, reply, context, true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int suspensionCount = controller.getThreadSuspension().getSuspensionCount(thread);
                if (suspensionCount < 1) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                if (JDWP.verifyRefType(input.readLong(), reply, context) == null) {
                    return new CommandResult(reply);
                }
                long methodId = input.readLong();
                int arguments = input.readInt();
                final Object[] args = new Object[arguments];
                for (int i = 0; i < arguments; ++i) {
                    byte valueKind = input.readByte();
                    args[i] = JDWP.readValue(valueKind, input, context);
                }
                final Object callee = context.getIds().fromId((int)objectId);
                if (callee == null) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                final MethodRef method = JDWP.verifyMethodRef(methodId, reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                if (!context.isMemberOf(callee, method.getDeclaringKlassRef())) {
                    reply.errorCode(23);
                    return new CommandResult(reply);
                }
                controller.fine(() -> "trying to invoke method: " + method.getNameAsString());
                int invocationOptions = input.readInt();
                byte suspensionStrategy = invocationOptions == 1 ? (byte)1 : 2;
                try {
                    final ThreadJob<Object> job = new ThreadJob<Object>(thread, new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return method.invokeMethod(callee, args);
                        }
                    }, suspensionStrategy);
                    controller.postJobForThread(job);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CommandResult commandResult = new CommandResult(reply);
                            try {
                                ThreadJob.JobResult result = job.getResult();
                                JDWP.writeMethodResult(reply, context, result, thread, controller);
                            }
                            catch (Throwable t) {
                                reply.errorCode(113);
                                System.err.println("Internal Espresso error: " + t.getMessage());
                                t.printStackTrace();
                            }
                            finally {
                                connection.handleReply(packet, commandResult);
                            }
                        }
                    }).start();
                }
                catch (Throwable t) {
                    throw new RuntimeException("not able to invoke method through jdwp", t);
                }
                return null;
            }
        }

        static class MONITOR_INFO {
            public static final int ID = 5;

            MONITOR_INFO() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                PacketStream input = new PacketStream(packet);
                JDWPContext context = controller.getContext();
                long objectId = input.readLong();
                Object monitor = context.getIds().fromId((int)objectId);
                if (monitor == context.getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                Object monitorOwnerThread = context.getMonitorOwnerThread(monitor);
                if (monitorOwnerThread == null) {
                    reply.writeLong(0L);
                    reply.writeInt(0);
                    reply.writeInt(0);
                } else {
                    int entryCount;
                    reply.writeLong(context.getIds().getIdAsLong(monitorOwnerThread));
                    SuspendedInfo info = controller.getSuspendedInfo(monitorOwnerThread);
                    if (info == null) {
                        reply.errorCode(13);
                        return new CommandResult(reply);
                    }
                    if (info instanceof UnknownSuspendedInfo) {
                        JDWP.awaitSuspendedInfo(controller, monitorOwnerThread, info);
                        if (info instanceof UnknownSuspendedInfo) {
                            reply.errorCode(13);
                            return new CommandResult(reply);
                        }
                    }
                    if ((entryCount = info.getMonitorEntryCount(monitor)) == -1) {
                        reply.errorCode(20);
                        return new CommandResult(reply);
                    }
                    reply.writeInt(entryCount);
                    ArrayList<Object> waiters = new ArrayList<Object>();
                    for (Object activeThread : controller.getVisibleGuestThreads()) {
                        Object contendedMonitor;
                        if (activeThread == monitorOwnerThread || (contendedMonitor = controller.getEventListener().getCurrentContendedMonitor(activeThread)) == null || contendedMonitor != monitor) continue;
                        waiters.add(activeThread);
                    }
                    reply.writeInt(waiters.size());
                    for (Object e : waiters) {
                        reply.writeLong(context.getIds().getIdAsLong(e));
                    }
                }
                return new CommandResult(reply);
            }
        }

        static class SET_VALUES {
            public static final int ID = 3;

            SET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long objectId = input.readLong();
                Object object = context.getIds().fromId((int)objectId);
                if (object == context.getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                int numFields = input.readInt();
                for (int i = 0; i < numFields; ++i) {
                    long fieldId = input.readLong();
                    FieldRef field = JDWP.verifyFieldRef(fieldId, reply, context);
                    if (field == null) {
                        return new CommandResult(reply);
                    }
                    byte tag = field.getTagConstant();
                    if (tag == 76) {
                        tag = context.getTag(field.getTypeAsString());
                    }
                    Object value = JDWP.readValue(tag, input, context);
                    field.setValue(object, value);
                }
                return new CommandResult(reply);
            }
        }

        static class GET_VALUES {
            public static final int ID = 2;

            GET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long objectId = input.readLong();
                Object object = context.getIds().fromId((int)objectId);
                if (object == context.getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                int numFields = input.readInt();
                reply.writeInt(numFields);
                for (int i = 0; i < numFields; ++i) {
                    long fieldId = input.readLong();
                    FieldRef field = JDWP.verifyFieldRef(fieldId, reply, context);
                    if (field == null) {
                        return new CommandResult(reply);
                    }
                    Object value = field.getValue(object);
                    byte tag = field.getTagConstant();
                    if (tag == 76) {
                        tag = context.getTag(value);
                    }
                    JDWP.writeValue(tag, value, reply, true, context);
                }
                return new CommandResult(reply);
            }
        }

        static class REFERENCE_TYPE {
            public static final int ID = 1;

            REFERENCE_TYPE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                long objectId = input.readLong();
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object object = context.getIds().fromId((int)objectId);
                if (object == context.getNullObject()) {
                    reply.errorCode(20);
                    return new CommandResult(reply);
                }
                KlassRef klassRef = context.getRefType(object);
                reply.writeByte(TypeTag.getKind(klassRef));
                reply.writeLong(context.getIds().getIdAsLong(klassRef));
                return new CommandResult(reply);
            }
        }
    }

    static class Methods {
        public static final int ID = 6;

        Methods() {
        }

        static class VARIABLE_TABLE_WITH_GENERIC {
            public static final int ID = 5;

            VARIABLE_TABLE_WITH_GENERIC() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                KlassRef klassRef = JDWP.verifyRefType(input.readLong(), reply, context);
                if (klassRef == null) {
                    return new CommandResult(reply);
                }
                long methodId = input.readLong();
                MethodRef method = JDWP.verifyMethodRef(methodId, reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                int argCnt = JDWP.getArgCount(method.getSignatureAsString());
                LocalRef[] locals = method.getLocalVariableTable().getLocals();
                LocalRef[] genericLocals = method.getLocalVariableTypeTable().getLocals();
                reply.writeInt(argCnt);
                reply.writeInt(locals.length);
                for (LocalRef local : locals) {
                    reply.writeLong(local.getStartBCI());
                    reply.writeString(local.getNameAsString());
                    reply.writeString(local.getTypeAsString());
                    String genericSignature = "";
                    for (LocalRef genericLocal : genericLocals) {
                        if (!genericLocal.getNameAsString().equals(local.getNameAsString())) continue;
                        genericSignature = genericLocal.getTypeAsString();
                    }
                    reply.writeString(genericSignature);
                    reply.writeInt(local.getEndBCI() - local.getStartBCI());
                    reply.writeInt(local.getSlot());
                }
                return new CommandResult(reply);
            }
        }

        static class IS_OBSOLETE {
            public static final int ID = 4;

            IS_OBSOLETE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                KlassRef refType = JDWP.verifyRefType(input.readLong(), reply, context);
                if (refType == null) {
                    return new CommandResult(reply);
                }
                long methodId = input.readLong();
                if (methodId == 0L) {
                    reply.writeBoolean(true);
                } else {
                    MethodRef method = JDWP.verifyMethodRef(methodId, reply, context);
                    if (method == null) {
                        return new CommandResult(reply);
                    }
                    reply.writeBoolean(method.isObsolete());
                }
                return new CommandResult(reply);
            }
        }

        static class BYTECODES {
            public static final int ID = 3;

            BYTECODES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                KlassRef klassRef = JDWP.verifyRefType(input.readLong(), reply, context);
                if (klassRef == null) {
                    return new CommandResult(reply);
                }
                long methodId = input.readLong();
                MethodRef method = JDWP.verifyMethodRef(methodId, reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                byte[] code = method.getOriginalCode();
                reply.writeInt(code.length);
                reply.writeByteArray(code);
                return new CommandResult(reply);
            }
        }

        static class VARIABLE_TABLE {
            public static final int ID = 2;

            VARIABLE_TABLE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                KlassRef klassRef = JDWP.verifyRefType(input.readLong(), reply, context);
                if (klassRef == null) {
                    return new CommandResult(reply);
                }
                long methodId = input.readLong();
                MethodRef method = JDWP.verifyMethodRef(methodId, reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                int argCnt = JDWP.getArgCount(method.getSignatureAsString());
                LocalRef[] locals = method.getLocalVariableTable().getLocals();
                reply.writeInt(argCnt);
                reply.writeInt(locals.length);
                for (LocalRef local : locals) {
                    reply.writeLong(local.getStartBCI());
                    reply.writeString(local.getNameAsString());
                    reply.writeString(local.getTypeAsString());
                    reply.writeInt(local.getEndBCI() - local.getStartBCI());
                    reply.writeInt(local.getSlot());
                }
                return new CommandResult(reply);
            }
        }

        static class LINE_TABLE {
            public static final int ID = 1;

            LINE_TABLE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                PacketStream input = new PacketStream(packet);
                long refTypeId = input.readLong();
                long methodId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                MethodRef method = JDWP.verifyMethodRef(methodId, reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                LineNumberTableRef table = method.getLineNumberTable();
                if (table != null) {
                    List<? extends LineNumberTableRef.EntryRef> entries = table.getEntries();
                    long start = method.isMethodNative() ? -1L : 0L;
                    long end = method.isMethodNative() ? -1L : method.getLastBCI();
                    int lines = entries.size();
                    Line[] allLines = new Line[lines];
                    for (int i = 0; i < entries.size(); ++i) {
                        LineNumberTableRef.EntryRef entry = entries.get(i);
                        int bci = entry.getBCI();
                        int line = entry.getLineNumber();
                        allLines[i] = new Line(bci, line);
                    }
                    reply.writeLong(start);
                    reply.writeLong(end);
                    reply.writeInt(lines);
                    for (Line line : allLines) {
                        reply.writeLong(line.lineCodeIndex);
                        reply.writeInt(line.lineNumber);
                    }
                }
                return new CommandResult(reply);
            }

            static class Line {
                final long lineCodeIndex;
                final int lineNumber;

                Line(long lineCodeIndex, int lineNumber) {
                    this.lineCodeIndex = lineCodeIndex;
                    this.lineNumber = lineNumber;
                }
            }
        }
    }

    static class InterfaceType {
        public static final int ID = 5;

        InterfaceType() {
        }

        static class INVOKE_METHOD {
            public static final int ID = 1;

            INVOKE_METHOD() {
            }

            static CommandResult createReply(final Packet packet, final DebuggerController controller, final DebuggerConnection connection) {
                final PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                PacketStream input = new PacketStream(packet);
                final JDWPContext context = controller.getContext();
                KlassRef itf = JDWP.verifyRefType(input.readLong(), reply, context);
                if (itf == null) {
                    return new CommandResult(reply);
                }
                if (!itf.isInterface()) {
                    reply.errorCode(21);
                    return new CommandResult(reply);
                }
                final Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int suspensionCount = controller.getThreadSuspension().getSuspensionCount(thread);
                if (suspensionCount < 1) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                final MethodRef method = JDWP.verifyMethodRef(input.readLong(), reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                if (method.getDeclaringKlassRef() != itf) {
                    reply.errorCode(23);
                    return new CommandResult(reply);
                }
                controller.fine(() -> "trying to invoke interface method: " + method.getNameAsString());
                int arguments = input.readInt();
                final Object[] args = new Object[arguments];
                for (int i = 0; i < arguments; ++i) {
                    byte valueKind = input.readByte();
                    args[i] = JDWP.readValue(valueKind, input, context);
                }
                int invocationOptions = input.readInt();
                byte suspensionStrategy = invocationOptions == 1 ? (byte)1 : 2;
                try {
                    final ThreadJob<Object> job = new ThreadJob<Object>(thread, new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return method.invokeMethod(null, args);
                        }
                    }, suspensionStrategy);
                    controller.postJobForThread(job);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CommandResult commandResult = new CommandResult(reply);
                            try {
                                ThreadJob.JobResult result = job.getResult();
                                JDWP.writeMethodResult(reply, context, result, thread, controller);
                            }
                            catch (Throwable t) {
                                reply.errorCode(113);
                                System.err.println("Internal Espresso error: " + t.getMessage());
                                t.printStackTrace();
                            }
                            finally {
                                connection.handleReply(packet, commandResult);
                            }
                        }
                    }).start();
                }
                catch (Throwable t) {
                    throw new RuntimeException("not able to invoke interface method through jdwp", t);
                }
                return null;
            }
        }
    }

    static class ArrayType {
        public static final int ID = 4;

        ArrayType() {
        }

        static class NEW_INSTANCE {
            public static final int ID = 1;

            NEW_INSTANCE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                PacketStream input = new PacketStream(packet);
                KlassRef klass = JDWP.verifyRefType(input.readLong(), reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                int length = input.readInt();
                Object newArray = context.newArray(klass, length);
                reply.writeByte((byte)91);
                reply.writeLong(context.getIds().getIdAsLong(newArray));
                return new CommandResult(reply);
            }
        }
    }

    static class ClassType {
        public static final int ID = 3;

        ClassType() {
        }

        static class NEW_INSTANCE {
            public static final int ID = 4;

            NEW_INSTANCE() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                PacketStream input = new PacketStream(packet);
                JDWPContext context = controller.getContext();
                KlassRef klass = JDWP.verifyRefType(input.readLong(), reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int suspensionCount = controller.getThreadSuspension().getSuspensionCount(thread);
                if (suspensionCount < 1) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                final MethodRef method = JDWP.verifyMethodRef(input.readLong(), reply, context);
                if (method == null) {
                    controller.warning(() -> "not a valid method");
                    return new CommandResult(reply);
                }
                controller.fine(() -> "trying to invoke constructor in klass: " + klass.getNameAsString());
                int arguments = input.readInt();
                final Object[] args = new Object[arguments];
                for (int i = 0; i < arguments; ++i) {
                    byte valueKind = input.readByte();
                    args[i] = JDWP.readValue(valueKind, input, context);
                }
                int invocationOptions = input.readInt();
                byte suspensionStrategy = invocationOptions == 1 ? (byte)1 : 2;
                try {
                    ThreadJob<Object> job = new ThreadJob<Object>(thread, new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return method.invokeMethod(null, args);
                        }
                    }, suspensionStrategy);
                    controller.postJobForThread(job);
                    ThreadJob.JobResult<Object> result = job.getResult();
                    JDWP.writeMethodResult(reply, context, result, thread, controller);
                }
                catch (Throwable t) {
                    throw new RuntimeException("not able to invoke static method through jdwp", t);
                }
                return new CommandResult(reply);
            }
        }

        static class INVOKE_METHOD {
            public static final int ID = 3;

            INVOKE_METHOD() {
            }

            static CommandResult createReply(final Packet packet, final DebuggerController controller, final DebuggerConnection connection) {
                PacketStream input = new PacketStream(packet);
                final PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                final JDWPContext context = controller.getContext();
                KlassRef klass = JDWP.verifyRefType(input.readLong(), reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                final Object thread = JDWP.verifyThread(input.readLong(), reply, context, true);
                if (thread == null) {
                    return new CommandResult(reply);
                }
                int suspensionCount = controller.getThreadSuspension().getSuspensionCount(thread);
                if (suspensionCount < 1) {
                    reply.errorCode(13);
                    return new CommandResult(reply);
                }
                final MethodRef method = JDWP.verifyMethodRef(input.readLong(), reply, context);
                if (method == null) {
                    return new CommandResult(reply);
                }
                KlassRef declaringKlass = method.getDeclaringKlassRef();
                boolean isMember = false;
                for (KlassRef checkedKlass = klass; checkedKlass != null; checkedKlass = checkedKlass.getSuperClass()) {
                    if (checkedKlass != declaringKlass) continue;
                    isMember = true;
                    break;
                }
                if (!isMember) {
                    reply.errorCode(23);
                    return new CommandResult(reply);
                }
                controller.fine(() -> "trying to invoke static method: " + method.getNameAsString());
                int arguments = input.readInt();
                final Object[] args = new Object[arguments];
                for (int i = 0; i < arguments; ++i) {
                    byte valueKind = input.readByte();
                    args[i] = JDWP.readValue(valueKind, input, context);
                }
                int invocationOptions = input.readInt();
                byte suspensionStrategy = invocationOptions == 1 ? (byte)1 : 2;
                try {
                    final ThreadJob<Object> job = new ThreadJob<Object>(thread, new Callable<Object>(){

                        @Override
                        public Object call() {
                            return method.invokeMethod(null, args);
                        }
                    }, suspensionStrategy);
                    controller.postJobForThread(job);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CommandResult commandResult = new CommandResult(reply);
                            try {
                                ThreadJob.JobResult result = job.getResult();
                                JDWP.writeMethodResult(reply, context, result, thread, controller);
                            }
                            catch (Throwable t) {
                                reply.errorCode(113);
                                System.err.println("Internal Espresso error: " + t.getMessage());
                                t.printStackTrace();
                            }
                            finally {
                                connection.handleReply(packet, commandResult);
                            }
                        }
                    }).start();
                }
                catch (Throwable t) {
                    throw new RuntimeException("not able to invoke static method through jdwp", t);
                }
                return null;
            }
        }

        static class SET_VALUES {
            public static final int ID = 2;

            SET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long classId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(classId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                if (klass.getStatus() < 2) {
                    reply.errorCode(22);
                    return new CommandResult(reply);
                }
                int values = input.readInt();
                for (int i = 0; i < values; ++i) {
                    long fieldId = input.readLong();
                    FieldRef field = JDWP.verifyFieldRef(fieldId, reply, context);
                    if (field == null) {
                        return new CommandResult(reply);
                    }
                    byte tag = field.getTagConstant();
                    if (tag == 76) {
                        tag = context.getTag(field.getTypeAsString());
                    }
                    Object value = JDWP.readValue(tag, input, context);
                    context.setStaticFieldValue(field, value);
                }
                return new CommandResult(reply);
            }
        }

        static class SUPERCLASS {
            public static final int ID = 1;

            SUPERCLASS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long classId = input.readLong();
                KlassRef klassRef = JDWP.verifyRefType(classId, reply, context);
                if (klassRef == null) {
                    return new CommandResult(reply);
                }
                boolean isJavaLangObject = JDWP.JAVA_LANG_OBJECT.equals(klassRef.getTypeAsString());
                if (isJavaLangObject) {
                    reply.writeLong(0L);
                } else {
                    KlassRef superKlass = klassRef.getSuperClass();
                    reply.writeLong(context.getIds().getIdAsLong(superKlass));
                }
                return new CommandResult(reply);
            }
        }
    }

    static class ReferenceType {
        public static final int ID = 2;

        ReferenceType() {
        }

        static class MODULE {
            public static final int ID = 19;

            MODULE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long typeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(typeId, reply, context);
                if (klass == null) {
                    Object object = context.getIds().fromId((int)typeId);
                    klass = context.getReflectedType(object);
                }
                if (klass == null) {
                    return new CommandResult(reply);
                }
                ModuleRef module = klass.getModule();
                long moduleID = context.getIds().getIdAsLong(module);
                reply.writeLong(moduleID);
                return new CommandResult(reply);
            }
        }

        static class CONSTANT_POOL {
            public static final int ID = 18;

            CONSTANT_POOL() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long typeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(typeId, reply, context);
                if (klass == null) {
                    Object object = context.getIds().fromId((int)typeId);
                    klass = context.getReflectedType(object);
                }
                if (klass == null) {
                    return new CommandResult(reply);
                }
                if (klass.isPrimitive() || klass.isArray()) {
                    reply.errorCode(101);
                    return new CommandResult(reply);
                }
                JDWPConstantPool constantPool = klass.getJDWPConstantPool();
                int count = constantPool.getCount();
                reply.writeInt(count);
                byte[] poolBytes = constantPool.getBytes();
                reply.writeInt(poolBytes.length);
                reply.writeByteArray(poolBytes);
                return new CommandResult(reply);
            }
        }

        static class CLASS_FILE_VERSION {
            public static final int ID = 17;

            CLASS_FILE_VERSION() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long typeId = input.readLong();
                KlassRef klassRef = JDWP.verifyRefType(typeId, reply, context);
                if (klassRef == null) {
                    Object object = context.getIds().fromId((int)typeId);
                    klassRef = context.getReflectedType(object);
                }
                if (klassRef == null) {
                    return new CommandResult(reply);
                }
                if (klassRef.isArray() || klassRef.isPrimitive()) {
                    reply.errorCode(101);
                    return new CommandResult(reply);
                }
                reply.writeInt(klassRef.getMajorVersion());
                reply.writeInt(klassRef.getMinorVersion());
                return new CommandResult(reply);
            }
        }

        static class INSTANCES {
            public static final int ID = 16;

            INSTANCES() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.errorCode(99);
                return new CommandResult(reply);
            }
        }

        static class METHODS_WITH_GENERIC {
            public static final int ID = 15;

            METHODS_WITH_GENERIC() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                if (klass.getStatus() < 2) {
                    reply.errorCode(22);
                    return new CommandResult(reply);
                }
                MethodRef[] declaredMethods = klass.getDeclaredMethodRefs();
                int numDeclaredMethods = declaredMethods.length;
                reply.writeInt(numDeclaredMethods);
                for (MethodRef method : declaredMethods) {
                    reply.writeLong(context.getIds().getIdAsLong(method));
                    reply.writeString(method.getNameAsString());
                    reply.writeString(method.getSignatureAsString());
                    reply.writeString(method.getGenericSignatureAsString());
                    int modBits = JDWP.checkSyntheticFlag(method.getModifiers());
                    reply.writeInt(modBits);
                }
                return new CommandResult(reply);
            }
        }

        static class FIELDS_WITH_GENERIC {
            public static final int ID = 14;

            FIELDS_WITH_GENERIC() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                if (klass.getStatus() < 2) {
                    reply.errorCode(22);
                    return new CommandResult(reply);
                }
                FieldRef[] declaredFields = klass.getDeclaredFields();
                int numDeclaredFields = declaredFields.length;
                reply.writeInt(numDeclaredFields);
                for (FieldRef field : declaredFields) {
                    reply.writeLong(context.getIds().getIdAsLong(field));
                    reply.writeString(field.getNameAsString());
                    String signature = field.getTypeAsString();
                    reply.writeString(signature);
                    String genericSignature = field.getGenericSignatureAsString();
                    if (genericSignature.equals(signature)) {
                        reply.writeString("");
                    } else {
                        reply.writeString(field.getGenericSignatureAsString());
                    }
                    int modBits = JDWP.checkSyntheticFlag(field.getModifiers());
                    reply.writeInt(modBits);
                }
                return new CommandResult(reply);
            }
        }

        static class SIGNATURE_WITH_GENERIC {
            public static final int ID = 13;

            SIGNATURE_WITH_GENERIC() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply;
                PacketStream input = new PacketStream(packet);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply = new PacketStream().replyPacket().id(packet.id), context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                reply.writeString(klass.getTypeAsString());
                reply.writeString(klass.getGenericTypeAsString());
                return new CommandResult(reply);
            }
        }

        static class SOURCE_DEBUG_EXTENSION {
            public static final int ID = 12;

            SOURCE_DEBUG_EXTENSION() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply;
                PacketStream input = new PacketStream(packet);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply = new PacketStream().replyPacket().id(packet.id), context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                String sourceDebugExtension = klass.getSourceDebugExtension();
                if (sourceDebugExtension == null) {
                    reply.errorCode(101);
                    return new CommandResult(reply);
                }
                reply.writeString(sourceDebugExtension);
                return new CommandResult(reply);
            }
        }

        static class CLASS_OBJECT {
            public static final int ID = 11;

            CLASS_OBJECT() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply;
                PacketStream input = new PacketStream(packet);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply = new PacketStream().replyPacket().id(packet.id), context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                Object classObject = klass.getKlassObject();
                reply.writeLong(context.getIds().getIdAsLong(classObject));
                return new CommandResult(reply);
            }
        }

        static class INTERFACES {
            public static final int ID = 10;

            INTERFACES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply;
                PacketStream input = new PacketStream(packet);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply = new PacketStream().replyPacket().id(packet.id), context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                KlassRef[] interfaces = klass.getImplementedInterfaces();
                reply.writeInt(interfaces.length);
                for (KlassRef itf : interfaces) {
                    reply.writeLong(context.getIds().getIdAsLong(itf));
                }
                return new CommandResult(reply);
            }
        }

        static class STATUS {
            public static final int ID = 9;

            STATUS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long klassRef = input.readLong();
                KlassRef klass = JDWP.verifyRefType(klassRef, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                reply.writeInt(klass.getStatus());
                return new CommandResult(reply);
            }
        }

        static class NESTED_TYPES {
            public static final int ID = 8;

            NESTED_TYPES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long klassRef = input.readLong();
                KlassRef klass = JDWP.verifyRefType(klassRef, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                KlassRef[] nestedTypes = context.getNestedTypes(klass);
                reply.writeInt(nestedTypes.length);
                for (KlassRef nestedType : nestedTypes) {
                    reply.writeByte(TypeTag.getKind(nestedType));
                    reply.writeLong(context.getIds().getIdAsLong(nestedType));
                }
                return new CommandResult(reply);
            }
        }

        static class SOURCE_FILE {
            public static final int ID = 7;

            SOURCE_FILE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                String sourceFile = null;
                int n = 0;
                MethodRef[] methods = klass.getDeclaredMethodRefs();
                MethodRef[] methodRefArray = methods;
                int n2 = methodRefArray.length;
                if (n < n2) {
                    MethodRef method = methodRefArray[n];
                    if (!method.hasSourceFileAttribute()) {
                        reply.errorCode(101);
                        return new CommandResult(reply);
                    }
                    sourceFile = method.getSourceFile();
                }
                if (sourceFile == null) {
                    reply.errorCode(101);
                    return new CommandResult(reply);
                }
                reply.writeString(sourceFile);
                return new CommandResult(reply);
            }
        }

        static class GET_VALUES {
            public static final int ID = 6;

            GET_VALUES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                if (JDWP.verifyRefType(refTypeId, reply, context) == null) {
                    return new CommandResult(reply);
                }
                int fields = input.readInt();
                reply.writeInt(fields);
                for (int i = 0; i < fields; ++i) {
                    long fieldId = input.readLong();
                    FieldRef field = JDWP.verifyFieldRef(fieldId, reply, context);
                    if (field == null) {
                        return new CommandResult(reply);
                    }
                    Object value = field.getDeclaringKlass().getStatus() == 8 || field.getDeclaringKlass().getStatus() < 4 ? null : context.getStaticFieldValue(field);
                    byte tag = context.getTag(value);
                    JDWP.writeValue(tag, value, reply, true, context);
                }
                return new CommandResult(reply);
            }
        }

        static class METHODS {
            public static final int ID = 5;

            METHODS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                if (klass.getStatus() < 2) {
                    reply.errorCode(22);
                    return new CommandResult(reply);
                }
                MethodRef[] declaredMethods = klass.getDeclaredMethodRefs();
                int numDeclaredMethods = declaredMethods.length;
                reply.writeInt(numDeclaredMethods);
                for (MethodRef method : declaredMethods) {
                    reply.writeLong(context.getIds().getIdAsLong(method));
                    reply.writeString(method.getNameAsString());
                    reply.writeString(method.getSignatureAsString());
                    int modBits = JDWP.checkSyntheticFlag(method.getModifiers());
                    reply.writeInt(modBits);
                }
                return new CommandResult(reply);
            }
        }

        static class FIELDS {
            public static final int ID = 4;

            FIELDS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                if (klass.getStatus() < 2) {
                    reply.errorCode(22);
                    return new CommandResult(reply);
                }
                FieldRef[] declaredFields = klass.getDeclaredFields();
                int numDeclaredFields = declaredFields.length;
                reply.writeInt(numDeclaredFields);
                for (FieldRef field : declaredFields) {
                    reply.writeLong(context.getIds().getIdAsLong(field));
                    reply.writeString(field.getNameAsString());
                    reply.writeString(field.getTypeAsString());
                    int modBits = JDWP.checkSyntheticFlag(field.getModifiers());
                    reply.writeInt(modBits);
                }
                return new CommandResult(reply);
            }
        }

        static class MODIFIERS {
            public static final int ID = 3;

            MODIFIERS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                reply.writeInt(klass.getModifiers());
                return new CommandResult(reply);
            }
        }

        static class CLASSLOADER {
            public static final int ID = 2;

            CLASSLOADER() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                Object loader = klass.getDefiningClassLoader();
                if (loader == null || loader == context.getNullObject()) {
                    reply.writeLong(0L);
                } else {
                    reply.writeLong(context.getIds().getIdAsLong(loader));
                }
                return new CommandResult(reply);
            }
        }

        static class SIGNATURE {
            public static final int ID = 1;

            SIGNATURE() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                long refTypeId = input.readLong();
                KlassRef klass = JDWP.verifyRefType(refTypeId, reply, context);
                if (klass == null) {
                    return new CommandResult(reply);
                }
                reply.writeString(klass.getTypeAsString());
                return new CommandResult(reply);
            }
        }
    }

    static class VirtualMachine {
        public static final int ID = 1;

        VirtualMachine() {
        }

        static class ALL_MODULES {
            public static final int ID = 22;

            ALL_MODULES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                ModuleRef[] moduleRefs = context.getAllModulesRefs();
                reply.writeInt(moduleRefs.length);
                for (ModuleRef moduleRef : moduleRefs) {
                    reply.writeLong(context.getIds().getIdAsLong(moduleRef));
                }
                return new CommandResult(reply);
            }
        }

        static class INSTANCE_COUNTS {
            public static final int ID = 21;

            INSTANCE_COUNTS() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id).errorCode(99);
                return new CommandResult(reply);
            }
        }

        static class ALL_CLASSES_WITH_GENERIC {
            public static final int ID = 20;

            ALL_CLASSES_WITH_GENERIC() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                KlassRef[] allLoadedClasses = context.getAllLoadedClasses();
                reply.writeInt(allLoadedClasses.length);
                for (KlassRef klass : allLoadedClasses) {
                    reply.writeByte(TypeTag.getKind(klass));
                    reply.writeLong(context.getIds().getIdAsLong(klass));
                    reply.writeString(klass.getTypeAsString());
                    reply.writeString(klass.getGenericTypeAsString());
                    reply.writeInt(klass.getStatus());
                }
                return new CommandResult(reply);
            }
        }

        static class SET_DEFAULT_STRATUM {
            public static final int ID = 19;

            SET_DEFAULT_STRATUM() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id).errorCode(99);
                return new CommandResult(reply);
            }
        }

        static class REDEFINE_CLASSES {
            public static final int ID = 18;

            REDEFINE_CLASSES() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                JDWPContext context = controller.getContext();
                int classes = input.readInt();
                controller.fine(() -> "Request to redefine %d classes received " + classes);
                ArrayList<RedefineInfo> redefineInfos = new ArrayList<RedefineInfo>(classes);
                for (int i = 0; i < classes; ++i) {
                    KlassRef klass = null;
                    long refTypeId = input.readLong();
                    if (refTypeId != -1L) {
                        klass = JDWP.verifyRefType(refTypeId, reply, context);
                        if (klass == null && !context.getIds().checkRemoved(refTypeId)) {
                            reply.errorCode(21);
                            return new CommandResult(reply);
                        }
                        if (klass == context.getNullObject() || klass == null) {
                            reply.errorCode(21);
                            return new CommandResult(reply);
                        }
                    }
                    int byteLength = input.readInt();
                    byte[] classBytes = input.readByteArray(byteLength);
                    redefineInfos.add(new RedefineInfo(klass, classBytes));
                }
                Object[] allGuestThreads = controller.getVisibleGuestThreads();
                Object prev = null;
                try {
                    prev = controller.enterTruffleContext();
                    for (Object guestThread : allGuestThreads) {
                        controller.suspend(guestThread);
                    }
                    int errorCode = context.redefineClasses(redefineInfos);
                    if (errorCode != 0) {
                        reply.errorCode(errorCode);
                        controller.warning(() -> "Redefine failed with error code: " + errorCode);
                        CommandResult commandResult = new CommandResult(reply);
                        return commandResult;
                    }
                    controller.fine(() -> "Redefine successful");
                }
                finally {
                    for (Object guestThread : allGuestThreads) {
                        controller.resume(guestThread, false);
                    }
                    controller.leaveTruffleContext(prev);
                }
                return new CommandResult(reply);
            }
        }

        static class CAPABILITIES_NEW {
            public static final int ID = 17;

            CAPABILITIES_NEW() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(false);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                reply.writeBoolean(false);
                return new CommandResult(reply);
            }
        }

        static class RELEASE_EVENTS {
            public static final int ID = 16;

            RELEASE_EVENTS() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                controller.getEventListener().releaseEvents();
                return new CommandResult(reply);
            }
        }

        static class HOLD_EVENTS {
            public static final int ID = 15;

            HOLD_EVENTS() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                controller.getEventListener().holdEvents();
                return new CommandResult(reply);
            }
        }

        static class DISPOSE_OBJECTS {
            public static final int ID = 14;

            DISPOSE_OBJECTS() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                int count = input.readInt();
                for (int i = 0; i < count; ++i) {
                    input.readLong();
                    input.readInt();
                }
                return new CommandResult(reply);
            }
        }

        static class CLASS_PATHS {
            public static final int ID = 13;

            CLASS_PATHS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.writeString("");
                List<Path> classPath = context.getClassPath();
                reply.writeInt(classPath.size());
                for (Path path : classPath) {
                    reply.writeString(path.toAbsolutePath().toString());
                }
                List<Path> bootClassPath = context.getBootClassPath();
                reply.writeInt(bootClassPath.size());
                for (Path path : bootClassPath) {
                    reply.writeString(path.toAbsolutePath().toString());
                }
                return new CommandResult(reply);
            }
        }

        static class CAPABILITIES {
            public static final int ID = 12;

            CAPABILITIES() {
            }

            static CommandResult createReply(Packet packet) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                reply.writeBoolean(true);
                return new CommandResult(reply);
            }
        }

        static class CREATE_STRING {
            public static final int ID = 11;

            CREATE_STRING() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream input = new PacketStream(packet);
                String utf = input.readString();
                Object string = context.toGuestString(utf);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.writeLong(context.getIds().getIdAsLong(string));
                return new CommandResult(reply);
            }
        }

        static class EXIT {
            public static final int ID = 10;

            EXIT() {
            }

            static CommandResult createReply(Packet packet, final JDWPContext context) {
                final PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                if (context.systemExitImplemented()) {
                    return new CommandResult(reply, null, Collections.singletonList(new Callable<Void>(){

                        @Override
                        public Void call() {
                            context.exit(input.readInt());
                            return null;
                        }
                    }));
                }
                reply.errorCode(99);
                return new CommandResult(reply);
            }
        }

        static class RESUME {
            public static final int ID = 9;

            RESUME() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                controller.fine(() -> "Resume all packet");
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                controller.resumeAll();
                return new CommandResult(reply);
            }
        }

        static class SUSPEND {
            public static final int ID = 8;

            SUSPEND() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller) {
                controller.fine(() -> "Suspend all packet");
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                controller.suspendAll();
                for (Object guestThread : controller.getVisibleGuestThreads()) {
                    SuspendedInfo info = controller.getSuspendedInfo(guestThread);
                    if (!(info instanceof UnknownSuspendedInfo)) continue;
                    JDWP.awaitSuspendedInfo(controller, guestThread, info);
                }
                return new CommandResult(reply);
            }
        }

        static class IDSIZES {
            public static final int ID = 7;

            IDSIZES() {
            }

            static CommandResult createReply(Packet packet, com.oracle.truffle.espresso.jdwp.impl.VirtualMachine vm) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.writeInt(vm.getSizeOfFieldRef());
                reply.writeInt(vm.getSizeOfMethodRef());
                reply.writeInt(vm.getSizeofObjectRef());
                reply.writeInt(vm.getSizeOfClassRef());
                reply.writeInt(vm.getSizeOfFrameRef());
                return new CommandResult(reply);
            }
        }

        static class DISPOSE {
            public static final int ID = 6;

            DISPOSE() {
            }

            static CommandResult createReply(Packet packet, final DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                return new CommandResult(reply, null, Collections.singletonList(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        controller.disposeDebugger(true);
                        return null;
                    }
                }));
            }
        }

        static class TOP_LEVEL_THREAD_GROUPS {
            public static final int ID = 5;

            TOP_LEVEL_THREAD_GROUPS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object[] threadGroups = context.getTopLevelThreadGroups();
                reply.writeInt(threadGroups.length);
                for (Object threadGroup : threadGroups) {
                    reply.writeLong(context.getIds().getIdAsLong(threadGroup));
                }
                return new CommandResult(reply);
            }
        }

        static class ALL_THREADS {
            public static final int ID = 4;

            ALL_THREADS() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context, DebuggerController controller) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                Object[] allThreads = controller.getVisibleGuestThreads();
                reply.writeInt(allThreads.length);
                for (Object t : allThreads) {
                    reply.writeLong(context.getIds().getIdAsLong(t));
                }
                return new CommandResult(reply);
            }
        }

        static class ALL_CLASSES {
            public static final int ID = 3;

            ALL_CLASSES() {
            }

            static CommandResult createReply(Packet packet, JDWPContext context) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                KlassRef[] allLoadedClasses = context.getAllLoadedClasses();
                reply.writeInt(allLoadedClasses.length);
                for (KlassRef klass : allLoadedClasses) {
                    reply.writeByte(TypeTag.getKind(klass));
                    reply.writeLong(context.getIds().getIdAsLong(klass));
                    reply.writeString(klass.getTypeAsString());
                    reply.writeInt(klass.getStatus());
                }
                return new CommandResult(reply);
            }
        }

        static class CLASSES_BY_SIGNATURE {
            public static final int ID = 2;

            CLASSES_BY_SIGNATURE() {
            }

            static CommandResult createReply(Packet packet, DebuggerController controller, JDWPContext context) {
                String signature;
                PacketStream input = new PacketStream(packet);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                String slashName = signature = input.readString();
                if (!signature.startsWith("[") && signature.length() != 1) {
                    slashName = signature.substring(1, signature.length() - 1);
                }
                try {
                    KlassRef[] loaded = context.findLoadedClass(slashName);
                    reply.writeInt(loaded.length);
                    for (KlassRef klass : loaded) {
                        reply.writeByte(TypeTag.getKind(klass));
                        reply.writeLong(context.getIds().getIdAsLong(klass));
                        reply.writeInt(klass.getStatus());
                    }
                }
                catch (IllegalStateException e) {
                    controller.warning(() -> "Invalid class name in CLASSES_BY_SIGNATURE: " + signature);
                    reply.writeInt(0);
                }
                return new CommandResult(reply);
            }
        }

        static class VERSION {
            public static final int ID = 1;

            VERSION() {
            }

            static CommandResult createReply(Packet packet, com.oracle.truffle.espresso.jdwp.impl.VirtualMachine vm) {
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.writeString(vm.getVmDescription());
                reply.writeInt(1);
                reply.writeInt(8);
                reply.writeString(vm.getVmVersion());
                reply.writeString(vm.getVmName());
                return new CommandResult(reply);
            }
        }
    }
}

