/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.espresso.jdwp.impl.SuppressFBWarnings;

public final class StableBoolean {
    @CompilerDirectives.CompilationFinal
    private volatile Assumption unchanged;
    @CompilerDirectives.CompilationFinal
    private volatile boolean value;

    public StableBoolean(boolean initialValue) {
        this.value = initialValue;
        this.unchanged = Truffle.getRuntime().createAssumption("Unchanged boolean");
    }

    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="The get method returns a volatile field.")
    public boolean get() {
        if (this.unchanged.isValid()) {
            return this.value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.value;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void set(boolean value) {
        if (this.value != value) {
            this.value = value;
            Assumption old = this.unchanged;
            this.unchanged = Truffle.getRuntime().createAssumption("Unchanged boolean");
            old.invalidate();
        }
    }
}

