/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public final class ModifiedUtf8 {
    private ModifiedUtf8() {
    }

    public static int utfLength(String str) {
        return ModifiedUtf8.utfLength(str, 0, str.length());
    }

    public static int utfLength(String str, int start, int len) {
        char c;
        int i;
        int utflen = 0;
        for (i = 0; i < len && (c = str.charAt(start + i)) >= '\u0001' && c <= '\u007f'; ++i) {
            ++utflen;
        }
        while (i < len) {
            c = str.charAt(start + i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen;
    }

    public static byte[] fromJavaString(String str, boolean append0) {
        return ModifiedUtf8.fromJavaString(str, 0, str.length(), append0);
    }

    public static byte[] fromJavaString(String str, int start, int len, boolean append0) {
        char c;
        int i;
        int utflen = ModifiedUtf8.utfLength(str, start, len);
        byte[] bytearr = new byte[utflen + (append0 ? 1 : 0)];
        int count = 0;
        for (i = 0; i < len && (c = str.charAt(start + i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < len) {
            c = str.charAt(start + i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        if (append0) {
            bytearr[bytearr.length - 1] = 0;
        }
        return bytearr;
    }

    public static byte[] fromJavaString(String string) {
        return ModifiedUtf8.fromJavaString(string, false);
    }

    public static String toJavaString(byte[] bytearr) throws IOException {
        return ModifiedUtf8.toJavaString(bytearr, 0, bytearr.length);
    }

    public static String toJavaString(byte[] bytearr, int offset, int utflen) throws IOException {
        return ModifiedUtf8.toJavaString(ByteBuffer.wrap(bytearr, offset, utflen));
    }

    public static String toJavaString(ByteBuffer buffer) throws IOException {
        int c;
        char[] chararr = new char[buffer.remaining()];
        int chararrCount = 0;
        while (buffer.hasRemaining()) {
            c = buffer.get() & 0xFF;
            if (c > 127) {
                buffer.position(buffer.position() - 1);
                break;
            }
            chararr[chararrCount++] = (char)c;
        }
        block6: while (buffer.hasRemaining()) {
            c = buffer.get() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if (!buffer.hasRemaining()) {
                        throw ModifiedUtf8.throwUTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = buffer.get();
                    if ((char2 & 0xC0) != 128) {
                        throw ModifiedUtf8.throwUTFDataFormatException(ModifiedUtf8.malformedInputMessage(buffer.position()));
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if (buffer.remaining() < 2) {
                        throw ModifiedUtf8.throwUTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = buffer.get();
                    byte char3 = buffer.get();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw ModifiedUtf8.throwUTFDataFormatException(ModifiedUtf8.malformedInputMessage(buffer.position() - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw ModifiedUtf8.throwUTFDataFormatException(ModifiedUtf8.malformedInputMessage(buffer.position()));
        }
        return new String(chararr, 0, chararrCount);
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    private static UTFDataFormatException throwUTFDataFormatException(String message) throws UTFDataFormatException {
        throw new UTFDataFormatException(message);
    }

    @CompilerDirectives.TruffleBoundary
    private static String malformedInputMessage(int count) {
        return "malformed input around byte " + count;
    }

    public static boolean isValid(byte[] bytearr, int offset, int length) {
        int c;
        int count;
        for (count = 0; count < length && (c = bytearr[count + offset] & 0xFF) != 0 && c <= 127; ++count) {
        }
        block6: while (count < length) {
            byte char2;
            c = bytearr[count + offset] & 0xFF;
            if (c == 0) {
                if ((count += 2) > length) {
                    return false;
                }
                char2 = bytearr[count - 1 + offset];
                if (char2 == 0) continue;
                return false;
            }
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > length) {
                        return false;
                    }
                    char2 = bytearr[count - 1 + offset];
                    if ((char2 & 0xC0) == 128) continue block6;
                    return false;
                }
                case 14: {
                    if ((count += 3) > length) {
                        return false;
                    }
                    char2 = bytearr[count - 2 + offset];
                    byte char3 = bytearr[count - 1 + offset];
                    if ((char2 & 0xC0) == 128 && (char3 & 0xC0) == 128) continue block6;
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

