/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="LASTORE")
@GenerateUncached
public abstract class LongArrayStore
extends EspressoNode {
    public abstract void execute(StaticObject var1, int var2, long var3);

    @Specialization
    void doWithNullCheck(StaticObject array, int index, long value, @Cached NullCheck nullCheck, @Cached WithoutNullCheck longArrayStore) {
        longArrayStore.execute(nullCheck.execute(array), index, value);
    }

    @NodeInfo(shortName="LASTORE !nullcheck")
    @GenerateUncached
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        static final int LIMIT = 2;

        public abstract void execute(StaticObject var1, int var2, long var3);

        @Specialization(guards={"array.isEspressoObject()"})
        void doEspresso(StaticObject array, int index, long value) {
            assert (!StaticObject.isNull(array));
            this.getContext().getInterpreterToVM().setArrayLong(this.getLanguage(), value, index, array);
        }

        @Specialization(guards={"array.isForeignObject()"})
        void doArrayLike(StaticObject array, int index, long value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            assert (!StaticObject.isNull(array));
            ForeignArrayUtils.writeForeignArrayElement(array, index, value, this.getLanguage(), this.getContext().getMeta(), interop, exceptionProfile);
        }
    }
}

