/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOfFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class EspressoReferenceArrayStoreNode
extends EspressoNode {
    @Node.Child
    InstanceOf.Dynamic instanceOfDynamic = InstanceOfFactory.DynamicNodeGen.create();
    @CompilerDirectives.CompilationFinal
    boolean noOutOfBoundEx = true;
    @CompilerDirectives.CompilationFinal
    boolean noArrayStoreEx = true;

    public void arrayStore(EspressoLanguage language, Meta meta, StaticObject value, int index, StaticObject array) {
        if (Integer.compareUnsigned(index, array.length(language)) >= 0) {
            this.enterOutOfBound();
            throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
        }
        if (!StaticObject.isNull(value) && !this.instanceOfDynamic.execute(value.getKlass(), ((ArrayKlass)array.getKlass()).getComponentType())) {
            this.enterArrayStoreEx();
            throw meta.throwException(meta.java_lang_ArrayStoreException);
        }
        ((StaticObject[])array.unwrap((EspressoLanguage)language))[index] = value;
    }

    private void enterOutOfBound() {
        if (this.noOutOfBoundEx) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.noOutOfBoundEx = false;
        }
    }

    private void enterArrayStoreEx() {
        if (this.noArrayStoreEx) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.noArrayStoreEx = false;
        }
    }
}

