/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.nodes.EspressoNode;

public abstract class AbstractLookupFieldNode
extends EspressoNode {
    protected abstract Field[] getFieldArray(Klass var1);

    @CompilerDirectives.TruffleBoundary
    protected Field doLookup(Klass klass, String name, boolean publicOnly, FieldLookupKind kind) {
        Field[] table = this.getFieldArray(klass);
        int len = table.length;
        for (int i = len - 1; i >= 0; --i) {
            Field f = table[i];
            if (!(!f.isRemoved() && kind == FieldLookupKind.All || kind == FieldLookupKind.Static && f.isStatic()) && (kind != FieldLookupKind.Instance || f.isStatic()) || !f.getNameAsString().equals(name) || !f.isPublic() && publicOnly) continue;
            return f;
        }
        return null;
    }

    public static enum FieldLookupKind {
        Instance,
        Static,
        All;

    }
}

