/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InitCheck;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.InteropUtils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@GenerateUncached
@ReportPolymorphism
public abstract class InvokeEspressoNode
extends EspressoNode {
    static final int LIMIT = 4;

    public final Object execute(Method method, Object receiver, Object[] arguments, boolean argsConverted) throws ArityException, UnsupportedTypeException {
        Method.MethodVersion resolutionSeed = method.getMethodVersion();
        if (!resolutionSeed.getRedefineAssumption().isValid()) {
            resolutionSeed = method.getContext().getClassRedefinition().handleRemovedMethod(method, method.isStatic() ? method.getDeclaringKlass() : ((StaticObject)receiver).getKlass()).getMethodVersion();
        }
        EspressoLanguage language = this.getLanguage();
        Meta meta = this.getMeta();
        try {
            Object result = this.executeMethod(resolutionSeed, receiver, arguments, argsConverted);
            return InteropUtils.unwrap(language, result, meta);
        }
        catch (EspressoException e) {
            throw InteropUtils.unwrapExceptionBoundary(language, e, meta);
        }
    }

    public final Object execute(Method method, Object receiver, Object[] arguments) throws ArityException, UnsupportedTypeException {
        return this.execute(method, receiver, arguments, false);
    }

    static DirectCallNode createDirectCallNode(CallTarget callTarget) {
        return DirectCallNode.create((CallTarget)callTarget);
    }

    abstract Object executeMethod(Method.MethodVersion var1, Object var2, Object[] var3, boolean var4) throws ArityException, UnsupportedTypeException;

    public static ToEspressoNode[] createToEspresso(Method.MethodVersion methodVersion) {
        Klass[] parameterKlasses = methodVersion.getMethod().resolveParameterKlasses();
        ToEspressoNode[] toEspresso = new ToEspressoNode[parameterKlasses.length];
        for (int i = 0; i < parameterKlasses.length; ++i) {
            toEspresso[i] = ToEspressoNode.createToEspresso(parameterKlasses[i], parameterKlasses[i].getMeta());
        }
        return toEspresso;
    }

    @ExplodeLoop
    @Specialization(guards={"method == cachedMethod"}, limit="LIMIT", assumptions={"cachedMethod.getRedefineAssumption()"})
    Object doCached(Method.MethodVersion method, Object receiver, Object[] arguments, boolean argsConverted, @Cached(value="method") Method.MethodVersion cachedMethod, @Cached(value="createToEspresso(cachedMethod)") ToEspressoNode[] toEspressoNodes, @Cached(value="createDirectCallNode(method.getMethod().getCallTarget())") DirectCallNode directCallNode, @Cached InitCheck initCheck, @Cached BranchProfile badArityProfile) throws ArityException, UnsupportedTypeException {
        Object[] convertedArguments;
        InvokeEspressoNode.checkValidInvoke(method.getMethod(), receiver);
        int expectedArity = cachedMethod.getMethod().getParameterCount();
        if (arguments.length != expectedArity) {
            badArityProfile.enter();
            throw ArityException.create((int)expectedArity, (int)expectedArity, (int)arguments.length);
        }
        Object[] objectArray = convertedArguments = argsConverted ? arguments : new Object[expectedArity];
        if (!argsConverted) {
            for (int i = 0; i < expectedArity; ++i) {
                convertedArguments[i] = toEspressoNodes[i].execute(arguments[i]);
            }
        }
        initCheck.execute(cachedMethod.getDeclaringKlass());
        if (!cachedMethod.getMethod().isStatic()) {
            Object[] argumentsWithReceiver = new Object[convertedArguments.length + 1];
            argumentsWithReceiver[0] = receiver;
            System.arraycopy(convertedArguments, 0, argumentsWithReceiver, 1, convertedArguments.length);
            return directCallNode.call(argumentsWithReceiver);
        }
        return directCallNode.call(convertedArguments);
    }

    @Specialization(replaces={"doCached"})
    @ReportPolymorphism.Megamorphic
    Object doGeneric(Method.MethodVersion method, Object receiver, Object[] arguments, boolean argsConverted, @Cached ToEspressoNode.DynamicToEspresso toEspressoNode, @Cached IndirectCallNode indirectCallNode) throws ArityException, UnsupportedTypeException {
        Object[] convertedArguments;
        InvokeEspressoNode.checkValidInvoke(method.getMethod(), receiver);
        int expectedArity = method.getMethod().getParameterCount();
        if (arguments.length != expectedArity) {
            throw ArityException.create((int)expectedArity, (int)expectedArity, (int)arguments.length);
        }
        Object[] objectArray = convertedArguments = argsConverted ? arguments : new Object[expectedArity];
        if (!argsConverted) {
            Klass[] parameterKlasses = InvokeEspressoNode.getParameterKlasses(method.getMethod());
            for (int i = 0; i < expectedArity; ++i) {
                convertedArguments[i] = toEspressoNode.execute(arguments[i], parameterKlasses[i]);
            }
        }
        if (!method.getMethod().isStatic()) {
            Object[] argumentsWithReceiver = new Object[convertedArguments.length + 1];
            argumentsWithReceiver[0] = receiver;
            System.arraycopy(convertedArguments, 0, argumentsWithReceiver, 1, convertedArguments.length);
            return indirectCallNode.call(method.getCallTarget(), argumentsWithReceiver);
        }
        return indirectCallNode.call(method.getMethod().getCallTargetForceInit(), convertedArguments);
    }

    @CompilerDirectives.TruffleBoundary
    private static Klass[] getParameterKlasses(Method method) {
        return method.resolveParameterKlasses();
    }

    private static void checkValidInvoke(Method method, Object receiver) {
        EspressoError.guarantee(!method.isSignaturePolymorphicDeclared(), "Espresso interop does not support signature polymorphic methods.");
        EspressoError.guarantee(method.isStatic() && receiver == null || !method.isStatic() && method.isPublic() && receiver != null, "Espresso interop only supports static methods and public instance method");
    }
}

