/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.interop.LookupInternalTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.LookupProxyKlassNode;
import com.oracle.truffle.espresso.nodes.interop.LookupTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitive;
import com.oracle.truffle.espresso.nodes.interop.ToReferenceFactory;
import com.oracle.truffle.espresso.nodes.interop.WrappedProxyKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@NodeInfo(shortName="Convert to Espresso StaticObject")
@GenerateUncached
public abstract class ToReference
extends ToEspressoNode {
    @Override
    public abstract StaticObject execute(Object var1) throws UnsupportedTypeException;

    @CompilerDirectives.TruffleBoundary
    public static ToReference createToReference(Klass targetType, Meta meta) {
        if (targetType == meta.java_lang_Void) {
            return ToReferenceFactory.ToVoidNodeGen.create();
        }
        if (targetType == meta.java_lang_Boolean) {
            return ToReferenceFactory.ToBooleanNodeGen.create();
        }
        if (targetType == meta.java_lang_Character) {
            return ToReferenceFactory.ToCharNodeGen.create();
        }
        if (targetType == meta.java_lang_Integer) {
            return ToReferenceFactory.ToIntegerNodeGen.create();
        }
        if (targetType == meta.java_lang_Byte) {
            return ToReferenceFactory.ToByteNodeGen.create();
        }
        if (targetType == meta.java_lang_Short) {
            return ToReferenceFactory.ToShortNodeGen.create();
        }
        if (targetType == meta.java_lang_Long) {
            return ToReferenceFactory.ToLongNodeGen.create();
        }
        if (targetType == meta.java_lang_Float) {
            return ToReferenceFactory.ToFloatNodeGen.create();
        }
        if (targetType == meta.java_lang_Double) {
            return ToReferenceFactory.ToDoubleNodeGen.create();
        }
        if (targetType == meta.java_lang_Number) {
            return ToReferenceFactory.ToNumberNodeGen.create();
        }
        if (targetType == meta._byte_array) {
            return ToReferenceFactory.ToByteArrayNodeGen.create();
        }
        if (targetType.isArray()) {
            return ToReferenceFactory.ToArrayNodeGen.create((ArrayKlass)targetType);
        }
        if (targetType.isJavaLangObject()) {
            return ToReferenceFactory.ToJavaLangObjectNodeGen.create();
        }
        if (targetType == meta.java_lang_String) {
            return ToReferenceFactory.ToStringNodeGen.create();
        }
        if (targetType.isInterface()) {
            if (targetType.getContext().getEspressoEnv().BuiltInPolyglotCollections) {
                if (targetType == meta.java_util_List && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToListNodeGen.create();
                }
                if (targetType == meta.java_util_Set && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToSetNodeGen.create();
                }
                if (targetType == meta.java_util_Collection && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToCollectionNodeGen.create();
                }
                if (targetType == meta.java_lang_Iterable && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToIterableNodeGen.create();
                }
                if (targetType == meta.java_util_Iterator && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToIteratorNodeGen.create();
                }
                if (targetType == meta.java_util_Map && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToMapNodeGen.create();
                }
            }
            if (targetType == meta.java_lang_CharSequence) {
                return ToReferenceFactory.ToCharSequenceNodeGen.create();
            }
            if (ToReference.isTypeMappingEnabled(targetType)) {
                return ToReferenceFactory.ToMappedInterfaceNodeGen.create((ObjectKlass)targetType);
            }
            return ToReferenceFactory.ToUnknownNodeGen.create((ObjectKlass)targetType);
        }
        if (ToReference.isForeignException(targetType, meta)) {
            return ToReferenceFactory.ToForeignExceptionNodeGen.create();
        }
        if (targetType == meta.java_lang_Throwable) {
            return ToReferenceFactory.ToThrowableNodeGen.create();
        }
        if (targetType == meta.java_lang_Exception) {
            return ToReferenceFactory.ToExceptionNodeGen.create();
        }
        if (targetType == meta.java_lang_RuntimeException) {
            return ToReferenceFactory.ToRuntimeExceptionNodeGen.create();
        }
        if (targetType == meta.java_time_LocalDate) {
            return ToReferenceFactory.ToLocalDateNodeGen.create();
        }
        if (targetType == meta.java_time_LocalTime) {
            return ToReferenceFactory.ToLocalTimeNodeGen.create();
        }
        if (targetType == meta.java_time_LocalDateTime) {
            return ToReferenceFactory.ToLocalDateTimeNodeGen.create();
        }
        if (targetType == meta.java_time_ZonedDateTime) {
            return ToReferenceFactory.ToZonedDateTimeNodeGen.create();
        }
        if (targetType == meta.java_time_Instant) {
            return ToReferenceFactory.ToInstantNodeGen.create();
        }
        if (targetType == meta.java_time_Duration) {
            return ToReferenceFactory.ToDurationNodeGen.create();
        }
        if (targetType == meta.java_time_ZoneId) {
            return ToReferenceFactory.ToZoneIdNodeGen.create();
        }
        if (targetType == meta.java_util_Date) {
            return ToReferenceFactory.ToDateNodeGen.create();
        }
        if (targetType == meta.java_math_BigInteger) {
            return ToReferenceFactory.ToBigIntegerNodeGen.create();
        }
        if (ToReference.isTypeConverterEnabled(targetType)) {
            return ToReferenceFactory.ToMappedTypeNodeGen.create((ObjectKlass)targetType);
        }
        if (ToReference.isInternalTypeConverterEnabled(targetType)) {
            return ToReferenceFactory.ToMappedInternalTypeNodeGen.create((ObjectKlass)targetType);
        }
        return ToReferenceFactory.ToUnknownNodeGen.create((ObjectKlass)targetType);
    }

    @CompilerDirectives.TruffleBoundary
    static ToReference getUncachedToReference(Klass targetType, Meta meta) {
        if (targetType == meta.java_lang_Void) {
            return ToReferenceFactory.ToVoidNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Boolean) {
            return ToReferenceFactory.ToBooleanNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Character) {
            return ToReferenceFactory.ToCharNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Integer) {
            return ToReferenceFactory.ToIntegerNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Byte) {
            return ToReferenceFactory.ToByteNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Short) {
            return ToReferenceFactory.ToShortNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Long) {
            return ToReferenceFactory.ToLongNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Float) {
            return ToReferenceFactory.ToFloatNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Double) {
            return ToReferenceFactory.ToDoubleNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Number) {
            return ToReferenceFactory.ToNumberNodeGen.getUncached();
        }
        if (targetType == meta._byte_array) {
            return ToReferenceFactory.ToByteArrayNodeGen.getUncached();
        }
        if (targetType.isArray()) {
            return null;
        }
        if (targetType.isJavaLangObject()) {
            return ToReferenceFactory.ToJavaLangObjectNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_String) {
            return ToReferenceFactory.ToStringNodeGen.getUncached();
        }
        if (targetType.isInterface()) {
            if (targetType == meta.java_lang_CharSequence) {
                return ToReferenceFactory.ToCharSequenceNodeGen.getUncached();
            }
            if (targetType.getContext().getEspressoEnv().BuiltInPolyglotCollections) {
                if (targetType == meta.java_util_List && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToListNodeGen.getUncached();
                }
                if (targetType == meta.java_util_Set && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToSetNodeGen.getUncached();
                }
                if (targetType == meta.java_util_Collection && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToCollectionNodeGen.getUncached();
                }
                if (targetType == meta.java_lang_Iterable && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToIterableNodeGen.getUncached();
                }
                if (targetType == meta.java_util_Iterator && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToIteratorNodeGen.getUncached();
                }
                if (targetType == meta.java_util_Map && targetType.isInternalCollectionTypeMapped()) {
                    return ToReferenceFactory.ToMapNodeGen.getUncached();
                }
            }
            return null;
        }
        if (ToReference.isForeignException(targetType, meta)) {
            return ToReferenceFactory.ToForeignExceptionNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Throwable) {
            return ToReferenceFactory.ToThrowableNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_Exception) {
            return ToReferenceFactory.ToExceptionNodeGen.getUncached();
        }
        if (targetType == meta.java_lang_RuntimeException) {
            return ToReferenceFactory.ToRuntimeExceptionNodeGen.getUncached();
        }
        if (targetType == meta.java_time_LocalDate) {
            return ToReferenceFactory.ToLocalDateNodeGen.getUncached();
        }
        if (targetType == meta.java_time_LocalTime) {
            return ToReferenceFactory.ToLocalTimeNodeGen.getUncached();
        }
        if (targetType == meta.java_time_LocalDateTime) {
            return ToReferenceFactory.ToLocalDateTimeNodeGen.getUncached();
        }
        if (targetType == meta.java_time_ZonedDateTime) {
            return ToReferenceFactory.ToZonedDateTimeNodeGen.getUncached();
        }
        if (targetType == meta.java_time_Instant) {
            return ToReferenceFactory.ToInstantNodeGen.getUncached();
        }
        if (targetType == meta.java_time_Duration) {
            return ToReferenceFactory.ToDurationNodeGen.getUncached();
        }
        if (targetType == meta.java_time_ZoneId) {
            return ToReferenceFactory.ToZoneIdNodeGen.getUncached();
        }
        if (targetType == meta.java_util_Date) {
            return ToReferenceFactory.ToDateNodeGen.getUncached();
        }
        if (targetType == meta.java_math_BigInteger) {
            return ToReferenceFactory.ToBigIntegerNodeGen.getUncached();
        }
        return null;
    }

    static StaticObject tryTypeConversion(Object value, InteropLibrary interop, LookupProxyKlassNode lookupProxyKlassNode, LookupTypeConverterNode lookupTypeConverterNode, LookupInternalTypeConverterNode lookupInternalTypeConverterNode, DynamicToReference converterToEspresso, BranchProfile errorProfile, Meta meta) throws UnsupportedTypeException {
        try {
            Object metaObject = ToReference.getMetaObjectOrThrow(value, interop);
            String metaName = ToReference.getMetaName(metaObject, interop);
            PolyglotTypeMappings.InternalTypeConverter internalConverter = lookupInternalTypeConverterNode.execute(metaName);
            if (internalConverter != null) {
                return internalConverter.convertInternal(interop, value, meta, converterToEspresso);
            }
            PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
            if (converter != null) {
                if (interop.isException(value)) {
                    return (StaticObject)converter.convert(StaticObject.createForeignException(converterToEspresso.getContext(), value, interop));
                }
                return (StaticObject)converter.convert(StaticObject.createForeign(converterToEspresso.getLanguage(), meta.java_lang_Object, value, interop));
            }
            if (interop.isException(value)) {
                return StaticObject.createForeignException(converterToEspresso.getContext(), value, interop);
            }
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_lang_Object);
            if (proxyKlass != null) {
                return proxyKlass.createProxyInstance(value, converterToEspresso.getLanguage(), interop);
            }
            return StaticObject.createForeign(converterToEspresso.getLanguage(), meta.java_lang_Object, value, interop);
        }
        catch (ClassCastException e) {
            errorProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: due to: %s", meta.java_lang_Object.getNameAsString(), e.getMessage()));
        }
    }

    static StaticObject tryConverterForUnknownTarget(Object value, InteropLibrary interop, LookupTypeConverterNode lookupTypeConverterNode, LookupInternalTypeConverterNode lookupInternalTypeConverterNode, DynamicToReference converterToEspresso, Meta meta) throws UnsupportedTypeException {
        try {
            StaticObject foreignWrapper;
            Object metaObject = ToReference.getMetaObjectOrThrow(value, interop);
            String metaName = ToReference.getMetaName(metaObject, interop);
            PolyglotTypeMappings.InternalTypeConverter internalConverter = lookupInternalTypeConverterNode.execute(metaName);
            if (internalConverter != null) {
                return internalConverter.convertInternal(interop, value, meta, converterToEspresso);
            }
            PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
            boolean isException = interop.isException(value);
            StaticObject staticObject = foreignWrapper = isException ? StaticObject.createForeignException(converterToEspresso.getContext(), value, interop) : null;
            if (converter != null) {
                if (foreignWrapper == null) {
                    foreignWrapper = StaticObject.createForeign(converterToEspresso.getLanguage(), meta.java_lang_Object, value, interop);
                }
                return (StaticObject)converter.convert(foreignWrapper);
            }
            return foreignWrapper;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static boolean isStaticObject(Object obj) {
        return obj instanceof StaticObject;
    }

    static boolean isHostNumber(Object obj) {
        return obj instanceof Number;
    }

    static boolean isEspressoString(StaticObject obj, Meta meta) {
        return obj.getKlass() == meta.java_lang_String;
    }

    static boolean isBoxedPrimitive(Object obj) {
        return obj instanceof Number || obj instanceof Character || obj instanceof Boolean;
    }

    static boolean isEspressoException(Object obj) {
        return obj instanceof EspressoException;
    }

    @Idempotent
    static boolean isTypeMappingEnabled(EspressoContext context) {
        return context.getPolyglotTypeMappings().hasMappings();
    }

    static boolean isHostObject(EspressoContext context, Object value) {
        return context.getEnv().isHostObject(value);
    }

    @NodeInfo(shortName="void target type")
    @GenerateUncached
    static abstract class ToVoid
    extends ToReference {
        ToVoid() {
        }

        @Specialization
        public StaticObject doVoid(Object value) {
            return StaticObject.NULL;
        }
    }

    @NodeInfo(shortName="boolean target type")
    @GenerateUncached
    static abstract class ToBoolean
    extends ToReference {
        protected static final int LIMIT = 2;

        ToBoolean() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doBoolean(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToBoolean toBoolean, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxBoolean((Boolean)toBoolean.execute(value));
        }
    }

    @NodeInfo(shortName="char target type")
    @GenerateUncached
    static abstract class ToChar
    extends ToReference {
        protected static final int LIMIT = 2;

        ToChar() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doChar(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToChar toChar, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxCharacter(((Character)toChar.execute(value)).charValue());
        }
    }

    @NodeInfo(shortName="integer target type")
    @GenerateUncached
    static abstract class ToInteger
    extends ToReference {
        protected static final int LIMIT = 2;

        ToInteger() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doInteger(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToInt toInt, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxInteger((Integer)toInt.execute(value));
        }
    }

    @NodeInfo(shortName="byte target type")
    @GenerateUncached
    static abstract class ToByte
    extends ToReference {
        protected static final int LIMIT = 2;

        ToByte() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doByte(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToByte toByte, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxByte((Byte)toByte.execute(value));
        }
    }

    @NodeInfo(shortName="short target type")
    @GenerateUncached
    static abstract class ToShort
    extends ToReference {
        protected static final int LIMIT = 2;

        ToShort() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doShort(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToShort toShort, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxShort((Short)toShort.execute(value));
        }
    }

    @NodeInfo(shortName="long target type")
    @GenerateUncached
    static abstract class ToLong
    extends ToReference {
        protected static final int LIMIT = 2;

        ToLong() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doLong(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToLong toLong, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxLong((Long)toLong.execute(value));
        }
    }

    @NodeInfo(shortName="float target type")
    @GenerateUncached
    static abstract class ToFloat
    extends ToReference {
        protected static final int LIMIT = 2;

        ToFloat() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doFloat(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToFloat toFloat, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxFloat(((Float)toFloat.execute(value)).floatValue());
        }
    }

    @NodeInfo(shortName="double target type")
    @GenerateUncached
    static abstract class ToDouble
    extends ToReference {
        protected static final int LIMIT = 2;

        ToDouble() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doDouble(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToDouble toDouble, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxDouble((Double)toDouble.execute(value));
        }
    }

    @NodeInfo(shortName="Number type mapping")
    @GenerateUncached
    public static abstract class ToNumber
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_lang_Number)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Number.getTypeAsString());
        }

        @Specialization
        StaticObject doHostInteger(Integer value) {
            return this.getMeta().boxInteger(value);
        }

        @Specialization
        StaticObject doHostByte(Byte value) {
            return this.getMeta().boxByte(value);
        }

        @Specialization
        StaticObject doHostShort(Short value) {
            return this.getMeta().boxShort(value);
        }

        @Specialization
        StaticObject doHostLong(Long value) {
            return this.getMeta().boxLong(value);
        }

        @Specialization
        StaticObject doHostFloat(Float value) {
            return this.getMeta().boxFloat(value.floatValue());
        }

        @Specialization
        StaticObject doHostDouble(Double value) {
            return this.getMeta().boxDouble(value);
        }

        @Specialization(guards={"interop.isNumber(value)", "!isStaticObject(value)", "!isHostNumber(value)"})
        StaticObject doForeignNumber(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (interop.fitsInBigInteger(value) || interop.fitsInDouble(value)) {
                return StaticObject.createForeign(this.getLanguage(), meta.polyglot.EspressoForeignNumber, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Number.getTypeAsString());
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Number.getTypeAsString());
        }
    }

    @NodeInfo(shortName="byte array type mapping")
    @GenerateUncached
    public static abstract class ToByteArray
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta._byte_array)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta._byte_array.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.hasBufferElements(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)"})
        StaticObject doForeignBuffer(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(EspressoLanguage.get(this), meta._byte_array, value, interop);
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.hasArrayElements(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)"})
        StaticObject doForeignArray(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(EspressoLanguage.get(this), meta._byte_array, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta()._byte_array.getTypeAsString());
        }
    }

    @NodeInfo(shortName="array type mapping")
    public static abstract class ToArray
    extends ToReference {
        protected static final int LIMIT = 4;
        private final ArrayKlass targetType;

        protected ToArray(ArrayKlass targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), this.targetType)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)"})
        StaticObject doForeignArray(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeign(EspressoLanguage.get(this), this.targetType, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }
    }

    @NodeInfo(shortName="j.l.Object target type")
    @GenerateUncached
    public static abstract class ToJavaLangObject
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization
        public StaticObject doEspresso(StaticObject value) {
            return value;
        }

        @Specialization
        StaticObject doEspressoException(EspressoException value) {
            return value.getGuestException();
        }

        @Specialization
        StaticObject doHostString(String value, @Bind(value="getMeta()") Meta meta) {
            return meta.toGuestString(value);
        }

        @Specialization
        StaticObject doHostInteger(Integer value) {
            return this.getMeta().boxInteger(value);
        }

        @Specialization
        StaticObject doHostBoolean(Boolean value) {
            return this.getMeta().boxBoolean(value);
        }

        @Specialization
        StaticObject doHostByte(Byte value) {
            return this.getMeta().boxByte(value);
        }

        @Specialization
        StaticObject doHostChar(Character value) {
            return this.getMeta().boxCharacter(value.charValue());
        }

        @Specialization
        StaticObject doHostShort(Short value) {
            return this.getMeta().boxShort(value);
        }

        @Specialization
        StaticObject doHostLong(Long value) {
            return this.getMeta().boxLong(value);
        }

        @Specialization
        StaticObject doHostFloat(Float value) {
            return this.getMeta().boxFloat(value.floatValue());
        }

        @Specialization
        StaticObject doHostDouble(Double value) {
            return this.getMeta().boxDouble(value);
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"interop.isBoolean(value)", "!isStaticObject(value)"})
        StaticObject doForeignBoolean(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return this.getMeta().boxBoolean(interop.asBoolean(value));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isBoolean returns true, asBoolean must succeed.");
            }
        }

        @Specialization(guards={"interop.isNumber(value)", "!isStaticObject(value)", "!isHostNumber(value)"})
        StaticObject doForeignNumber(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            if (interop.fitsInBigInteger(value) || interop.fitsInDouble(value)) {
                return StaticObject.createForeign(this.getLanguage(), context.getMeta().polyglot.EspressoForeignNumber, value, interop);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"unsupported number");
        }

        @Specialization(guards={"interop.isString(value)", "!isStaticObject(value)"})
        StaticObject doForeignString(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                String hostString = interop.asString(value);
                return meta.toGuestString(hostString);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Specialization(guards={"interop.isException(value)", "!isTypeMappingEnabled(context)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        StaticObject doForeignExceptionNoTypeMapping(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context) {
            return StaticObject.createForeignException(context, value, interop);
        }

        @Specialization(guards={"interop.isException(value)", "isTypeMappingEnabled(context)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        StaticObject doForeignExceptionTypeMapping(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context, @Cached BranchProfile errorProfile, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getMeta()") Meta meta) {
            try {
                return ToJavaLangObject.tryTypeConversion(value, interop, lookupProxyKlassNode, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, errorProfile, meta);
            }
            catch (UnsupportedTypeException ex) {
                return StaticObject.createForeignException(context, value, interop);
            }
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "!isTypeMappingEnabled(context)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignArray(Object value, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta().java_lang_Object, value, interop);
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "isTypeMappingEnabled(context)", "!interop.hasMetaObject(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignArrayNoMetaObject(Object value, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(this.getLanguage(), meta.java_lang_Object, value, interop);
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "isTypeMappingEnabled(context)", "interop.hasMetaObject(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignArrayTypeMapping(Object value, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile errorProfile, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return ToJavaLangObject.tryTypeConversion(value, interop, lookupProxyKlassNode, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, errorProfile, meta);
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.hasBufferElements(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignBuffer(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(EspressoLanguage.get(this), meta._byte_array, value, interop);
        }

        @Specialization(guards={"!isTypeMappingEnabled(context)", "interop.hasMetaObject(value)", "!interop.hasArrayElements(value)", "!interop.hasBufferElements(value)", "!interop.isException(value)", "!interop.isNumber(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        StaticObject doJavaLangObjectForeignWrapper(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(this.getLanguage(), meta.java_lang_Object, value, interop);
        }

        @Specialization(guards={"isTypeMappingEnabled(context)", "interop.hasMetaObject(value)", "!interop.isNumber(value)", "!interop.isException(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        StaticObject doForeignTypeMapping(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached BranchProfile errorProfile, @Bind(value="getContext()") EspressoContext context, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return ToJavaLangObject.tryTypeConversion(value, interop, lookupProxyKlassNode, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, errorProfile, meta);
        }

        @Specialization(guards={"!interop.hasMetaObject(value)", "!interop.hasArrayElements(value)", "!interop.isBoolean(value)", "!interop.isNumber(value)", "!interop.isString(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignObject(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta().java_lang_Object, value, interop);
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"java.lang.Object");
        }
    }

    @NodeInfo(shortName="j.l.String target type")
    @GenerateUncached
    public static abstract class ToString
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        StaticObject doHostString(String value, @Bind(value="getMeta()") Meta meta) {
            return meta.toGuestString(value);
        }

        @Specialization(guards={"isEspressoString(value, meta)"})
        StaticObject doEspressoString(StaticObject value, @Bind(value="getMeta()") Meta meta) {
            return value;
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostString(value)", "interop.isString(value)"})
        StaticObject doForeignString(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                String hostString = interop.asString(value);
                return meta.toGuestString(hostString);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "!interop.isString(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_String.getTypeAsString());
        }
    }

    @NodeInfo(shortName="List type mapping")
    @GenerateUncached
    public static abstract class ToList
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_List)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", meta.java_util_List.getTypeAsString()));
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "interop.hasMetaObject(value)", "isHostObject(context, value)"})
        public StaticObject doMappedList(Object value, @Bind(value="getContext()") EspressoContext context, @Bind(value="getLanguage()") EspressoLanguage language, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            Object metaObject = ToList.getMetaObjectOrThrow(value, interop);
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToList.getMetaName(metaObject, interop), context.getMeta().java_util_List);
            if (proxyKlass == null) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_List.getTypeAsString());
            }
            return proxyKlass.createProxyInstance(value, language, interop);
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_List.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Set type mapping")
    @GenerateUncached
    public static abstract class ToSet
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_Set)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", meta.java_util_Set.getTypeAsString()));
        }

        @Specialization(guards={"interop.hasMetaObject(value)", "isHostObject(getContext(), value)"})
        public StaticObject doMappedSet(Object value, @Bind(value="getMeta()") Meta meta, @Bind(value="getLanguage()") EspressoLanguage language, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            Object metaObject = ToSet.getMetaObjectOrThrow(value, interop);
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToSet.getMetaName(metaObject, interop), meta.java_util_Set);
            if (proxyKlass == null) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Set.getTypeAsString());
            }
            return proxyKlass.createProxyInstance(value, language, interop);
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Set.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Collection type mapping")
    @GenerateUncached
    public static abstract class ToCollection
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_Collection)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", meta.java_util_Collection.getTypeAsString()));
        }

        @Specialization(guards={"interop.hasIterator(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)"})
        public StaticObject doMappedCollection(Object value, @Bind(value="getMeta()") Meta meta, @Bind(value="getLanguage()") EspressoLanguage language, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            Object metaObject = ToCollection.getMetaObjectOrThrow(value, interop);
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToCollection.getMetaName(metaObject, interop), meta.java_util_Collection);
            if (proxyKlass == null) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Collection.getTypeAsString());
            }
            return proxyKlass.createProxyInstance(value, language, interop);
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Collection.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Iterable type mapping")
    @GenerateUncached
    public static abstract class ToIterable
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_lang_Iterable)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", meta.java_lang_Iterable.getTypeAsString()));
        }

        @Specialization(guards={"interop.hasIterator(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)"})
        public StaticObject doMappedIterable(Object value, @Bind(value="getMeta()") Meta meta, @Bind(value="getLanguage()") EspressoLanguage language, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            Object metaObject = ToIterable.getMetaObjectOrThrow(value, interop);
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToIterable.getMetaName(metaObject, interop), meta.java_lang_Iterable);
            if (proxyKlass == null) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Iterable.getTypeAsString());
            }
            return proxyKlass.createProxyInstance(value, language, interop);
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Iterable.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Iterator type mapping")
    @GenerateUncached
    public static abstract class ToIterator
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_Iterator)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", meta.java_util_Iterator.getTypeAsString()));
        }

        @Specialization(guards={"interop.isIterator(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)"})
        public StaticObject doMappedIterator(Object value, @Bind(value="getMeta()") Meta meta, @Bind(value="getLanguage()") EspressoLanguage language, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            Object metaObject = ToIterator.getMetaObjectOrThrow(value, interop);
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToIterator.getMetaName(metaObject, interop), meta.java_util_Iterator);
            if (proxyKlass == null) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Iterator.getTypeAsString());
            }
            return proxyKlass.createProxyInstance(value, language, interop);
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Iterator.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Map type mapping")
    @GenerateUncached
    public static abstract class ToMap
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_Map)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", meta.java_util_Map.getTypeAsString()));
        }

        @Specialization(guards={"interop.hasHashEntries(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)"})
        public StaticObject doMappedMap(Object value, @Bind(value="getMeta()") Meta meta, @Bind(value="getLanguage()") EspressoLanguage language, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            Object metaObject = ToMap.getMetaObjectOrThrow(value, interop);
            WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToMap.getMetaName(metaObject, interop), meta.java_util_Map);
            if (proxyKlass == null) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Map.getTypeAsString());
            }
            return proxyKlass.createProxyInstance(value, language, interop);
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Map.getTypeAsString());
        }
    }

    @NodeInfo(shortName="j.l.CharSequence target type")
    @GenerateUncached
    public static abstract class ToCharSequence
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        StaticObject doHostString(String value, @Bind(value="getMeta()") Meta meta) {
            return meta.toGuestString(value);
        }

        @Specialization(guards={"isEspressoString(value, meta)"})
        StaticObject doEspressoString(StaticObject value, @Bind(value="getMeta()") Meta meta) {
            return value;
        }

        @Specialization(guards={"!isEspressoString(value, meta)"})
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_lang_CharSequence)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_CharSequence.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostString(value)", "interop.isString(value)"})
        StaticObject doForeignString(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                String hostString = interop.asString(value);
                return meta.toGuestString(hostString);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_String.getTypeAsString());
        }
    }

    @NodeInfo(shortName="interface type mapping")
    public static abstract class ToMappedInterface
    extends ToReference {
        protected static final int LIMIT = 4;
        private final ObjectKlass targetType;

        ToMappedInterface(ObjectKlass targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), this.targetType)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!interop.isNull(value)", "isHostObject(getContext(), value)"})
        StaticObject doForeignInterface(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached BranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                Object metaObject = ToMappedInterface.getMetaObjectOrThrow(value, interop);
                WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToMappedInterface.getMetaName(metaObject, interop), this.targetType);
                if (proxyKlass != null) {
                    return proxyKlass.createProxyInstance(value, this.getLanguage(), interop);
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                errorProfile.enter();
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", this.targetType.getNameAsString(), e.getMessage()));
            }
        }
    }

    @NodeInfo(shortName="unknown type mapping")
    public static abstract class ToUnknown
    extends ToReference {
        protected static final int LIMIT = 4;
        private final ObjectKlass targetType;

        ToUnknown(ObjectKlass targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || this.targetType.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignWrapper(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached InlinedBranchProfile unknownProfile, @Cached InlinedBranchProfile noConverterProfile, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            ToReference uncachedToReference = ToUnknown.getUncachedToReference(this.targetType, meta);
            if (uncachedToReference != null) {
                return uncachedToReference.execute(value);
            }
            unknownProfile.enter((Node)this);
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, meta);
            if (result != null) {
                return result;
            }
            try {
                noConverterProfile.enter((Node)this);
                ToUnknown.checkHasAllFieldsOrThrow(value, this.targetType, interop, this.getMeta());
                return StaticObject.createForeign(this.getLanguage(), this.targetType, value, interop);
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
            }
        }

        @Specialization
        public StaticObject doUnknown(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }
    }

    @NodeInfo(shortName="foreign exception type mapping")
    @GenerateUncached
    public static abstract class ToForeignException
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeignException(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context) {
            return StaticObject.createForeignException(context, value, interop);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), this.getMeta().polyglot.ForeignException)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().polyglot.ForeignException.getTypeAsString());
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().polyglot.ForeignException.getTypeAsString());
        }
    }

    @NodeInfo(shortName="throwable type mapping")
    @GenerateUncached
    public static abstract class ToThrowable
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || meta.java_lang_Throwable.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Throwable.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspressoException(EspressoException value) {
            return value.getGuestException();
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Throwable.getTypeAsString());
        }
    }

    @NodeInfo(shortName="exception type mapping")
    @GenerateUncached
    public static abstract class ToException
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || meta.java_lang_Exception.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Exception.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspressoException(EspressoException value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            StaticObject guestException = value.getGuestException();
            if (meta.java_lang_Exception.isAssignableFrom(guestException.getKlass())) {
                return guestException;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Exception.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Exception.getTypeAsString());
        }
    }

    @NodeInfo(shortName="runtime exception type mapping")
    @GenerateUncached
    public static abstract class ToRuntimeException
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || meta.java_lang_RuntimeException.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_RuntimeException.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspressoException(EspressoException value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            StaticObject guestException = value.getGuestException();
            if (meta.java_lang_RuntimeException.isAssignableFrom(guestException.getKlass())) {
                return guestException;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_RuntimeException.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso) throws UnsupportedTypeException {
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_RuntimeException.getTypeAsString());
        }
    }

    @NodeInfo(shortName="LocalDate type mapping")
    @GenerateUncached
    public static abstract class ToLocalDate
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_LocalDate)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_LocalDate.getTypeAsString());
        }

        @Specialization(guards={"interop.isDate(value)"})
        StaticObject doForeignLocalDate(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                LocalDate localDate = interop.asDate(value);
                return (StaticObject)meta.java_time_LocalDate_of.invokeDirect(null, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isDate returns true, asDate must succeed.");
            }
        }

        @Specialization(guards={"!interop.isDate(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_LocalDate.getTypeAsString());
        }
    }

    @NodeInfo(shortName="LocalTime type mapping")
    @GenerateUncached
    public static abstract class ToLocalTime
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_LocalTime)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_LocalTime.getTypeAsString());
        }

        @Specialization(guards={"interop.isTime(value)"})
        StaticObject doForeignLocalTime(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                LocalTime localTime = interop.asTime(value);
                return (StaticObject)meta.java_time_LocalTime_of.invokeDirect(null, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isTime returns true, asTime must succeed.");
            }
        }

        @Specialization(guards={"!interop.isTime(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_LocalTime.getTypeAsString());
        }
    }

    @NodeInfo(shortName="LocalDateTime type mapping")
    @GenerateUncached
    public static abstract class ToLocalDateTime
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_LocalDateTime)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_LocalDateTime.getTypeAsString());
        }

        @Specialization(guards={"interop.isTime(value)", "interop.isDate(value)"})
        StaticObject doForeignLocalDateTime(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                LocalDate localDate = interop.asDate(value);
                LocalTime localTime = interop.asTime(value);
                StaticObject guestLocalDate = (StaticObject)meta.java_time_LocalDate_of.invokeDirect(null, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
                StaticObject guestLocalTime = (StaticObject)meta.java_time_LocalTime_of.invokeDirect(null, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
                return (StaticObject)meta.java_time_LocalDateTime_of.invokeDirect(null, guestLocalDate, guestLocalTime);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isDate returns true, asDate must succeed.");
            }
        }

        @Specialization(guards={"!interop.isTime(value)", "!interop.isDate(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_LocalDateTime.getTypeAsString());
        }
    }

    @NodeInfo(shortName="ZonedDateTime type mapping")
    @GenerateUncached
    public static abstract class ToZonedDateTime
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_ZonedDateTime)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_ZonedDateTime.getTypeAsString());
        }

        @Specialization(guards={"interop.isInstant(value)", "interop.isTimeZone(value)"})
        StaticObject doForeignDateTime(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Instant instant = interop.asInstant(value);
                ZoneId zoneId = interop.asTimeZone(value);
                StaticObject guestInstant = (StaticObject)meta.java_time_Instant_ofEpochSecond.invokeDirect(null, instant.getEpochSecond(), instant.getNano());
                StaticObject guestZoneID = (StaticObject)meta.java_time_ZoneId_of.invokeDirect(null, meta.toGuestString(zoneId.getId()));
                return (StaticObject)meta.java_time_ZonedDateTime_ofInstant.invokeDirect(null, guestInstant, guestZoneID);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isTime returns true, asTime must succeed.");
            }
        }

        @Specialization(guards={"!interop.isInstant(value)", "!interop.isTimeZone(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_ZonedDateTime.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Instant type mapping")
    @GenerateUncached
    public static abstract class ToInstant
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_Instant)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_Instant.getTypeAsString());
        }

        @Specialization(guards={"interop.isInstant(value)"})
        StaticObject doForeignInstant(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Instant instant = interop.asInstant(value);
                return (StaticObject)meta.java_time_Instant_ofEpochSecond.invokeDirect(null, instant.getEpochSecond(), instant.getNano());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isInstant returns true, asInstant must succeed.");
            }
        }

        @Specialization(guards={"!interop.isInstant(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_Instant.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Duration type mapping")
    @GenerateUncached
    public static abstract class ToDuration
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_Duration)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_Duration.getTypeAsString());
        }

        @Specialization(guards={"interop.isDuration(value)"})
        StaticObject doForeignDuration(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Duration duration = interop.asDuration(value);
                StaticObject guestDuration = meta.getAllocator().createNew(meta.java_time_Duration);
                meta.java_time_Duration_seconds.setLong(guestDuration, duration.getSeconds());
                meta.java_time_Duration_nanos.setInt(guestDuration, duration.getNano());
                return guestDuration;
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isDuration returns true, asDuration must succeed.");
            }
        }

        @Specialization(guards={"!interop.isDuration(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_Duration.getTypeAsString());
        }
    }

    @NodeInfo(shortName="ZoneId type mapping")
    @GenerateUncached
    public static abstract class ToZoneId
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_ZoneId)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_ZoneId.getTypeAsString());
        }

        @Specialization(guards={"interop.isTimeZone(value)"})
        StaticObject doForeignZoneId(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                ZoneId zoneId = interop.asTimeZone(value);
                return (StaticObject)meta.java_time_ZoneId_of.invokeDirect(null, meta.toGuestString(zoneId.getId()));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isZoneId returns true, asTimeZone must succeed.");
            }
        }

        @Specialization(guards={"!interop.isTimeZone(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_ZoneId.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Date type mapping")
    @GenerateUncached
    public static abstract class ToDate
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_Date)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_util_Date.getTypeAsString());
        }

        @Specialization(guards={"interop.isInstant(value)"})
        StaticObject doForeignDate(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Instant instant = interop.asInstant(value);
                StaticObject guestInstant = (StaticObject)meta.java_time_Instant_ofEpochSecond.invokeDirect(null, instant.getEpochSecond(), instant.getNano());
                return (StaticObject)meta.java_util_Date_from.invokeDirect(null, guestInstant);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isInstant returns true, asInstant must succeed.");
            }
        }

        @Specialization(guards={"!interop.isInstant(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Date.getTypeAsString());
        }
    }

    @NodeInfo(shortName="BigInteger type mapping")
    @GenerateUncached
    public static abstract class ToBigInteger
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_math_BigInteger)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_math_BigInteger.getTypeAsString());
        }

        @CompilerDirectives.TruffleBoundary
        private StaticObject toGuestBigInteger(Meta meta, BigInteger bigInteger) {
            byte[] bytes = bigInteger.toByteArray();
            StaticObject guestBigInteger = this.getAllocator().createNew(meta.java_math_BigInteger);
            meta.java_math_BigInteger_init.invokeDirect(guestBigInteger, StaticObject.wrap(bytes, meta));
            return guestBigInteger;
        }

        @Specialization(guards={"interop.fitsInBigInteger(value)"})
        StaticObject doForeignBigInteger(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                BigInteger bigInteger = interop.asBigInteger(value);
                return this.toGuestBigInteger(meta, bigInteger);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInBigInteger returns true, asBigInteger must succeed.");
            }
        }

        @Specialization(guards={"!interop.fitsInBigInteger(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_math_BigInteger.getTypeAsString());
        }
    }

    @NodeInfo(shortName="custom type converter")
    public static abstract class ToMappedType
    extends ToReference {
        protected static final int LIMIT = 4;
        final ObjectKlass targetType;

        ToMappedType(ObjectKlass targetType) {
            this.targetType = targetType;
        }

        static InstanceOf createInstanceOf(Klass targetType) {
            return InstanceOf.create(targetType, false);
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType)") InstanceOf instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!interop.isNull(value)", "isHostObject(getContext(), value)"})
        StaticObject doForeignConverter(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached BranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                Object metaObject = ToMappedType.getMetaObjectOrThrow(value, interop);
                String metaName = ToMappedType.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    return (StaticObject)converter.convert(StaticObject.createForeign(this.getLanguage(), this.targetType, value, interop));
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                errorProfile.enter();
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", this.targetType.getNameAsString(), e.getMessage()));
            }
        }
    }

    @NodeInfo(shortName="custom type converter")
    public static abstract class ToMappedInternalType
    extends ToReference {
        protected static final int LIMIT = 4;
        final ObjectKlass targetType;

        ToMappedInternalType(ObjectKlass targetType) {
            this.targetType = targetType;
        }

        static InstanceOf createInstanceOf(Klass targetType) {
            return InstanceOf.create(targetType, false);
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType)") InstanceOf instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!interop.isNull(value)", "isHostObject(getContext(), value)"})
        StaticObject doForeignInternalConverter(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupInternalTypeConverterNode lookupTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached BranchProfile errorProfile, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            try {
                Object metaObject = ToMappedInternalType.getMetaObjectOrThrow(value, interop);
                String metaName = ToMappedInternalType.getMetaName(metaObject, interop);
                PolyglotTypeMappings.InternalTypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    return converter.convertInternal(interop, value, meta, converterToEspresso);
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                errorProfile.enter();
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", this.targetType.getNameAsString(), e.getMessage()));
            }
        }
    }

    @NodeInfo(shortName="Dynamic toEspresso node")
    @GenerateUncached
    @ReportPolymorphism
    public static abstract class DynamicToReference
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract StaticObject execute(Object var1, Klass var2) throws UnsupportedTypeException;

        protected static ToReference createToEspressoNode(Klass targetType) {
            return ToReference.createToReference(targetType, targetType.getMeta());
        }

        @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
        public StaticObject doCached(Object value, Klass targetType, @Cached(value="targetType") Klass cachedTargetType, @Cached(value="createToEspressoNode(cachedTargetType)") ToReference toEspressoNode) throws UnsupportedTypeException {
            return toEspressoNode.execute(value);
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        public StaticObject doGeneric(Object value, Klass targetType, @Cached GenericToReference genericToReference) throws UnsupportedTypeException {
            return genericToReference.execute(value, targetType);
        }
    }

    @NodeInfo(shortName="Generic toEspresso node")
    @GenerateUncached
    @ImportStatic(value={ToEspressoNode.class})
    public static abstract class GenericToReference
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract StaticObject execute(Object var1, Klass var2) throws UnsupportedTypeException;

        public static boolean isStaticObject(Object value) {
            return value instanceof StaticObject;
        }

        @Specialization
        public StaticObject doStaticObject(StaticObject value, Klass targetType, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), targetType)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", targetType.getTypeAsString()));
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, Klass targetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeMappingEnabled(targetType)", "!isStaticObject(value)"})
        public StaticObject doMappedInterface(Object value, Klass targetType, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = ToEspressoNode.getMetaObjectOrThrow(value, interop);
                WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToEspressoNode.getMetaName(metaObject, interop), targetType);
                if (proxyKlass != null) {
                    targetType.safeInitialize();
                    return proxyKlass.createProxyInstance(value, this.getLanguage(), interop);
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getTypeAsString()));
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doArray(Object value, ArrayKlass targetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            if (targetType == this.getMeta()._byte_array && interop.hasBufferElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta()._byte_array, value, interop);
            }
            if (interop.hasArrayElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(this), targetType, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public StaticObject doTypeConverter(Object value, Klass targetType, @Cached LookupTypeConverterNode lookupTypeConverterNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = ToEspressoNode.getMetaObjectOrThrow(value, interop);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    return (StaticObject)converter.convert(StaticObject.createForeign(this.getLanguage(), targetType, value, interop));
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getNameAsString(), e.getMessage()));
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "isInternalTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public StaticObject doInternalTypeConverter(Object value, Klass targetType, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = ToEspressoNode.getMetaObjectOrThrow(value, interop);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.InternalTypeConverter converter = lookupInternalTypeConverterNode.execute(metaName);
                if (converter != null) {
                    return converter.convertInternal(interop, value, this.getMeta(), converterToEspresso);
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getNameAsString(), e.getMessage()));
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)", "!targetType.isArray()", "!isTypeConverterEnabled(targetType)", "!isTypeMappingEnabled(targetType)"})
        public StaticObject doGeneric(Object value, Klass targetType, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached InlinedBranchProfile noConverterProfile, @Cached InlinedBranchProfile unknownProfile) throws UnsupportedTypeException {
            ToReference uncachedToReference = ToReference.getUncachedToReference(targetType, meta);
            if (uncachedToReference != null) {
                return uncachedToReference.execute(value);
            }
            unknownProfile.enter((Node)this);
            if (targetType instanceof ObjectKlass) {
                StaticObject result = ToReference.tryConverterForUnknownTarget(value, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, meta);
                if (result != null) {
                    return result;
                }
                try {
                    noConverterProfile.enter((Node)this);
                    ToEspressoNode.checkHasAllFieldsOrThrow(value, (ObjectKlass)targetType, interop, this.getMeta());
                    return StaticObject.createForeign(this.getLanguage(), targetType, value, interop);
                }
                catch (ClassCastException e) {
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
                }
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
        }
    }
}

