/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyOracle;
import com.oracle.truffle.espresso.analysis.hierarchy.DefaultClassHierarchyOracle;
import com.oracle.truffle.espresso.analysis.hierarchy.NoOpClassHierarchyOracle;
import com.oracle.truffle.espresso.jdwp.api.JDWPOptions;
import com.oracle.truffle.espresso.jdwp.api.VMEventListenerImpl;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.interop.EspressoForeignProxyGenerator;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.perf.TimerCollection;
import com.oracle.truffle.espresso.ref.FinalizationSupport;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoReferenceDrainer;
import com.oracle.truffle.espresso.runtime.JDWPContextImpl;
import com.oracle.truffle.espresso.threads.EspressoThreadRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.options.OptionMap;

public final class EspressoEnv {
    private final TruffleLanguage.Env env;
    private final String[] vmArguments;
    private final TimerCollection timers;
    private final ClassHierarchyOracle classHierarchyOracle;
    private final EspressoThreadRegistry threadRegistry;
    private final EspressoReferenceDrainer referenceDrainer;
    private final JDWPContextImpl jdwpContext;
    private final boolean shouldReportVMEvents;
    private final VMEventListenerImpl eventListener;
    public final boolean bytecodeLevelInlining;
    public final boolean InlineMethodHandle;
    public final boolean SplitMethodHandles;
    public final boolean EnableManagement;
    public final boolean SoftExit;
    public final boolean AllowHostExit;
    public final boolean Polyglot;
    public final boolean BuiltInPolyglotCollections;
    public final boolean HotSwapAPI;
    public final boolean UseBindingsLoader;
    public final boolean EnableSignals;
    private final String multiThreadingDisabled;
    public final boolean NativeAccessAllowed;
    public final boolean EnableAgents;
    public final int TrivialMethodSize;
    public final boolean UseHostFinalReference;
    public final EspressoOptions.JImageMode JImageMode;
    private final PolyglotTypeMappings polyglotTypeMappings;
    private final HashMap<String, EspressoForeignProxyGenerator.GeneratedProxyBytes> proxyCache;
    public final JDWPOptions JDWPOptions;

    public EspressoEnv(EspressoContext context, TruffleLanguage.Env env) {
        Set<String> singleThreadedLanguages;
        this.env = env;
        this.threadRegistry = new EspressoThreadRegistry(context);
        this.referenceDrainer = new EspressoReferenceDrainer(context);
        this.SoftExit = (Boolean)env.getOptions().get(EspressoOptions.SoftExit);
        this.AllowHostExit = (Boolean)env.getOptions().get(EspressoOptions.ExitHost);
        context.getLanguage().initializeGuestAllocator(env);
        this.timers = TimerCollection.create((Boolean)env.getOptions().get(EspressoOptions.EnableTimers));
        this.JDWPOptions = (JDWPOptions)env.getOptions().get(EspressoOptions.JDWPOptions);
        this.shouldReportVMEvents = this.JDWPOptions != null;
        this.eventListener = new VMEventListenerImpl();
        this.bytecodeLevelInlining = this.JDWPOptions == null && (Boolean)env.getOptions().get(EspressoOptions.BytecodeLevelInlining) != false;
        this.InlineMethodHandle = this.JDWPOptions == null && (Boolean)env.getOptions().get(EspressoOptions.InlineMethodHandle) != false;
        this.SplitMethodHandles = this.JDWPOptions == null && (Boolean)env.getOptions().get(EspressoOptions.SplitMethodHandles) != false;
        this.EnableSignals = (Boolean)env.getOptions().get(EspressoOptions.EnableSignals);
        this.EnableManagement = (Boolean)env.getOptions().get(EspressoOptions.EnableManagement);
        this.EnableAgents = (Boolean)env.getOptions().get(EspressoOptions.EnableAgents);
        this.TrivialMethodSize = (Integer)env.getOptions().get(EspressoOptions.TrivialMethodSize);
        boolean useHostFinalReferenceOption = (Boolean)env.getOptions().get(EspressoOptions.UseHostFinalReference);
        boolean bl = this.UseHostFinalReference = useHostFinalReferenceOption && FinalizationSupport.canUseHostFinalReference();
        if (useHostFinalReferenceOption && !FinalizationSupport.canUseHostFinalReference() && env.getOptions().hasBeenSet(EspressoOptions.UseHostFinalReference)) {
            context.getLogger().warning("--java.UseHostFinalReference is set to 'true' but Espresso cannot access the host java.lang.ref.FinalReference class.\nEnsure that host system properties '-Despresso.finalization.InjectClasses=true' and '-Despresso.finalization.UnsafeOverride=true' are set.\nEspresso's guest FinalReference(s) will fallback to WeakReference semantics.");
        }
        Object multiThreadingDisabledReason = null;
        if (!((Boolean)env.getOptions().get(EspressoOptions.MultiThreaded)).booleanValue()) {
            multiThreadingDisabledReason = "java.MultiThreaded option is set to false";
        }
        if (!env.isCreateThreadAllowed()) {
            multiThreadingDisabledReason = "polyglot context does not allow thread creation (`allowCreateThread(false)`)";
        }
        if (multiThreadingDisabledReason == null && !env.getOptions().hasBeenSet(EspressoOptions.MultiThreaded) && !(singleThreadedLanguages = EspressoEnv.knownSingleThreadedLanguages(env)).isEmpty()) {
            multiThreadingDisabledReason = "context seems to contain single-threaded languages: " + String.valueOf(singleThreadedLanguages);
            context.getLogger().warning(() -> "Disabling multi-threading since the context seems to contain single-threaded languages: " + String.valueOf(singleThreadedLanguages));
        }
        this.multiThreadingDisabled = multiThreadingDisabledReason;
        this.NativeAccessAllowed = env.isNativeAccessAllowed();
        this.Polyglot = (Boolean)env.getOptions().get(EspressoOptions.Polyglot);
        this.HotSwapAPI = (Boolean)env.getOptions().get(EspressoOptions.HotSwapAPI);
        this.BuiltInPolyglotCollections = (Boolean)env.getOptions().get(EspressoOptions.BuiltInPolyglotCollections);
        this.polyglotTypeMappings = new PolyglotTypeMappings((List)env.getOptions().get(EspressoOptions.PolyglotInterfaceMappings), (OptionMap<String>)((OptionMap)env.getOptions().get(EspressoOptions.PolyglotTypeConverters)), this.BuiltInPolyglotCollections);
        this.proxyCache = this.polyglotTypeMappings.hasMappings() ? new HashMap() : null;
        this.UseBindingsLoader = (Boolean)env.getOptions().get(EspressoOptions.UseBindingsLoader);
        EspressoOptions.JImageMode requestedJImageMode = (EspressoOptions.JImageMode)((Object)env.getOptions().get(EspressoOptions.JImage));
        if (!this.NativeAccessAllowed && requestedJImageMode == EspressoOptions.JImageMode.NATIVE) {
            throw new IllegalArgumentException("JImage=native can only be set if native access is allowed");
        }
        this.JImageMode = requestedJImageMode;
        this.vmArguments = this.buildVmArguments(context.getLogger());
        this.jdwpContext = new JDWPContextImpl(context);
        this.classHierarchyOracle = (Boolean)env.getOptions().get(EspressoOptions.CHA) != false ? new DefaultClassHierarchyOracle() : new NoOpClassHierarchyOracle();
    }

    public TruffleLanguage.Env env() {
        return this.env;
    }

    public boolean multiThreadingEnabled() {
        return this.multiThreadingDisabled == null;
    }

    public String getMultiThreadingDisabledReason() {
        return this.multiThreadingDisabled;
    }

    public String[] getVmArguments() {
        return this.vmArguments;
    }

    public JDWPContextImpl getJdwpContext() {
        return this.jdwpContext;
    }

    public EspressoReferenceDrainer getReferenceDrainer() {
        return this.referenceDrainer;
    }

    public VMEventListenerImpl getEventListener() {
        return this.eventListener;
    }

    public TimerCollection getTimers() {
        return this.timers;
    }

    public EspressoThreadRegistry getThreadRegistry() {
        return this.threadRegistry;
    }

    public ClassHierarchyOracle getClassHierarchyOracle() {
        return this.classHierarchyOracle;
    }

    public PolyglotTypeMappings getPolyglotTypeMappings() {
        return this.polyglotTypeMappings;
    }

    public HashMap<String, EspressoForeignProxyGenerator.GeneratedProxyBytes> getProxyCache() {
        return this.proxyCache;
    }

    public boolean shouldReportVMEvents() {
        return this.shouldReportVMEvents;
    }

    private String[] buildVmArguments(TruffleLogger logger) {
        OptionMap argsMap = (OptionMap)this.env().getOptions().get(EspressoOptions.VMArguments);
        if (argsMap == null) {
            return new String[0];
        }
        Set set = argsMap.entrySet();
        int length = set.size();
        String[] array = new String[length];
        for (Map.Entry entry : set) {
            try {
                String key = (String)entry.getKey();
                int idx = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                if (idx < 0 || idx >= length) {
                    logger.severe("Unsupported use of the 'java.VMArguments' option: Declared index: " + idx + ", actual number of arguments: " + length + ".\nPlease only declare positive index starting from 0, and growing by 1 each.");
                    throw EspressoError.shouldNotReachHere();
                }
                array[idx] = (String)entry.getValue();
            }
            catch (NumberFormatException e) {
                logger.warning("Unsupported use of the 'java.VMArguments' option: java.VMArguments." + (String)entry.getKey() + "=" + (String)entry.getValue() + "\nShould be of the form: java.VMArguments.<int>=<value>");
                throw EspressoError.shouldNotReachHere();
            }
        }
        return array;
    }

    private static Set<String> knownSingleThreadedLanguages(TruffleLanguage.Env env) {
        HashSet<String> singleThreaded = new HashSet<String>();
        for (LanguageInfo languageInfo : env.getPublicLanguages().values()) {
            switch (languageInfo.getId()) {
                case "wasm": 
                case "js": 
                case "R": 
                case "python": {
                    singleThreaded.add(languageInfo.getId());
                }
            }
        }
        return singleThreaded;
    }
}

