/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.CandidateMethodWithArgs;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.LookupDeclaredMethod;
import com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode;
import com.oracle.truffle.espresso.nodes.interop.MethodArgsUtils;
import com.oracle.truffle.espresso.nodes.interop.OverLoadedMethodSelectorNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.InteropUtils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class InteropLookupAndInvoke
extends EspressoNode {
    public abstract Object execute(StaticObject var1, Klass var2, Object[] var3, String var4) throws ArityException, UnsupportedTypeException;

    Object selectAndInvoke(SelectAndInvokeNode selectAndInvoke, InlinedBranchProfile exception, StaticObject receiver, Object[] args, Method[] candidates) throws UnsupportedTypeException, ArityException {
        try {
            return selectAndInvoke.execute(receiver, args, candidates);
        }
        catch (EspressoException e) {
            exception.enter((Node)this);
            throw InteropUtils.unwrapExceptionBoundary(this.getLanguage(), e, this.getMeta());
        }
    }

    @GenerateUncached
    static abstract class SelectAndInvokeNode
    extends EspressoNode {
        SelectAndInvokeNode() {
        }

        public abstract Object execute(StaticObject var1, Object[] var2, Method[] var3) throws ArityException, UnsupportedTypeException;

        @Specialization(guards={"isSingleNonVarargs(candidates)"})
        Object doSingleNonVarargs(StaticObject receiver, Object[] args, Method[] candidates, @Cached @Cached.Exclusive InvokeEspressoNode invoke) throws ArityException, UnsupportedTypeException {
            assert (candidates.length == 1);
            Method m = candidates[0];
            assert (m.getParameterCount() == args.length);
            assert (m.isPublic());
            return invoke.execute(m, receiver, args);
        }

        @Specialization(guards={"isSingleVarargs(candidates)"})
        Object doSingleVarargs(StaticObject receiver, Object[] args, Method[] candidates, @Cached @Cached.Exclusive InvokeEspressoNode invoke, @Cached ToEspressoNode.DynamicToEspresso toEspresso, @Cached InlinedBranchProfile error) throws ArityException, UnsupportedTypeException {
            assert (candidates.length == 1);
            Method m = candidates[0];
            assert (m.isPublic());
            CandidateMethodWithArgs matched = MethodArgsUtils.matchCandidate(m, args, m.resolveParameterKlasses(), toEspresso);
            if (matched != null) {
                matched = MethodArgsUtils.ensureVarArgsArrayCreated(matched);
                assert (matched != null);
                return invoke.execute(matched.getMethod(), receiver, matched.getConvertedArgs(), true);
            }
            error.enter((Node)this);
            throw UnsupportedTypeException.create((Object[])args);
        }

        @Specialization(guards={"isMulti(candidates)"})
        Object doMulti(StaticObject receiver, Object[] args, Method[] candidates, @Cached OverLoadedMethodSelectorNode selector, @Cached @Cached.Exclusive InvokeEspressoNode invoke, @Cached InlinedBranchProfile error) throws ArityException, UnsupportedTypeException {
            CandidateMethodWithArgs typeMatched = selector.execute(candidates, args);
            if (typeMatched != null) {
                return invoke.execute(typeMatched.getMethod(), receiver, typeMatched.getConvertedArgs(), true);
            }
            error.enter((Node)this);
            throw UnsupportedTypeException.create((Object[])args);
        }

        static boolean isSingleNonVarargs(Method[] candidates) {
            return candidates.length == 1 && !candidates[0].isVarargs();
        }

        static boolean isSingleVarargs(Method[] candidates) {
            return candidates.length == 1 && candidates[0].isVarargs();
        }

        static boolean isMulti(Method[] candidates) {
            return candidates.length > 1;
        }
    }

    @GenerateUncached
    public static abstract class NonVirtual
    extends InteropLookupAndInvoke {
        @Specialization
        public Object doNonVirtual(StaticObject receiver, Klass klass, Object[] arguments, String member, @Cached LookupDeclaredMethod lookup, @Cached SelectAndInvokeNode selectAndInvoke, @Cached InlinedBranchProfile error, @Cached InlinedBranchProfile exception) throws ArityException, UnsupportedTypeException {
            boolean isStatic = receiver == null;
            Method[] candidates = lookup.execute(klass, member, true, isStatic, arguments.length);
            if (candidates != null) {
                return this.selectAndInvoke(selectAndInvoke, exception, receiver, arguments, candidates);
            }
            error.enter((Node)this);
            throw ArityException.create((int)(arguments.length + 1), (int)-1, (int)arguments.length);
        }
    }

    @GenerateUncached
    public static abstract class Virtual
    extends InteropLookupAndInvoke {
        @Specialization
        public Object doVirtual(StaticObject receiver, Klass klass, Object[] arguments, String member, @Cached LookupVirtualMethodNode lookup, @Cached SelectAndInvokeNode selectAndInvoke, @Cached InlinedBranchProfile error, @Cached InlinedBranchProfile exception) throws ArityException, UnsupportedTypeException {
            assert (receiver != null);
            Method[] candidates = lookup.execute(klass, member, arguments.length);
            if (candidates != null) {
                return this.selectAndInvoke(selectAndInvoke, exception, receiver, arguments, candidates);
            }
            error.enter((Node)this);
            throw ArityException.create((int)(arguments.length + 1), (int)-1, (int)arguments.length);
        }
    }
}

