/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.dispatch.messages.ArrayIterator;
import com.oracle.truffle.espresso.runtime.dispatch.messages.HashIterator;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
public class SharedInterop {
    static CallTarget getTarget(EspressoContext ctx, int dispatchId, InteropMessage.Message message) {
        return ctx.getLazyCaches().getInteropMessage(message, dispatchId);
    }

    static CallTarget getTarget(StaticObject receiver, InteropMessage.Message message) {
        assert (!StaticObject.isNull(receiver));
        int dispatch = receiver.getKlass().getDispatchId();
        EspressoContext ctx = SharedInterop.getContext(receiver);
        return ctx.getLazyCaches().getInteropMessage(message, dispatch);
    }

    private static UnsupportedMessageException unsupported() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    public static EspressoContext getContext(StaticObject receiver) {
        receiver.checkNotForeign();
        assert (!StaticObject.isNull(receiver));
        return receiver.getKlass().getContext();
    }

    @ExportMessage
    public static boolean isNull(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsNull)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsNull);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean isBoolean(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsBoolean)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsBoolean);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean asBoolean(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsBoolean)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsBoolean);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean isExecutable(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsExecutable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsExecutable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object execute(StaticObject receiver, Object[] arguments, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.Execute)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, arguments);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.Execute);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, arguments});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasExecutableName(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasExecutableName)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasExecutableName);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getExecutableName(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetExecutableName)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetExecutableName);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasDeclaringMetaObject(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasDeclaringMetaObject)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasDeclaringMetaObject);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getDeclaringMetaObject(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetDeclaringMetaObject)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetDeclaringMetaObject);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isInstantiable(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsInstantiable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsInstantiable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object instantiate(StaticObject receiver, Object[] args, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.Instantiate)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, args);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.Instantiate);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, args});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isString(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsString)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsString);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static String asString(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsString)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (String)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsString);
        if (target != null) {
            return (String)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static TruffleString asTruffleString(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsTruffleString)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (TruffleString)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsTruffleString);
        if (target != null) {
            return (TruffleString)callNode.call(target, new Object[]{receiver});
        }
        return TruffleString.fromJavaStringUncached((String)lib.asString((Object)receiver), (TruffleString.Encoding)TruffleString.Encoding.UTF_16);
    }

    @ExportMessage
    public static boolean isNumber(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsNumber)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsNumber);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInByte(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInByte)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInByte);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInShort(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInShort)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInShort);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInInt(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInInt)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInInt);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInLong(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInLong)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInLong);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInFloat(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInFloat)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInFloat);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInDouble(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInDouble)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInDouble);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean fitsInBigInteger(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.FitsInBigInteger)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.FitsInBigInteger);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static byte asByte(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsByte)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Byte)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsByte);
        if (target != null) {
            return (Byte)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static short asShort(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsShort)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Short)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsShort);
        if (target != null) {
            return (Short)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static int asInt(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsInt)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Integer)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsInt);
        if (target != null) {
            return (Integer)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static long asLong(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsLong)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Long)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsLong);
        if (target != null) {
            return (Long)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static float asFloat(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsFloat)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return ((Float)sharedCallNode.call(dispatchId, message, receiver)).floatValue();
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsFloat);
        if (target != null) {
            return ((Float)callNode.call(target, new Object[]{receiver})).floatValue();
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static double asDouble(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsDouble)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Double)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsDouble);
        if (target != null) {
            return (Double)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static BigInteger asBigInteger(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsDouble)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (BigInteger)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsDouble);
        if (target != null) {
            return (BigInteger)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasMembers(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasMembers)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasMembers);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getMembers(StaticObject receiver, boolean includeInternal, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetMembers)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, includeInternal);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetMembers);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, includeInternal});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isMemberReadable(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMemberReadable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMemberReadable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static Object readMember(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadMember)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadMember);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, member});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isMemberModifiable(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMemberModifiable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMemberModifiable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static boolean isMemberInsertable(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMemberInsertable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMemberInsertable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static void writeMember(StaticObject receiver, String member, Object value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteMember)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, member, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteMember);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, member, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isMemberRemovable(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMemberRemovable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMemberRemovable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static void removeMember(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.RemoveMember)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, member);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.RemoveMember);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, member});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isMemberInvocable(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMemberInvocable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMemberInvocable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static Object invokeMember(StaticObject receiver, String member, Object[] arguments, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.InvokeMember)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, member, arguments);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.InvokeMember);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, member, arguments});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isMemberInternal(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMemberInternal)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMemberInternal);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasMemberReadSideEffects(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasMemberReadSideEffects)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasMemberReadSideEffects);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasMemberWriteSideEffects(StaticObject receiver, String member, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasMemberWriteSideEffects)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, member);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasMemberWriteSideEffects);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, member});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasHashEntries(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasHashEntries)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasHashEntries);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static long getHashSize(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetHashSize)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Long)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetHashSize);
        if (target != null) {
            return (Long)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isHashEntryReadable(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsHashEntryReadable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsHashEntryReadable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, key});
        }
        return false;
    }

    @ExportMessage
    public static Object readHashValue(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadHashValue)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadHashValue);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, key});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static Object readHashValueOrDefault(StaticObject receiver, Object key, Object defaultValue, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadHashValueOrDefault)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadHashValueOrDefault);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, key});
        }
        try {
            return lib.readHashValue((Object)receiver, key);
        }
        catch (UnknownKeyException e) {
            return defaultValue;
        }
    }

    @ExportMessage
    public static boolean isHashEntryModifiable(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsHashEntryModifiable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsHashEntryModifiable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, key});
        }
        return false;
    }

    @ExportMessage
    public static boolean isHashEntryInsertable(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsHashEntryInsertable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsHashEntryInsertable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, key});
        }
        return false;
    }

    @ExportMessage
    public static boolean isHashEntryWritable(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsHashEntryWritable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsHashEntryWritable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return lib.isHashEntryModifiable((Object)receiver, key) || lib.isHashEntryModifiable((Object)receiver, key);
    }

    @ExportMessage
    public static void writeHashEntry(StaticObject receiver, Object key, Object value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteHashEntry)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, key, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteHashEntry);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, key, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isHashEntryRemovable(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsHashEntryRemovable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsHashEntryRemovable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, key});
        }
        return false;
    }

    @ExportMessage
    public static void removeHashEntry(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.RemoveHashEntry)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, key);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.RemoveHashEntry);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, key});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isHashEntryExisting(StaticObject receiver, Object key, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsHashEntryExisting)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, key);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsHashEntryExisting);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, key});
        }
        return lib.isHashEntryReadable((Object)receiver, key) || lib.isHashEntryModifiable((Object)receiver, key);
    }

    @ExportMessage
    public static Object getHashEntriesIterator(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetHashEntriesIterator)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetHashEntriesIterator);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static Object getHashKeysIterator(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetHashKeysIterator)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetHashKeysIterator);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        Object entriesIterator = lib.getHashEntriesIterator((Object)receiver);
        return HashIterator.keys(entriesIterator);
    }

    @ExportMessage
    public static Object getHashValuesIterator(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetHashValuesIterator)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetHashValuesIterator);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        Object entriesIterator = lib.getHashEntriesIterator((Object)receiver);
        return HashIterator.values(entriesIterator);
    }

    @ExportMessage
    public static boolean hasArrayElements(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasArrayElements)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasArrayElements);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object readArrayElement(StaticObject receiver, long index, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadArrayElement)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, index);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadArrayElement);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, index});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static long getArraySize(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetArraySize)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Long)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetArraySize);
        if (target != null) {
            return (Long)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isArrayElementReadable(StaticObject receiver, long index, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsArrayElementReadable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, index);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsArrayElementReadable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, index});
        }
        return false;
    }

    @ExportMessage
    public static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteArrayElement)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, index, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteArrayElement);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, index, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void removeArrayElement(StaticObject receiver, long index, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.RemoveArrayElement)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, index);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.RemoveArrayElement);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, index});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isArrayElementModifiable(StaticObject receiver, long index, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsArrayElementModifiable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, index);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsArrayElementModifiable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, index});
        }
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementInsertable(StaticObject receiver, long index, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsArrayElementInsertable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, index);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsArrayElementInsertable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, index});
        }
        return false;
    }

    @ExportMessage
    public static boolean isArrayElementRemovable(StaticObject receiver, long index, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsArrayElementRemovable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, index);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsArrayElementRemovable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, index});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasBufferElements(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasBufferElements)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasBufferElements);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean isBufferWritable(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsBufferWritable)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsBufferWritable);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        if (lib.hasBufferElements((Object)receiver)) {
            return false;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static long getBufferSize(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetBufferSize)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Long)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetBufferSize);
        if (target != null) {
            return (Long)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static byte readBufferByte(StaticObject receiver, long byteOffset, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBufferByte)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Byte)sharedCallNode.call(dispatchId, message, receiver, byteOffset);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBufferByte);
        if (target != null) {
            return (Byte)callNode.call(target, new Object[]{receiver, byteOffset});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void readBuffer(StaticObject receiver, long byteOffset, byte[] destination, int destinationOffset, int length, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        CallTarget target;
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBuffer)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, byteOffset, destination, destinationOffset, length);
        }
        if ((target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBuffer)) != null) {
            callNode.call(target, new Object[]{receiver, byteOffset, destination, destinationOffset, length});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void writeBufferByte(StaticObject receiver, long byteOffset, byte value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteBufferByte)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, byteOffset, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteBufferByte);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, byteOffset, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static short readBufferShort(StaticObject receiver, ByteOrder order, long byteOffset, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBufferShort)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Short)sharedCallNode.call(dispatchId, message, receiver, order, byteOffset);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBufferShort);
        if (target != null) {
            return (Short)callNode.call(target, new Object[]{receiver, order, byteOffset});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void writeBufferShort(StaticObject receiver, ByteOrder order, long byteOffset, short value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteBufferShort)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, order, byteOffset, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteBufferShort);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, order, byteOffset, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static int readBufferInt(StaticObject receiver, ByteOrder order, long byteOffset, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBufferInt)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Integer)sharedCallNode.call(dispatchId, message, receiver, order, byteOffset);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBufferInt);
        if (target != null) {
            return (Integer)callNode.call(target, new Object[]{receiver, order, byteOffset});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void writeBufferInt(StaticObject receiver, ByteOrder order, long byteOffset, int value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteBufferInt)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, order, byteOffset, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteBufferInt);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, order, byteOffset, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static long readBufferLong(StaticObject receiver, ByteOrder order, long byteOffset, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBufferLong)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Long)sharedCallNode.call(dispatchId, message, receiver, order, byteOffset);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBufferLong);
        if (target != null) {
            return (Long)callNode.call(target, new Object[]{receiver, order, byteOffset});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void writeBufferLong(StaticObject receiver, ByteOrder order, long byteOffset, long value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteBufferLong)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, order, byteOffset, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteBufferLong);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, order, byteOffset, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static float readBufferFloat(StaticObject receiver, ByteOrder order, long byteOffset, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBufferFloat)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return ((Float)sharedCallNode.call(dispatchId, message, receiver, order, byteOffset)).floatValue();
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBufferFloat);
        if (target != null) {
            return ((Float)callNode.call(target, new Object[]{receiver, order, byteOffset})).floatValue();
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void writeBufferFloat(StaticObject receiver, ByteOrder order, long byteOffset, float value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteBufferFloat)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, order, byteOffset, Float.valueOf(value));
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteBufferFloat);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, order, byteOffset, Float.valueOf(value)});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static double readBufferDouble(StaticObject receiver, ByteOrder order, long byteOffset, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ReadBufferDouble)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Double)sharedCallNode.call(dispatchId, message, receiver, order, byteOffset);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ReadBufferDouble);
        if (target != null) {
            return (Double)callNode.call(target, new Object[]{receiver, order, byteOffset});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void writeBufferDouble(StaticObject receiver, ByteOrder order, long byteOffset, double value, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.WriteBufferDouble)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver, order, byteOffset, value);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.WriteBufferDouble);
        if (target != null) {
            callNode.call(target, new Object[]{receiver, order, byteOffset, value});
            return;
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isPointer(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsPointer)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsPointer);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static long asPointer(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsPointer)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Long)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsPointer);
        if (target != null) {
            return (Long)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static void toNative(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ToNative)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            sharedCallNode.call(dispatchId, message, receiver);
            return;
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ToNative);
        if (target != null) {
            callNode.call(target, new Object[]{receiver});
        }
    }

    @ExportMessage
    public static Instant asInstant(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsInstant)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Instant)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsInstant);
        if (target != null) {
            return (Instant)callNode.call(target, new Object[]{receiver});
        }
        if (lib.isDate((Object)receiver) && lib.isTime((Object)receiver) && lib.isTimeZone((Object)receiver)) {
            LocalDate date = lib.asDate((Object)receiver);
            LocalTime time = lib.asTime((Object)receiver);
            ZoneId zone = lib.asTimeZone((Object)receiver);
            return SharedInterop.toInstant(date, time, zone);
        }
        throw SharedInterop.unsupported();
    }

    @CompilerDirectives.TruffleBoundary
    private static Instant toInstant(LocalDate date, LocalTime time, ZoneId zone) {
        return ZonedDateTime.of(date, time, zone).toInstant();
    }

    @ExportMessage
    public static boolean isTimeZone(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsTimeZone)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsTimeZone);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static ZoneId asTimeZone(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsTimeZone)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (ZoneId)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsTimeZone);
        if (target != null) {
            return (ZoneId)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isDate(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsDate)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsDate);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static LocalDate asDate(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsDate)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (LocalDate)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsDate);
        if (target != null) {
            return (LocalDate)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isTime(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsTime)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsTime);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static LocalTime asTime(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsTime)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (LocalTime)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsTime);
        if (target != null) {
            return (LocalTime)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isDuration(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsDuration)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsDuration);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Duration asDuration(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.AsDuration)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Duration)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.AsDuration);
        if (target != null) {
            return (Duration)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isException(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsException)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsException);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static RuntimeException throwException(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ThrowException)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (RuntimeException)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ThrowException);
        if (target != null) {
            throw (RuntimeException)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static ExceptionType getExceptionType(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetExceptionType)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (ExceptionType)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetExceptionType);
        if (target != null) {
            return (ExceptionType)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isExceptionIncompleteSource(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsExceptionIncompleteSource)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsExceptionIncompleteSource);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static int getExceptionExitStatus(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetExceptionExitStatus)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Integer)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetExceptionExitStatus);
        if (target != null) {
            return (Integer)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasExceptionCause(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasExceptionCause)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasExceptionCause);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getExceptionCause(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetExceptionCause)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetExceptionCause);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasExceptionMessage(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasExceptionMessage)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasExceptionMessage);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getExceptionMessage(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetExceptionMessage)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetExceptionMessage);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage.Ignore
    public static boolean hasExceptionStackTrace(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasExceptionStackTrace)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasExceptionStackTrace);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage.Ignore
    public static Object getExceptionStackTrace(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetExceptionStackTrace)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetExceptionStackTrace);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasIterator(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasIterator)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasIterator);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return lib.hasArrayElements((Object)receiver);
    }

    @ExportMessage
    public static Object getIterator(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode, @CachedLibrary(value="receiver") InteropLibrary lib) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetIterator)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetIterator);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        if (!lib.hasIterator((Object)receiver)) {
            throw SharedInterop.unsupported();
        }
        return new ArrayIterator(receiver);
    }

    @ExportMessage
    public static boolean isIterator(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsIterator)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsIterator);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasIteratorNextElement(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasIteratorNextElement)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasIteratorNextElement);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getIteratorNextElement(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetIteratorNextElement)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetIteratorNextElement);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage.Ignore
    public static boolean hasSourceLocation(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasSourceLocation)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasSourceLocation);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage.Ignore
    public static SourceSection getSourceLocation(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetSourceLocation)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (SourceSection)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetSourceLocation);
        if (target != null) {
            return (SourceSection)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasLanguage(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasLanguage)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasLanguage);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Class<? extends TruffleLanguage<?>> getLanguage(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetLanguage)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Class)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetLanguage);
        if (target != null) {
            return (Class)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean hasMetaObject(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasMetaObject)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasMetaObject);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getMetaObject(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetMetaObject)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetMetaObject);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static Object toDisplayString(StaticObject receiver, boolean allowSideEffects, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.ToDisplayString)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver, allowSideEffects);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.ToDisplayString);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver, allowSideEffects});
        }
        return SharedInterop.toDisplayStringBoundary(receiver, allowSideEffects);
    }

    @ExportMessage
    public static boolean isMetaObject(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMetaObject)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMetaObject);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getMetaQualifiedName(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetMetaQualifiedName)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetMetaQualifiedName);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static Object getMetaSimpleName(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetMetaSimpleName)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetMetaSimpleName);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isMetaInstance(StaticObject receiver, Object instance, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsMetaInstance)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, instance);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsMetaInstance);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, instance});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasMetaParents(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasMetaParents)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasMetaParents);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getMetaParents(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetMetaParents)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetMetaParents);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static TriState isIdenticalOrUndefined(StaticObject receiver, Object other, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsIdenticalOrUndefined)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (TriState)sharedCallNode.call(dispatchId, message, receiver, other);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsIdenticalOrUndefined);
        if (target != null) {
            return (TriState)callNode.call(target, new Object[]{receiver, other});
        }
        return TriState.UNDEFINED;
    }

    @ExportMessage.Ignore
    public static boolean isIdentical(StaticObject receiver, Object other, InteropLibrary otherLib, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsIdentical)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver, other, otherLib);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsIdentical);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver, other, otherLib});
        }
        return false;
    }

    @ExportMessage
    public static int identityHashCode(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IdentityHashCode)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Integer)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IdentityHashCode);
        if (target != null) {
            return (Integer)callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @ExportMessage
    public static boolean isScope(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.IsScope)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.IsScope);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static boolean hasScopeParent(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.HasScopeParent)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return (Boolean)sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.HasScopeParent);
        if (target != null) {
            return (Boolean)callNode.call(target, new Object[]{receiver});
        }
        return false;
    }

    @ExportMessage
    public static Object getScopeParent(StaticObject receiver, @Cached IndirectCallNode callNode, @Cached CallSharedInteropMessage sharedCallNode) throws UnsupportedMessageException {
        InteropMessage.Message message;
        int dispatchId = receiver.getKlass().getDispatchId();
        if (InteropMessageFactories.isShareable(dispatchId, message = InteropMessage.Message.GetScopeParent)) {
            dispatchId = InteropMessageFactories.sourceDispatch(dispatchId, message);
            return sharedCallNode.call(dispatchId, message, receiver);
        }
        CallTarget target = SharedInterop.getTarget(receiver, InteropMessage.Message.GetScopeParent);
        if (target != null) {
            return callNode.call(target, new Object[]{receiver});
        }
        throw SharedInterop.unsupported();
    }

    @CompilerDirectives.TruffleBoundary
    private static Object toDisplayStringBoundary(Object receiver, boolean allowSideEffects) {
        if (allowSideEffects) {
            return Objects.toString(receiver);
        }
        return receiver.getClass().getTypeName() + "@" + Integer.toHexString(System.identityHashCode(receiver));
    }

    @GenerateUncached
    static abstract class CallSharedInteropMessage
    extends EspressoNode {
        static final int LIMIT = 10;

        CallSharedInteropMessage() {
        }

        public final Object call(int sourceDispatchId, InteropMessage.Message message, Object ... args) {
            return this.execute(sourceDispatchId, message, args);
        }

        protected abstract Object execute(int var1, InteropMessage.Message var2, Object[] var3);

        @Specialization(guards={"sourceDispatchId == cachedId"}, limit="LIMIT")
        Object doCached(int sourceDispatchId, InteropMessage.Message message, Object[] args, @Cached(value="sourceDispatchId") int cachedId, @Cached(value="create(getTarget(getContext(), sourceDispatchId, message))", allowUncached=true) DirectCallNode call) {
            return call.call(args);
        }

        static CallTarget getTarget(EspressoContext ctx, int dispatchId, InteropMessage.Message message) {
            return SharedInterop.getTarget(ctx, dispatchId, message);
        }
    }
}

