/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.threads;

import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.threads.ThreadsAccess;

public final class SuspendLock {
    private final Object handshakeLock = new Object(){};
    private final ThreadsAccess access;
    private final StaticObject thread;
    private volatile boolean shouldSuspend;
    private volatile boolean threadSuspended;

    public SuspendLock(ThreadsAccess access, StaticObject thread) {
        this.access = access;
        this.thread = thread;
    }

    public void suspend() {
        if (this.access.getHost(this.thread) == Thread.currentThread()) {
            this.shouldSuspend = true;
            this.selfSuspend();
        } else {
            this.suspendHandshake();
        }
    }

    public synchronized void selfSuspend() {
        while (this.shouldSuspend()) {
            this.notifySuspended();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadSuspended = false;
    }

    public synchronized void resume() {
        if (this.shouldSuspend()) {
            this.shouldSuspend = false;
            this.notifyAll();
        }
    }

    private boolean shouldSuspend() {
        return this.shouldSuspend;
    }

    private boolean isSuspended() {
        return this.threadSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendHandshake() {
        boolean wasInterrupted = false;
        this.shouldSuspend = true;
        this.access.getContext().getEnv().submitThreadLocal(new Thread[]{this.access.getHost(this.thread)}, (ThreadLocalAction)new SuspendAction(this));
        while (!this.isSuspended()) {
            this.shouldSuspend = true;
            try {
                Object object = this.handshakeLock;
                synchronized (object) {
                    if (this.access.isAlive(this.thread)) {
                        break;
                    }
                    this.handshakeLock.wait(100L);
                }
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuspended() {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.threadSuspended = true;
            this.handshakeLock.notifyAll();
        }
    }

    private static class SuspendAction
    extends ThreadLocalAction {
        private final SuspendLock lock;

        SuspendAction(SuspendLock lock) {
            super(true, false);
            this.lock = lock;
        }

        protected void perform(ThreadLocalAction.Access access) {
            this.lock.access.handleSuspend(this.lock.thread);
        }
    }
}

