/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.ClassfileStream;
import com.oracle.truffle.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.truffle.espresso.verifier.AppendFrame;
import com.oracle.truffle.espresso.verifier.ChopFrame;
import com.oracle.truffle.espresso.verifier.FullFrame;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.PrimitiveTypeInfo;
import com.oracle.truffle.espresso.verifier.ReferenceVariable;
import com.oracle.truffle.espresso.verifier.SameFrame;
import com.oracle.truffle.espresso.verifier.SameFrameExtended;
import com.oracle.truffle.espresso.verifier.SameLocals1StackItemFrame;
import com.oracle.truffle.espresso.verifier.SameLocals1StackItemFrameExtended;
import com.oracle.truffle.espresso.verifier.StackFrame;
import com.oracle.truffle.espresso.verifier.StackMapFrame;
import com.oracle.truffle.espresso.verifier.UninitializedThis;
import com.oracle.truffle.espresso.verifier.UninitializedVariable;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;

final class StackMapFrameParser {
    private final MethodVerifier verifier;
    private final ClassfileStream stream;

    private StackMapFrameParser(MethodVerifier verifier, StackMapTableAttribute stackMapTable) {
        this.verifier = verifier;
        this.stream = new ClassfileStream(stackMapTable.getData(), null);
    }

    public static void parse(MethodVerifier verifier, StackMapTableAttribute stackMapTable, StackFrame firstFrame) {
        new StackMapFrameParser(verifier, stackMapTable).parseStackMapTableAttribute(firstFrame);
    }

    private void parseStackMapTableAttribute(StackFrame firstFrame) {
        StackFrame previous = firstFrame;
        int bci = 0;
        boolean first = true;
        int entryCount = this.stream.readU2();
        for (int i = 0; i < entryCount; ++i) {
            StackMapFrame entry = this.parseStackMapFrame();
            StackFrame frame = this.verifier.getStackFrame(entry, previous);
            bci = bci + entry.getOffset() + (first ? 0 : 1);
            this.verifier.registerStackMapFrame(bci, frame);
            first = false;
            previous = frame;
        }
        if (!this.stream.isAtEndOfFile()) {
            throw MethodVerifier.failFormatNoFallback("Truncated StackMap attribute in " + this.verifier.getThisKlass().getExternalName() + "." + String.valueOf(this.verifier.getMethodName()));
        }
    }

    private StackMapFrame parseStackMapFrame() {
        int frameType = this.stream.readU1();
        if (frameType < 64) {
            return new SameFrame(frameType);
        }
        if (frameType < 128) {
            VerificationTypeInfo stackItem = this.parseVerificationTypeInfo();
            return new SameLocals1StackItemFrame(frameType, stackItem);
        }
        if (frameType < 247) {
            throw MethodVerifier.failFormatNoFallback("Encountered reserved StackMapFrame tag: " + frameType);
        }
        if (frameType == 247) {
            int offsetDelta = this.stream.readU2();
            VerificationTypeInfo stackItem = this.parseVerificationTypeInfo();
            return new SameLocals1StackItemFrameExtended(frameType, offsetDelta, stackItem);
        }
        if (frameType < 251) {
            int offsetDelta = this.stream.readU2();
            return new ChopFrame(frameType, offsetDelta);
        }
        if (frameType == 251) {
            int offsetDelta = this.stream.readU2();
            return new SameFrameExtended(frameType, offsetDelta);
        }
        if (frameType < 255) {
            int offsetDelta = this.stream.readU2();
            int appendLength = frameType - 251;
            VerificationTypeInfo[] locals = new VerificationTypeInfo[appendLength];
            for (int i = 0; i < appendLength; ++i) {
                locals[i] = this.parseVerificationTypeInfo();
            }
            return new AppendFrame(frameType, offsetDelta, locals);
        }
        if (frameType == 255) {
            int offsetDelta = this.stream.readU2();
            int localsLength = this.stream.readU2();
            VerificationTypeInfo[] locals = new VerificationTypeInfo[localsLength];
            for (int i = 0; i < localsLength; ++i) {
                locals[i] = this.parseVerificationTypeInfo();
            }
            int stackLength = this.stream.readU2();
            VerificationTypeInfo[] stack = new VerificationTypeInfo[stackLength];
            for (int i = 0; i < stackLength; ++i) {
                stack[i] = this.parseVerificationTypeInfo();
            }
            return new FullFrame(frameType, offsetDelta, locals, stack);
        }
        throw MethodVerifier.failFormat("Unrecognized StackMapFrame tag: " + frameType);
    }

    private VerificationTypeInfo parseVerificationTypeInfo() {
        int tag = this.stream.readU1();
        if (tag < 6) {
            return PrimitiveTypeInfo.get(tag);
        }
        switch (tag) {
            case 6: {
                return UninitializedThis.get();
            }
            case 7: {
                return new ReferenceVariable(this.stream.readU2());
            }
            case 8: {
                return new UninitializedVariable(this.stream.readU2());
            }
        }
        throw MethodVerifier.failFormatNoFallback("Unrecognized verification type info tag: " + tag);
    }
}

