/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BciProvider;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_Thread;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.Transition;
import com.oracle.truffle.espresso.vm.VM;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class InterpreterToVM
extends ContextAccessImpl {
    public static final int MAX_STACK_DEPTH = Integer.MAX_VALUE;

    public InterpreterToVM(EspressoContext context) {
        super(context);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void monitorUnsafeEnter(EspressoLock self) {
        self.lock();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void monitorUnsafeExit(EspressoLock self) {
        self.unlock();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void monitorNotifyAll(EspressoLock self) {
        self.signalAll();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void monitorNotify(EspressoLock self) {
        self.signal();
    }

    public static boolean monitorWait(EspressoLock self, long timeout) throws GuestInterruptedException {
        return self.await(timeout, TimeUnit.MILLISECONDS, null, null);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean monitorWait(EspressoLock self, long timeout, StaticObject thread, StaticObject obj) throws GuestInterruptedException {
        return self.await(timeout, TimeUnit.MILLISECONDS, thread, obj);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean monitorTryLock(EspressoLock lock) {
        return lock.tryLock();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean holdsLock(EspressoLock lock) {
        return lock.isHeldByCurrentThread();
    }

    public int getArrayInt(EspressoLanguage language, int index, @JavaType(value=int[].class) StaticObject array) {
        return this.getArrayInt(language, index, array, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static String outOfBoundsMessage(int index, int length) {
        return "Index " + index + " out of bounds for length " + length;
    }

    public int getArrayInt(EspressoLanguage language, int index, @JavaType(value=int[].class) StaticObject array, BytecodeNode bytecodeNode) {
        int[] underlying = (int[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public StaticObject getArrayObject(EspressoLanguage language, int index, @JavaType(value=Object[].class) StaticObject array) {
        return this.getArrayObject(language, index, array, null);
    }

    public StaticObject getArrayObject(EspressoLanguage language, int index, @JavaType(value=Object[].class) StaticObject array, BytecodeNode bytecodeNode) {
        StaticObject[] underlying = (StaticObject[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public long getArrayLong(EspressoLanguage language, int index, @JavaType(value=long[].class) StaticObject array) {
        return this.getArrayLong(language, index, array, null);
    }

    public long getArrayLong(EspressoLanguage language, int index, @JavaType(value=long[].class) StaticObject array, BytecodeNode bytecodeNode) {
        long[] underlying = (long[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public float getArrayFloat(EspressoLanguage language, int index, @JavaType(value=float[].class) StaticObject array) {
        return this.getArrayFloat(language, index, array, null);
    }

    public float getArrayFloat(EspressoLanguage language, int index, @JavaType(value=float[].class) StaticObject array, BytecodeNode bytecodeNode) {
        float[] underlying = (float[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public double getArrayDouble(EspressoLanguage language, int index, @JavaType(value=double[].class) StaticObject array) {
        return this.getArrayDouble(language, index, array, null);
    }

    public double getArrayDouble(EspressoLanguage language, int index, @JavaType(value=double[].class) StaticObject array, BytecodeNode bytecodeNode) {
        double[] underlying = (double[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public byte getArrayByte(EspressoLanguage language, int index, @JavaType(value=byte[].class) StaticObject array) {
        return this.getArrayByte(language, index, array, null);
    }

    public byte getArrayByte(EspressoLanguage language, int index, @JavaType(value=byte[].class) StaticObject array, BytecodeNode bytecodeNode) {
        byte[] underlying = (byte[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public char getArrayChar(EspressoLanguage language, int index, @JavaType(value=char[].class) StaticObject array) {
        return this.getArrayChar(language, index, array, null);
    }

    public char getArrayChar(EspressoLanguage language, int index, @JavaType(value=char[].class) StaticObject array, BytecodeNode bytecodeNode) {
        char[] underlying = (char[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public short getArrayShort(EspressoLanguage language, int index, @JavaType(value=short[].class) StaticObject array) {
        return this.getArrayShort(language, index, array, null);
    }

    public short getArrayShort(EspressoLanguage language, int index, @JavaType(value=short[].class) StaticObject array, BytecodeNode bytecodeNode) {
        short[] underlying = (short[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            return underlying[index];
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayInt(EspressoLanguage language, int value, int index, @JavaType(value=int[].class) StaticObject array) {
        this.setArrayInt(language, value, index, array, null);
    }

    public void setArrayInt(EspressoLanguage language, int value, int index, @JavaType(value=int[].class) StaticObject array, BytecodeNode bytecodeNode) {
        int[] underlying = (int[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = value;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayLong(EspressoLanguage language, long value, int index, @JavaType(value=long[].class) StaticObject array) {
        this.setArrayLong(language, value, index, array, null);
    }

    public void setArrayLong(EspressoLanguage language, long value, int index, @JavaType(value=long[].class) StaticObject array, BytecodeNode bytecodeNode) {
        long[] underlying = (long[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = value;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayFloat(EspressoLanguage language, float value, int index, @JavaType(value=float[].class) StaticObject array) {
        this.setArrayFloat(language, value, index, array, null);
    }

    public void setArrayFloat(EspressoLanguage language, float value, int index, @JavaType(value=float[].class) StaticObject array, BytecodeNode bytecodeNode) {
        float[] underlying = (float[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = value;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayDouble(EspressoLanguage language, double value, int index, @JavaType(value=double[].class) StaticObject array) {
        this.setArrayDouble(language, value, index, array, null);
    }

    public void setArrayDouble(EspressoLanguage language, double value, int index, @JavaType(value=double[].class) StaticObject array, BytecodeNode bytecodeNode) {
        double[] underlying = (double[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = value;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayByte(EspressoLanguage language, byte value, int index, @JavaType(value=byte[].class) StaticObject array) {
        this.setArrayByte(language, value, index, array, null);
    }

    public void setArrayByte(EspressoLanguage language, byte value, int index, @JavaType(value=byte[].class) StaticObject array, BytecodeNode bytecodeNode) {
        byte maybeMaskedValue = this.getJavaVersion().java9OrLater() && array.getKlass() == this.getMeta()._boolean_array ? (byte)(value & 1) : value;
        byte[] underlying = (byte[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = maybeMaskedValue;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayChar(EspressoLanguage language, char value, int index, @JavaType(value=char[].class) StaticObject array) {
        this.setArrayChar(language, value, index, array, null);
    }

    public void setArrayChar(EspressoLanguage language, char value, int index, @JavaType(value=char[].class) StaticObject array, BytecodeNode bytecodeNode) {
        char[] underlying = (char[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = value;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayShort(EspressoLanguage language, short value, int index, @JavaType(value=short[].class) StaticObject array) {
        this.setArrayShort(language, value, index, array, null);
    }

    public void setArrayShort(EspressoLanguage language, short value, int index, @JavaType(value=short[].class) StaticObject array, BytecodeNode bytecodeNode) {
        short[] underlying = (short[])array.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            underlying[index] = value;
            return;
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public void setArrayObject(EspressoLanguage language, StaticObject value, int index, StaticObject wrapper) {
        this.setArrayObject(language, value, index, wrapper, null);
    }

    public void setArrayObject(EspressoLanguage language, StaticObject value, int index, StaticObject wrapper, BytecodeNode bytecodeNode) {
        StaticObject[] underlying = (StaticObject[])wrapper.unwrap(language);
        if (Integer.compareUnsigned(index, underlying.length) < 0) {
            if (StaticObject.isNull(value) || InterpreterToVM.instanceOf(value, ((ArrayKlass)wrapper.getKlass()).getComponentType())) {
                underlying[index] = value;
                return;
            }
            if (bytecodeNode != null) {
                bytecodeNode.enterImplicitExceptionProfile();
            }
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_ArrayStoreException, value.getKlass().getTypeAsString());
        }
        if (bytecodeNode != null) {
            bytecodeNode.enterImplicitExceptionProfile();
        }
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, underlying.length));
    }

    public static void monitorEnter(@JavaType(value=Object.class) StaticObject obj, Meta meta) {
        EspressoLock lock = obj.getLock(meta.getContext());
        EspressoContext context = meta.getContext();
        if (!InterpreterToVM.monitorTryLock(lock)) {
            InterpreterToVM.contendedMonitorEnter(obj, meta, lock, context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void contendedMonitorEnter(StaticObject obj, Meta meta, EspressoLock lock, EspressoContext context) {
        StaticObject thread = context.getCurrentPlatformThread();
        try (Transition transition = Transition.transition(context, State.BLOCKED);){
            boolean report;
            if (context.getEspressoEnv().EnableManagement) {
                meta.HIDDEN_THREAD_PENDING_MONITOR.setHiddenObject(thread, obj);
                Field blockedCount = meta.HIDDEN_THREAD_BLOCKED_COUNT;
                Target_java_lang_Thread.incrementThreadCounter(thread, blockedCount);
            }
            if (report = context.shouldReportVMEvents()) {
                context.reportOnContendedMonitorEnter(obj);
            }
            InterpreterToVM.monitorUnsafeEnter(lock);
            if (report) {
                context.reportOnContendedMonitorEntered(obj);
            }
            if (context.getEspressoEnv().EnableManagement) {
                meta.HIDDEN_THREAD_PENDING_MONITOR.setHiddenObject(thread, null);
            }
        }
    }

    public static void monitorExit(@JavaType(value=Object.class) StaticObject obj, Meta meta) {
        EspressoLock lock = obj.getLock(meta.getContext());
        if (!InterpreterToVM.holdsLock(lock)) {
            throw meta.throwException(meta.java_lang_IllegalMonitorStateException);
        }
        InterpreterToVM.monitorUnsafeExit(lock);
    }

    public static boolean getFieldBoolean(StaticObject obj, Field field) {
        return field.getBoolean(obj);
    }

    public static int getFieldInt(StaticObject obj, Field field) {
        return field.getInt(obj);
    }

    public static long getFieldLong(StaticObject obj, Field field) {
        return field.getLong(obj);
    }

    public static byte getFieldByte(StaticObject obj, Field field) {
        return field.getByte(obj);
    }

    public static short getFieldShort(StaticObject obj, Field field) {
        return field.getShort(obj);
    }

    public static float getFieldFloat(StaticObject obj, Field field) {
        return field.getFloat(obj);
    }

    public static double getFieldDouble(StaticObject obj, Field field) {
        return field.getDouble(obj);
    }

    public static StaticObject getFieldObject(StaticObject obj, Field field) {
        return field.getObject(obj);
    }

    public static char getFieldChar(StaticObject obj, Field field) {
        return field.getChar(obj);
    }

    public static void setFieldBoolean(boolean value, StaticObject obj, Field field) {
        field.setBoolean(obj, value);
    }

    public static void setFieldByte(byte value, StaticObject obj, Field field) {
        field.setByte(obj, value);
    }

    public static void setFieldChar(char value, StaticObject obj, Field field) {
        field.setChar(obj, value);
    }

    public static void setFieldShort(short value, StaticObject obj, Field field) {
        field.setShort(obj, value);
    }

    public static void setFieldInt(int value, StaticObject obj, Field field) {
        field.setInt(obj, value);
    }

    public static void setFieldLong(long value, StaticObject obj, Field field) {
        field.setLong(obj, value);
    }

    public static void setFieldFloat(float value, StaticObject obj, Field field) {
        field.setFloat(obj, value);
    }

    public static void setFieldDouble(double value, StaticObject obj, Field field) {
        field.setDouble(obj, value);
    }

    public static void setFieldObject(StaticObject value, StaticObject obj, Field field) {
        field.setObject(obj, value);
    }

    public static boolean instanceOf(StaticObject instance, Klass typeToCheck) {
        if (StaticObject.isNull(instance)) {
            return false;
        }
        return typeToCheck.isAssignableFrom(instance.getKlass());
    }

    public static StaticObject checkCast(StaticObject instance, Klass klass) {
        if (StaticObject.isNull(instance) || InterpreterToVM.instanceOf(instance, klass)) {
            return instance;
        }
        Meta meta = klass.getMeta();
        throw meta.throwException(meta.java_lang_ClassCastException);
    }

    public static int arrayLength(StaticObject arr, EspressoLanguage language) {
        assert (arr.isArray());
        return arr.length(language);
    }

    public static boolean referenceIdentityEqual(StaticObject o1, StaticObject o2, EspressoLanguage language) {
        if (o1 == o2) {
            return true;
        }
        if (StaticObject.isNull(o1) && StaticObject.isNull(o2)) {
            return true;
        }
        if (o1.isForeignObject() && o2.isForeignObject()) {
            Object foreignOp1 = o1.rawForeignObject(language);
            Object foreignOp2 = o2.rawForeignObject(language);
            InteropLibrary operand1Lib = InteropLibrary.getUncached((Object)foreignOp1);
            InteropLibrary operand2Lib = InteropLibrary.getUncached((Object)foreignOp2);
            return operand1Lib.isIdentical(foreignOp1, foreignOp2, operand2Lib);
        }
        return false;
    }

    public @JavaType(value=String.class) StaticObject intern(@JavaType(value=String.class) StaticObject guestString) {
        assert (this.getMeta().java_lang_String == guestString.getKlass());
        return this.getStrings().intern(guestString);
    }

    public static StaticObject fillInStackTraceLazy(@JavaType(value=Throwable.class) StaticObject throwable, Meta meta) {
        VM.StackTrace frames = (VM.StackTrace)meta.HIDDEN_FRAMES.getHiddenObject(throwable);
        if (frames != null) {
            return throwable;
        }
        EspressoException e = EspressoException.wrap(throwable, meta);
        List trace = TruffleStackTrace.getStackTrace((Throwable)((Object)e));
        if (trace == null) {
            meta.HIDDEN_FRAMES.setHiddenObject(throwable, VM.StackTrace.EMPTY_STACK_TRACE);
            meta.java_lang_Throwable_backtrace.setObject(throwable, throwable);
            return throwable;
        }
        int bci = -1;
        frames = new VM.StackTrace();
        FillInStackTraceFramesFilter filter = new FillInStackTraceFramesFilter();
        for (TruffleStackTraceElement element : trace) {
            RootNode rootNode;
            RootCallTarget target;
            for (Node location = element.getLocation(); location != null; location = location.getParent()) {
                if (!(location instanceof BciProvider)) continue;
                bci = ((BciProvider)location).getBci(element.getFrame());
                break;
            }
            if ((target = element.getTarget()) == null || !((rootNode = target.getRootNode()) instanceof EspressoRootNode)) continue;
            Method m = ((EspressoRootNode)rootNode).getMethod();
            if (!filter.include(m)) {
                bci = VM.EspressoStackElement.UNKNOWN_BCI;
                continue;
            }
            if (m.isNative()) {
                bci = VM.EspressoStackElement.NATIVE_BCI;
            }
            frames.add(new VM.EspressoStackElement(m, bci));
            bci = VM.EspressoStackElement.UNKNOWN_BCI;
        }
        meta.HIDDEN_FRAMES.setHiddenObject(throwable, frames);
        meta.java_lang_Throwable_backtrace.setObject(throwable, throwable);
        return throwable;
    }

    public static StaticObject fillInStackTrace(@JavaType(value=Throwable.class) StaticObject throwable, Meta meta) {
        VM.StackTrace frames = InterpreterToVM.getStackTrace(new FillInStackTraceFramesFilter(), 32);
        meta.HIDDEN_FRAMES.setHiddenObject(throwable, frames);
        meta.java_lang_Throwable_backtrace.setObject(throwable, throwable);
        if (meta.getJavaVersion().java9OrLater()) {
            meta.java_lang_Throwable_depth.setInt(throwable, frames.size);
        }
        return throwable;
    }

    public static VM.StackTrace getStackTrace(final FrameFilter filter, final int maxDepth) {
        assert (maxDepth >= 0);
        final VM.StackTrace frames = new VM.StackTrace();
        if (maxDepth == 0) {
            return frames;
        }
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){
            int count;

            public Object visitFrame(FrameInstance frameInstance) {
                RootNode rootNode;
                if (this.count >= maxDepth) {
                    return this;
                }
                CallTarget callTarget = frameInstance.getCallTarget();
                if (callTarget instanceof RootCallTarget && (rootNode = ((RootCallTarget)callTarget).getRootNode()) instanceof EspressoRootNode) {
                    EspressoRootNode espressoNode = (EspressoRootNode)rootNode;
                    Method method = espressoNode.getMethod();
                    if (filter.include(method)) {
                        int bci = espressoNode.readBCI(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY));
                        frames.add(new VM.EspressoStackElement(method, bci));
                        ++this.count;
                    } else if (this.count == 0 && !DefaultHiddenFramesFilter.INSTANCE.include(method)) {
                        frames.markTopFrameHidden();
                    }
                }
                return null;
            }
        });
        return frames;
    }

    private static final class FillInStackTraceFramesFilter
    extends DefaultHiddenFramesFilter {
        private boolean afterFillInStackTrace;
        private boolean afterThrowableInit;

        private FillInStackTraceFramesFilter() {
        }

        @Override
        public boolean include(Method m) {
            if (!super.include(m)) {
                return false;
            }
            if (!this.afterFillInStackTrace) {
                if (Symbol.Name.fillInStackTrace.equals(m.getName()) || Symbol.Name.fillInStackTrace0.equals(m.getName())) {
                    return false;
                }
                this.afterFillInStackTrace = true;
            }
            if (!this.afterThrowableInit) {
                assert (this.afterFillInStackTrace);
                if (Symbol.Name._init_.equals(m.getName()) && m.getMeta().java_lang_Throwable.isAssignableFrom(m.getDeclaringKlass())) {
                    return false;
                }
                this.afterThrowableInit = true;
            }
            return true;
        }
    }

    public static interface FrameFilter {
        public boolean include(Method var1);
    }

    public static class DefaultHiddenFramesFilter
    implements FrameFilter {
        public static final DefaultHiddenFramesFilter INSTANCE = new DefaultHiddenFramesFilter();

        @Override
        public boolean include(Method m) {
            return !m.isHidden();
        }
    }
}

