/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;

public final class ModulesHelperVM {
    private ModulesHelperVM() {
    }

    private static ModuleTable.ModuleEntry getModuleEntry(@JavaType(internalName="Ljava/lang/Module") StaticObject module, Meta meta) {
        return (ModuleTable.ModuleEntry)meta.HIDDEN_MODULE_ENTRY.getHiddenObject(module);
    }

    private static PackageTable.PackageEntry getPackageEntry(ModuleTable.ModuleEntry fromModuleEntry, Symbol<Symbol.Name> nameSymbol) {
        return (PackageTable.PackageEntry)fromModuleEntry.registry().packages().lookup(nameSymbol);
    }

    public static ModuleTable.ModuleEntry extractToModuleEntry(@JavaType(internalName="Ljava/lang/Module") StaticObject toModule, Meta meta, SubstitutionProfiler profiler) {
        ModuleTable.ModuleEntry toModuleEntry = null;
        if (!StaticObject.isNull(toModule) && (toModuleEntry = ModulesHelperVM.getModuleEntry(toModule, meta)) == null) {
            if (profiler != null) {
                profiler.profile(8);
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "to_module is invalid");
        }
        return toModuleEntry;
    }

    public static ModuleTable.ModuleEntry extractFromModuleEntry(@JavaType(internalName="Ljava/lang/Module") StaticObject fromModule, Meta meta, SubstitutionProfiler profiler) {
        if (StaticObject.isNull(fromModule)) {
            if (profiler != null) {
                profiler.profile(9);
            }
            throw meta.throwNullPointerException();
        }
        ModuleTable.ModuleEntry fromModuleEntry = ModulesHelperVM.getModuleEntry(fromModule, meta);
        if (fromModuleEntry == null) {
            if (profiler != null) {
                profiler.profile(10);
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "from_module cannot be found");
        }
        return fromModuleEntry;
    }

    public static PackageTable.PackageEntry extractPackageEntry(String pkg, ModuleTable.ModuleEntry fromModuleEntry, Meta meta, SubstitutionProfiler profiler) {
        PackageTable.PackageEntry packageEntry = null;
        Symbol<Symbol.Name> nameSymbol = meta.getContext().getNames().lookup(pkg);
        if (nameSymbol != null) {
            packageEntry = ModulesHelperVM.getPackageEntry(fromModuleEntry, nameSymbol);
        }
        if (packageEntry == null) {
            if (profiler != null) {
                profiler.profile(11);
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, EspressoError.cat("package ", pkg, " cannot be found in ", fromModuleEntry.getNameAsString()));
        }
        if (packageEntry.module() != fromModuleEntry) {
            if (profiler != null) {
                profiler.profile(12);
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, EspressoError.cat("package ", pkg, " found in ", packageEntry.module().getNameAsString(), ", not in ", fromModuleEntry.getNameAsString()));
        }
        return packageEntry;
    }

    public static void addModuleExports(@JavaType(internalName="Ljava/lang/Module") StaticObject fromModule, String pkgName, @JavaType(internalName="Ljava/lang/Module") StaticObject toModule, Meta meta, SubstitutionProfiler profiler) {
        ModuleTable.ModuleEntry fromModuleEntry = ModulesHelperVM.extractFromModuleEntry(fromModule, meta, profiler);
        if (!fromModuleEntry.isNamed() || fromModuleEntry.isOpen()) {
            return;
        }
        ModuleTable.ModuleEntry toModuleEntry = ModulesHelperVM.extractToModuleEntry(toModule, meta, profiler);
        PackageTable.PackageEntry packageEntry = ModulesHelperVM.extractPackageEntry(pkgName, fromModuleEntry, meta, profiler);
        if (fromModuleEntry != toModuleEntry) {
            packageEntry.addExports(toModuleEntry);
        }
    }

    public static void addModuleExportsToAllUnnamed(@JavaType(internalName="Ljava/lang/Module") StaticObject from, String pkgName, SubstitutionProfiler profiler, Meta meta) {
        ModuleTable.ModuleEntry fromModuleEntry = ModulesHelperVM.extractFromModuleEntry(from, meta, profiler);
        if (fromModuleEntry.isNamed()) {
            PackageTable.PackageEntry packageEntry = ModulesHelperVM.extractPackageEntry(pkgName, fromModuleEntry, meta, profiler);
            packageEntry.setExportedAllUnnamed();
        }
    }
}

