/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.npe;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.VM;
import com.oracle.truffle.espresso.vm.npe.Analysis;

public final class ExtendedNPEMessage {
    public static String getNPEMessage(StaticObject throwable) {
        if (throwable == null || StaticObject.isNull(throwable) || throwable.isForeignObject()) {
            return null;
        }
        EspressoContext ctx = throwable.getKlass().getContext();
        assert (throwable.getKlass() == ctx.getMeta().java_lang_NullPointerException) : "Calling getExtendedNPEMessage with non NPE throwable.";
        VM.StackTrace frames = (VM.StackTrace)ctx.getMeta().HIDDEN_FRAMES.getHiddenObject(throwable);
        if (frames == null) {
            return null;
        }
        if (frames.isSkippedFramesHidden()) {
            return null;
        }
        VM.StackElement top = frames.top();
        if (top == null || top.getBci() < 0) {
            return null;
        }
        if (top.getMethod().getDeclaringKlass().getType() == Symbol.Type.jdk_internal_reflect_NativeConstructorAccessorImpl) {
            return null;
        }
        try {
            return Analysis.analyze(top.getMethod(), top.getBci()).buildMessage();
        }
        catch (Throwable e) {
            ctx.getLogger().warning(() -> "Unexpected throw during extended NPE message construction: bailing out...");
            ctx.getLogger().warning(e::toString);
            return null;
        }
    }
}

