/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.npe;

import com.oracle.truffle.espresso.vm.npe.StackType;

final class StackObject {
    static final int UNKNOWN_BCI = -1;
    static final StackObject UNKNOWN_CONFLICT = new StackObject(-1, StackType.CONFLICT);
    static final StackObject UNKNOWN_OBJECT = new StackObject(-1, StackType.OBJECT);
    private final int originBci;
    private final StackType type;

    private StackObject(int originBci, StackType type) {
        assert (type != StackType.VOID);
        this.originBci = originBci;
        this.type = type;
    }

    static StackObject create(int bci, StackType type) {
        if (bci == -1) {
            if (type == StackType.CONFLICT) {
                return UNKNOWN_CONFLICT;
            }
            if (type == StackType.OBJECT) {
                return UNKNOWN_OBJECT;
            }
        }
        return new StackObject(bci, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StackObject merge(StackObject o1, StackObject o2) {
        int mergeBci;
        StackType mergeType;
        StackObject reuseCandidate = null;
        if (o1.type() != o2.type()) {
            if (o1.type() == StackType.OBJECT && o2.type() == StackType.ARRAY) {
                mergeType = StackType.OBJECT;
                reuseCandidate = o1;
            } else {
                if (o1.type() != StackType.ARRAY || o2.type() != StackType.OBJECT) return UNKNOWN_CONFLICT;
                mergeType = StackType.OBJECT;
                reuseCandidate = o2;
            }
        } else {
            mergeType = o1.type();
            reuseCandidate = o1;
        }
        if (o1.originBci() == o2.originBci()) {
            mergeBci = o1.originBci();
        } else {
            mergeBci = -1;
            reuseCandidate = null;
        }
        if (reuseCandidate == null) return StackObject.create(mergeBci, mergeType);
        return reuseCandidate;
    }

    public int originBci() {
        return this.originBci;
    }

    public boolean hasBci() {
        return this.originBci != -1;
    }

    public StackType type() {
        return this.type;
    }
}

