/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.hierarchy;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;

public final class AssumptionGuardedValue<T> {
    private final Assumption hasValue;
    final T value;

    public static <T> AssumptionGuardedValue<T> create(T value) {
        CompilerAsserts.neverPartOfCompilation();
        if (value == null) {
            throw AssumptionGuardedValue.reportInvalidValue();
        }
        return new AssumptionGuardedValue<T>(Truffle.getRuntime().createAssumption(), value);
    }

    private static NullPointerException reportInvalidValue() {
        throw new NullPointerException("null is reserved for invalid value");
    }

    public static <T> AssumptionGuardedValue<T> createInvalid() {
        CompilerAsserts.neverPartOfCompilation();
        return new AssumptionGuardedValue<Object>(Assumption.NEVER_VALID, null);
    }

    private AssumptionGuardedValue(Assumption hasValue, T value) {
        this.hasValue = hasValue;
        this.value = value;
    }

    public Assumption hasValue() {
        return this.hasValue;
    }

    public T get() {
        if (!this.hasValue.isValid()) {
            return null;
        }
        return this.value;
    }
}

