/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.hierarchy;

import com.oracle.truffle.espresso.analysis.hierarchy.AssumptionGuardedValue;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumptionImpl;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyOracle;
import com.oracle.truffle.espresso.analysis.hierarchy.SingleImplementor;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;

public final class NoOpClassHierarchyOracle
implements ClassHierarchyOracle {
    private static final AssumptionGuardedValue<ObjectKlass> NotSingleImplementor = AssumptionGuardedValue.createInvalid();

    @Override
    public ClassHierarchyAssumption createAssumptionForNewKlass(ObjectKlass newKlass) {
        if (newKlass.isFinalFlagSet()) {
            return ClassHierarchyAssumptionImpl.AlwaysValid;
        }
        return ClassHierarchyAssumptionImpl.NeverValid;
    }

    @Override
    public ClassHierarchyAssumption isLeafKlass(ObjectKlass klass) {
        if (klass.isFinalFlagSet()) {
            return ClassHierarchyAssumptionImpl.AlwaysValid;
        }
        return ClassHierarchyAssumptionImpl.NeverValid;
    }

    @Override
    public ClassHierarchyAssumption hasNoImplementors(ObjectKlass klass) {
        return ClassHierarchyAssumptionImpl.NeverValid;
    }

    @Override
    public SingleImplementor initializeImplementorForNewKlass(ObjectKlass klass) {
        return SingleImplementor.MultipleImplementors;
    }

    @Override
    public AssumptionGuardedValue<ObjectKlass> readSingleImplementor(ObjectKlass klass) {
        return NotSingleImplementor;
    }

    @Override
    public ClassHierarchyAssumption createLeafAssumptionForNewMethod(Method newMethod) {
        if (newMethod.isAbstract()) {
            return ClassHierarchyAssumptionImpl.NeverValid;
        }
        if (newMethod.isStatic() || newMethod.isPrivate() || newMethod.isFinalFlagSet()) {
            return ClassHierarchyAssumptionImpl.AlwaysValid;
        }
        return ClassHierarchyAssumptionImpl.NeverValid;
    }

    @Override
    public ClassHierarchyAssumption isLeafMethod(Method method) {
        if (method.isStatic() || method.isPrivate() || method.isFinalFlagSet()) {
            return ClassHierarchyAssumptionImpl.AlwaysValid;
        }
        return ClassHierarchyAssumptionImpl.NeverValid;
    }
}

