/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness.actions;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.analysis.liveness.LocalVariableAction;
import com.oracle.truffle.espresso.analysis.liveness.actions.MultiAction;
import com.oracle.truffle.espresso.nodes.EspressoFrame;

public final class NullOutAction
extends LocalVariableAction {
    private static final int MAX_CACHE = 256;
    private static final LocalVariableAction[] CACHE = new LocalVariableAction[256];
    private final int local;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalVariableAction get(int local) {
        if (local >= 256) return new NullOutAction(local);
        LocalVariableAction res = CACHE[local];
        if (res != null) return res;
        LocalVariableAction[] localVariableActionArray = CACHE;
        synchronized (CACHE) {
            res = CACHE[local];
            if (res != null) return res;
            NullOutAction.CACHE[local] = new NullOutAction(local);
            return NullOutAction.CACHE[local];
        }
    }

    private NullOutAction(int local) {
        this.local = local;
    }

    @Override
    public void execute(VirtualFrame frame) {
        EspressoFrame.clearLocal((Frame)frame, this.local);
    }

    @Override
    public void execute(EspressoFrameDescriptor.Builder frame) {
        frame.clear(this.local);
    }

    public String toString() {
        return "" + this.local;
    }

    @Override
    public LocalVariableAction merge(LocalVariableAction other) {
        if (other instanceof MultiAction) {
            return other.merge(this);
        }
        assert (other instanceof NullOutAction);
        return new MultiAction(new int[]{this.local, ((NullOutAction)other).local});
    }

    public int local() {
        return this.local;
    }
}

