/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Utf8Constant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public final class ImmutableConstantPool
extends ConstantPool {
    private final int majorVersion;
    private final int minorVersion;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PoolConstant[] constants;
    private final int totalPoolBytes;

    ImmutableConstantPool(PoolConstant[] constants, int majorVersion, int minorVersion, int totalPoolBytes) {
        this.constants = Objects.requireNonNull(constants);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.totalPoolBytes = totalPoolBytes;
    }

    @Override
    public int length() {
        return this.constants.length;
    }

    @Override
    public byte[] getRawBytes() {
        byte[] bytes = new byte[this.totalPoolBytes];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (PoolConstant pc : this.constants) {
            pc.dumpBytes(bb);
        }
        return bytes;
    }

    @Override
    public PoolConstant at(int index, String description) {
        try {
            return this.constants[index];
        }
        catch (IndexOutOfBoundsException exception) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ImmutableConstantPool.classFormaterror(index, description);
        }
    }

    private static @JavaType(value=ClassFormatError.class) EspressoException classFormaterror(int index, String description) {
        return ConstantPool.classFormatError("Constant pool index (" + index + ")" + (String)(description == null ? "" : " for " + description) + " is out of range");
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    ImmutableConstantPool patchForHiddenClass(int thisKlassIndex, Symbol<?> newName) {
        int newNamePos = this.constants.length;
        Utf8Constant newNameConstant = new Utf8Constant(newName);
        PoolConstant[] newEntries = Arrays.copyOf(this.constants, this.constants.length + 1);
        newEntries[newNamePos] = newNameConstant;
        newEntries[thisKlassIndex] = ClassConstant.create(newNamePos);
        int rawLengthIncrease = 2 + newName.length();
        return new ImmutableConstantPool(newEntries, this.majorVersion, this.minorVersion, this.totalPoolBytes + rawLengthIncrease);
    }
}

