/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.BootstrapMethodConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.methodhandle.MHLinkToNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.nio.ByteBuffer;

public interface DynamicConstant
extends PoolConstant {
    public static DynamicConstant create(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
        return new Indexes(bootstrapMethodAttrIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.DYNAMIC;
    }

    public Symbol<Symbol.Type> getTypeSymbol(ConstantPool var1);

    public static final class Indexes
    extends BootstrapMethodConstant.Indexes
    implements DynamicConstant,
    Resolvable {
        Indexes(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
            super(bootstrapMethodAttrIndex, nameAndTypeIndex);
        }

        @Override
        public Symbol<Symbol.Type> getTypeSymbol(ConstantPool pool) {
            return Types.fromSymbol(pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool));
        }

        private static Resolved makeResolved(Klass type, StaticObject result) {
            switch (type.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Short: 
                case Char: {
                    int value = (Integer)MHLinkToNode.rebasic(type.getMeta().unboxGuest(result), type.getJavaKind());
                    return new ResolvedInt(value);
                }
                case Int: {
                    int value = type.getMeta().unboxInteger(result);
                    return new ResolvedInt(value);
                }
                case Float: {
                    float value = type.getMeta().unboxFloat(result);
                    return new ResolvedFloat(value);
                }
                case Long: {
                    long value = type.getMeta().unboxLong(result);
                    return new ResolvedLong(value);
                }
                case Double: {
                    double value = type.getMeta().unboxDouble(result);
                    return new ResolvedDouble(value);
                }
                case Object: {
                    return new ResolvedObject(result);
                }
            }
            throw EspressoError.shouldNotReachHere();
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateField(pool);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.bootstrapMethodAttrIndex);
            buf.putChar(this.nameAndTypeIndex);
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
            Meta meta = accessingKlass.getMeta();
            BootstrapMethodsAttribute bms = (BootstrapMethodsAttribute)accessingKlass.getAttribute(BootstrapMethodsAttribute.NAME);
            assert (bms != null);
            try {
                BootstrapMethodsAttribute.Entry bsEntry = bms.at(this.getBootstrapMethodAttrIndex());
                StaticObject bootstrapmethodMethodHandle = bsEntry.getMethodHandle(accessingKlass, pool);
                StaticObject[] args = bsEntry.getStaticArguments(accessingKlass, pool);
                StaticObject fieldName = meta.toGuestString(this.getName(pool));
                Klass fieldType = meta.resolveSymbolOrFail(this.getTypeSymbol(pool), accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
                Object result = null;
                result = !meta.getJavaVersion().java19OrLater() ? meta.java_lang_invoke_MethodHandleNatives_linkDynamicConstant.invokeDirect(null, accessingKlass.mirror(), thisIndex, bootstrapmethodMethodHandle, fieldName, fieldType.mirror(), StaticObject.wrap(args, meta)) : meta.java_lang_invoke_MethodHandleNatives_linkDynamicConstant.invokeDirect(null, accessingKlass.mirror(), bootstrapmethodMethodHandle, fieldName, fieldType.mirror(), StaticObject.wrap(args, meta));
                try {
                    return Indexes.makeResolved(fieldType, (StaticObject)result);
                }
                catch (ClassCastException | NullPointerException e) {
                    throw meta.throwException(meta.java_lang_BootstrapMethodError);
                }
                catch (EspressoException e) {
                    if (meta.java_lang_NullPointerException.isAssignableFrom(e.getGuestException().getKlass()) || meta.java_lang_ClassCastException.isAssignableFrom(e.getGuestException().getKlass())) {
                        throw meta.throwExceptionWithCause(meta.java_lang_BootstrapMethodError, e.getGuestException());
                    }
                    throw e;
                }
            }
            catch (EspressoException e) {
                return new ResolvedFail(e);
            }
        }
    }

    public static final class ResolvedFail
    implements Resolved {
        final EspressoException failure;

        public ResolvedFail(EspressoException failure) {
            this.failure = failure;
        }

        @Override
        public void checkFail() {
            throw this.failure;
        }

        @Override
        public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Failure should have arose earlier.");
        }

        @Override
        public Object value() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Failure should have arose earlier.");
        }

        @Override
        public String toString(ConstantPool pool) {
            return "ResolvedDynamicConstant(" + String.valueOf((Object)this.failure) + ")";
        }
    }

    public static final class ResolvedFloat
    implements Resolved {
        final float resolved;

        public ResolvedFloat(float resolved) {
            this.resolved = resolved;
        }

        @Override
        public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
            EspressoFrame.putFloat((Frame)frame, top, this.resolved);
        }

        @Override
        public Object value() {
            return Float.valueOf(this.resolved);
        }

        @Override
        public String toString(ConstantPool pool) {
            return "ResolvedDynamicConstant(" + this.resolved + ")";
        }
    }

    public static final class ResolvedDouble
    implements Resolved {
        final double resolved;

        public ResolvedDouble(double resolved) {
            this.resolved = resolved;
        }

        @Override
        public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
            EspressoFrame.putDouble((Frame)frame, top, this.resolved);
        }

        @Override
        public Object value() {
            return this.resolved;
        }

        @Override
        public String toString(ConstantPool pool) {
            return "ResolvedDynamicConstant(" + this.resolved + ")";
        }
    }

    public static final class ResolvedLong
    implements Resolved {
        final long resolved;

        public ResolvedLong(long resolved) {
            this.resolved = resolved;
        }

        @Override
        public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
            EspressoFrame.putLong((Frame)frame, top, this.resolved);
        }

        @Override
        public Object value() {
            return this.resolved;
        }

        @Override
        public String toString(ConstantPool pool) {
            return "ResolvedDynamicConstant(" + this.resolved + ")";
        }
    }

    public static final class ResolvedInt
    implements Resolved {
        final int resolved;

        public ResolvedInt(int resolved) {
            this.resolved = resolved;
        }

        @Override
        public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
            EspressoFrame.putInt((Frame)frame, top, this.resolved);
        }

        @Override
        public Object value() {
            return this.resolved;
        }

        @Override
        public String toString(ConstantPool pool) {
            return "ResolvedDynamicConstant(" + this.resolved + ")";
        }
    }

    public static final class ResolvedObject
    implements Resolved {
        final StaticObject resolved;

        public ResolvedObject(StaticObject resolved) {
            this.resolved = resolved;
        }

        @Override
        public void putResolved(VirtualFrame frame, int top, BytecodeNode node) {
            EspressoFrame.putObject((Frame)frame, top, this.resolved);
        }

        @Override
        public Object value() {
            return this.resolved;
        }

        @Override
        public String toString(ConstantPool pool) {
            return "ResolvedDynamicConstant(" + String.valueOf(this.resolved) + ")";
        }
    }

    public static interface Resolved
    extends DynamicConstant,
    Resolvable.ResolvedConstant {
        public void putResolved(VirtualFrame var1, int var2, BytecodeNode var3);

        @Override
        default public Symbol<Symbol.Type> getTypeSymbol(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("Getting type symbol of a resolved dynamic constant");
        }

        default public StaticObject guestBoxedValue(Meta meta) {
            Object value = this.value();
            if (value instanceof StaticObject) {
                return (StaticObject)value;
            }
            return Meta.box(meta, value);
        }

        default public void checkFail() {
        }
    }
}

