/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.nio.ByteBuffer;

public interface MethodHandleConstant
extends PoolConstant {
    public static MethodHandleConstant create(int refKind, int refIndex) {
        return new Index(refKind, refIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.METHODHANDLE;
    }

    public RefKind getRefKind();

    public char getRefIndex();

    @Override
    default public String toString(ConstantPool pool) {
        return String.valueOf((Object)this.getRefKind()) + " " + pool.at(this.getRefIndex()).toString(pool);
    }

    public static final class Index
    implements MethodHandleConstant,
    Resolvable {
        private final byte refKind;
        private final char refIndex;

        Index(int refKind, int refIndex) {
            this.refKind = PoolConstant.u1(refKind);
            this.refIndex = PoolConstant.u2(refIndex);
        }

        @Override
        public RefKind getRefKind() {
            return RefKind.forValue(this.refKind);
        }

        @Override
        public char getRefIndex() {
            return this.refIndex;
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, ObjectKlass accessingKlass) {
            Meta meta = pool.getContext().getMeta();
            if (meta.getLanguage().getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.STRICT || meta.getJavaVersion().java9OrLater()) {
                return this.specCompliantResolution(pool, accessingKlass, meta);
            }
            return this.hotspotResolutionBehavior(pool, accessingKlass, meta);
        }

        private Resolvable.ResolvedConstant specCompliantResolution(RuntimeConstantPool pool, ObjectKlass accessingKlass, Meta meta) {
            Symbol<Symbol.Name> refName;
            Klass mklass;
            StaticObject mtype;
            ConstantPool.Tag refTag = pool.tagAt(this.getRefIndex());
            if (refTag == ConstantPool.Tag.METHOD_REF || refTag == ConstantPool.Tag.INTERFACE_METHOD_REF) {
                Method target = pool.resolvedMethodAt(accessingKlass, this.refIndex);
                Symbol<Symbol.Type>[] parsed = target.getParsedSignature();
                mtype = MethodTypeConstant.signatureToMethodType(parsed, accessingKlass, false, meta);
                MethodRefConstant ref = pool.methodAt(this.getRefIndex());
                mklass = pool.resolvedKlassAt(accessingKlass, ((MemberRefConstant.Indexes)((Object)ref)).classIndex);
                refName = target.getName();
            } else {
                assert (refTag == ConstantPool.Tag.FIELD_REF);
                Field field = pool.resolvedFieldAt(accessingKlass, this.refIndex);
                mtype = meta.resolveSymbolAndAccessCheck(field.getType(), accessingKlass).mirror();
                mklass = field.getDeclaringKlass();
                refName = field.getName();
            }
            return this.linkMethodHandleConstant(accessingKlass, meta, mtype, mklass, refName);
        }

        private Resolvable.ResolvedConstant hotspotResolutionBehavior(RuntimeConstantPool pool, ObjectKlass accessingKlass, Meta meta) {
            Symbol<Symbol.Name> refName;
            Klass mklass;
            StaticObject mtype;
            ConstantPool.Tag refTag = pool.tagAt(this.getRefIndex());
            if (refTag == ConstantPool.Tag.METHOD_REF || refTag == ConstantPool.Tag.INTERFACE_METHOD_REF) {
                MethodRefConstant ref = pool.methodAt(this.getRefIndex());
                Symbol<Symbol.Signature> signature = ref.getSignature(pool);
                Symbol<Symbol.Type>[] parsed = meta.getSignatures().parsed(signature);
                mtype = MethodTypeConstant.signatureToMethodType(parsed, accessingKlass, false, meta);
                mklass = pool.resolvedKlassAt(accessingKlass, ((MemberRefConstant.Indexes)((Object)ref)).classIndex);
                refName = ref.getName(pool);
            } else {
                assert (refTag == ConstantPool.Tag.FIELD_REF);
                assert (pool.fieldAt(this.getRefIndex()) instanceof FieldRefConstant.Indexes);
                FieldRefConstant.Indexes ref = (FieldRefConstant.Indexes)pool.fieldAt(this.getRefIndex());
                Symbol<Symbol.Type> type = ref.getType(pool);
                mtype = meta.resolveSymbolAndAccessCheck(type, accessingKlass).mirror();
                mklass = ref.getResolvedHolderKlass(accessingKlass, pool);
                refName = ref.getName(pool);
            }
            return this.linkMethodHandleConstant(accessingKlass, meta, mtype, mklass, refName);
        }

        private Resolvable.ResolvedConstant linkMethodHandleConstant(Klass accessingKlass, Meta meta, StaticObject mtype, Klass mklass, Symbol<Symbol.Name> refName) {
            StaticObject mname = meta.toGuestString(refName);
            return new Resolved((StaticObject)meta.java_lang_invoke_MethodHandleNatives_linkMethodHandleConstant.invokeDirect(null, accessingKlass.mirror(), this.refKind, mklass.mirror(), mname, mtype));
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.memberAt(this.refIndex).validate(pool);
            RefKind kind = this.getRefKind();
            Symbol<Symbol.Name> memberName = pool.memberAt(this.refIndex).getName(pool);
            if (Symbol.Name._clinit_.equals(memberName)) {
                throw ConstantPool.classFormatError("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            if (Symbol.Name._init_.equals(memberName) && kind != RefKind.NEWINVOKESPECIAL) {
                throw ConstantPool.classFormatError("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            if (this.getRefKind() == null) {
                throw ConstantPool.classFormatError("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            if ((memberName.equals(Symbol.Name._init_) || memberName.equals(Symbol.Name._clinit_)) && (kind == RefKind.INVOKEVIRTUAL || kind == RefKind.INVOKESTATIC || kind == RefKind.INVOKESPECIAL || kind == RefKind.INVOKEINTERFACE)) {
                throw ConstantPool.classFormatError("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            boolean valid = false;
            ConstantPool.Tag tag = pool.at(this.refIndex).tag();
            switch (this.getRefKind().ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    valid = tag == ConstantPool.Tag.FIELD_REF;
                    break;
                }
                case 4: 
                case 7: {
                    valid = tag == ConstantPool.Tag.METHOD_REF;
                    break;
                }
                case 5: 
                case 6: {
                    valid = tag == ConstantPool.Tag.METHOD_REF || pool.getMajorVersion() >= 52 && tag == ConstantPool.Tag.INTERFACE_METHOD_REF;
                    break;
                }
                case 8: {
                    boolean bl = valid = tag == ConstantPool.Tag.INTERFACE_METHOD_REF;
                }
            }
            if (!valid) {
                throw ConstantPool.classFormatError("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.put(this.refKind);
            buf.putChar(this.refIndex);
        }
    }

    public static enum RefKind {
        GETFIELD(1),
        GETSTATIC(2),
        PUTFIELD(3),
        PUTSTATIC(4),
        INVOKEVIRTUAL(5),
        INVOKESTATIC(6),
        INVOKESPECIAL(7),
        NEWINVOKESPECIAL(8),
        INVOKEINTERFACE(9);

        public final int value;

        private RefKind(int value) {
            this.value = value;
        }

        public static RefKind forValue(int value) {
            switch (value) {
                case 1: {
                    return GETFIELD;
                }
                case 2: {
                    return GETSTATIC;
                }
                case 3: {
                    return PUTFIELD;
                }
                case 4: {
                    return PUTSTATIC;
                }
                case 5: {
                    return INVOKEVIRTUAL;
                }
                case 6: {
                    return INVOKESTATIC;
                }
                case 7: {
                    return INVOKESPECIAL;
                }
                case 8: {
                    return NEWINVOKESPECIAL;
                }
                case 9: {
                    return INVOKEINTERFACE;
                }
            }
            return null;
        }
    }

    public static final class Resolved
    implements Resolvable.ResolvedConstant {
        private StaticObject payload;

        Resolved(StaticObject payload) {
            this.payload = payload;
        }

        @Override
        public Object value() {
            return this.payload;
        }

        @Override
        public ConstantPool.Tag tag() {
            return ConstantPool.Tag.METHODHANDLE;
        }

        @Override
        public String toString(ConstantPool pool) {
            return this.payload.toString();
        }
    }
}

