/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.LinkedField;
import com.oracle.truffle.espresso.impl.Member;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.jdwp.api.FieldBreakpoint;
import com.oracle.truffle.espresso.jdwp.api.FieldRef;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public class Field
extends Member<Symbol.Type>
implements FieldRef {
    public static final Field[] EMPTY_ARRAY = new Field[0];
    final LinkedField linkedField;
    protected final ObjectKlass.KlassVersion holder;
    protected final RuntimeConstantPool pool;
    @CompilerDirectives.CompilationFinal
    private volatile Klass typeKlassCache;
    @CompilerDirectives.CompilationFinal
    private Symbol<Symbol.ModifiedUTF8> genericSignature;
    private boolean removedByRedefinition;
    private final StableBoolean hasActiveBreakpoints = new StableBoolean(false);
    private FieldBreakpoint[] infos = null;

    public Field(ObjectKlass.KlassVersion holder, LinkedField linkedField, RuntimeConstantPool pool) {
        this.linkedField = linkedField;
        this.holder = holder;
        this.pool = pool;
    }

    @Override
    public final Symbol<Symbol.Name> getName() {
        return this.linkedField.getName();
    }

    public final Symbol<Symbol.Type> getType() {
        return this.linkedField.getType();
    }

    public void removeByRedefinition() {
        this.removedByRedefinition = true;
    }

    public final boolean isRemoved() {
        return this.removedByRedefinition;
    }

    public final boolean needsReResolution() {
        return !this.holder.getAssumption().isValid();
    }

    public final Attribute[] getAttributes() {
        return this.linkedField.getParserField().getAttributes();
    }

    public final Symbol<Symbol.ModifiedUTF8> getGenericSignature() {
        if (this.genericSignature == null) {
            SignatureAttribute attr = (SignatureAttribute)this.linkedField.getAttribute(SignatureAttribute.NAME);
            this.genericSignature = attr == null ? Symbol.ModifiedUTF8.fromSymbol(this.getType()) : this.pool.symbolAt(attr.getSignatureIndex());
        }
        return this.genericSignature;
    }

    public final boolean isHidden() {
        return this.linkedField.isHidden();
    }

    public final boolean isTrustedFinal() {
        ObjectKlass k = this.getDeclaringKlass();
        return this.isFinalFlagSet() && (this.isStatic() || k.isHidden() || k.isRecord());
    }

    public final JavaKind getKind() {
        return this.linkedField.getKind();
    }

    @Override
    public final int getModifiers() {
        return this.linkedField.getFlags() & 0x50DF;
    }

    @Override
    public final ObjectKlass getDeclaringKlass() {
        return this.holder.getKlass();
    }

    public final int getSlot() {
        return this.linkedField.getSlot();
    }

    public final String toString() {
        return this.getDeclaringKlass().getNameAsString() + "." + String.valueOf(this.getName()) + ": " + String.valueOf(this.getType());
    }

    public final Klass resolveTypeKlass() {
        Klass tk = this.typeKlassCache;
        if (tk == null) {
            if (CompilerDirectives.isPartialEvaluationConstant((Object)this)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            this.doResolveType();
        }
        return this.typeKlassCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void doResolveType() {
        Field field = this;
        synchronized (field) {
            Klass tk = this.typeKlassCache;
            if (tk == null) {
                this.typeKlassCache = tk = this.holder.getKlass().getMeta().resolveSymbolOrFail(this.getType(), this.holder.getKlass().getDefiningClassLoader(), this.holder.getKlass().protectionDomain());
            }
        }
    }

    public final Attribute getAttribute(Symbol<Symbol.Name> attrName) {
        return this.linkedField.getAttribute(attrName);
    }

    public static Field getReflectiveFieldRoot(StaticObject seed, Meta meta) {
        StaticObject curField = seed;
        Field target = null;
        while (target == null) {
            target = (Field)meta.HIDDEN_FIELD_KEY.getHiddenObject(curField);
            if (target != null) continue;
            curField = meta.java_lang_reflect_Field_root.getObject(curField);
        }
        return target;
    }

    public final void checkLoadingConstraints(StaticObject loader1, StaticObject loader2) {
        this.getDeclaringKlass().getContext().getRegistries().checkLoadingConstraint(this.getType(), loader1, loader2);
    }

    public final Object get(StaticObject obj) {
        return this.get(obj, false);
    }

    public final Object get(StaticObject obj, boolean forceVolatile) {
        switch (this.getKind()) {
            case Boolean: {
                return this.getBoolean(obj, forceVolatile);
            }
            case Byte: {
                return this.getByte(obj, forceVolatile);
            }
            case Short: {
                return this.getShort(obj, forceVolatile);
            }
            case Char: {
                return Character.valueOf(this.getChar(obj, forceVolatile));
            }
            case Int: {
                return this.getInt(obj, forceVolatile);
            }
            case Float: {
                return Float.valueOf(this.getFloat(obj, forceVolatile));
            }
            case Long: {
                return this.getLong(obj, forceVolatile);
            }
            case Double: {
                return this.getDouble(obj, forceVolatile);
            }
            case Object: {
                return this.getObject(obj, forceVolatile);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    public final void set(StaticObject obj, Object value) {
        this.set(obj, value, false);
    }

    public final void set(StaticObject obj, Object value, boolean forceVolatile) {
        switch (this.getKind()) {
            case Boolean: {
                this.setBoolean(obj, (Boolean)value, forceVolatile);
                break;
            }
            case Byte: {
                this.setByte(obj, (Byte)value, forceVolatile);
                break;
            }
            case Short: {
                this.setShort(obj, (Short)value, forceVolatile);
                break;
            }
            case Char: {
                this.setChar(obj, ((Character)value).charValue(), forceVolatile);
                break;
            }
            case Int: {
                this.setInt(obj, (Integer)value, forceVolatile);
                break;
            }
            case Float: {
                this.setFloat(obj, ((Float)value).floatValue(), forceVolatile);
                break;
            }
            case Long: {
                this.setLong(obj, (Long)value, forceVolatile);
                break;
            }
            case Double: {
                this.setDouble(obj, (Double)value, forceVolatile);
                break;
            }
            case Object: {
                this.setObject(obj, value, forceVolatile);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
    }

    public final boolean getAsBoolean(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsBoolean(meta, obj, defaultIfNull, false);
    }

    public final boolean getAsBoolean(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asBoolean(val, defaultIfNull);
    }

    public final byte getAsByte(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsByte(meta, obj, defaultIfNull, false);
    }

    public final byte getAsByte(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asByte(val, defaultIfNull);
    }

    public final short getAsShort(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsShort(meta, obj, defaultIfNull, false);
    }

    public final short getAsShort(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asShort(val, defaultIfNull);
    }

    public final char getAsChar(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsChar(meta, obj, defaultIfNull, false);
    }

    public final char getAsChar(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asChar(val, defaultIfNull);
    }

    public final int getAsInt(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsInt(meta, obj, defaultIfNull, false);
    }

    public final int getAsInt(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asInt(val, defaultIfNull);
    }

    public final float getAsFloat(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsFloat(meta, obj, defaultIfNull, false);
    }

    public final float getAsFloat(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asFloat(val, defaultIfNull);
    }

    public final long getAsLong(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsLong(meta, obj, defaultIfNull, false);
    }

    public final long getAsLong(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asLong(val, defaultIfNull);
    }

    public final double getAsDouble(Meta meta, StaticObject obj, boolean defaultIfNull) {
        return this.getAsDouble(meta, obj, defaultIfNull, false);
    }

    public final double getAsDouble(Meta meta, StaticObject obj, boolean defaultIfNull, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asDouble(val, defaultIfNull);
    }

    public final StaticObject getAsObject(Meta meta, StaticObject obj) {
        return this.getAsObject(meta, obj, false);
    }

    public final StaticObject getAsObject(Meta meta, StaticObject obj, boolean forceVolatile) {
        Object val = this.get(obj, forceVolatile);
        return meta.asObject(val);
    }

    private Object getHiddenObjectHelper(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getObjectVolatile(obj);
        }
        return this.linkedField.getObject(obj);
    }

    private Object getObjectHelper(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (!this.getDeclaringKlass().getContext().anyHierarchyChanged()) {
            if (this.isVolatile() || forceVolatile) {
                return this.linkedField.getObjectVolatile(obj);
            }
            return this.linkedField.getObject(obj);
        }
        StaticObject result = this.isVolatile() || forceVolatile ? (StaticObject)this.linkedField.getObjectVolatile(obj) : (StaticObject)this.linkedField.getObject(obj);
        if (result == StaticObject.NULL) {
            return result;
        }
        return this.checkGetValueValidity(result);
    }

    protected StaticObject checkGetValueValidity(StaticObject object) {
        StaticObject result = object;
        try {
            Klass klass = this.resolveTypeKlass();
            if (klass != null && !klass.isAssignableFrom(result.getKlass())) {
                result = StaticObject.NULL;
            }
        }
        catch (EspressoException espressoException) {
            // empty catch block
        }
        return result;
    }

    private void setObjectHelper(StaticObject obj, Object value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.getDeclaringKlass().getContext().anyHierarchyChanged()) {
            this.checkSetValueValifity(value);
        }
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setObjectVolatile(obj, value);
        } else {
            this.linkedField.setObject(obj, value);
        }
    }

    protected void checkSetValueValifity(Object value) {
        if (value != StaticObject.NULL && value instanceof StaticObject) {
            Klass klass = null;
            try {
                klass = this.resolveTypeKlass();
            }
            catch (EspressoException espressoException) {
                // empty catch block
            }
            if (klass != null && !klass.isAssignableFrom(((StaticObject)value).getKlass())) {
                throw this.getDeclaringKlass().getMeta().throwException(this.getDeclaringKlass().getMeta().java_lang_IncompatibleClassChangeError);
            }
        }
    }

    public final StaticObject getObject(StaticObject obj) {
        return this.getObject(obj, false);
    }

    public StaticObject getObject(StaticObject obj, boolean forceVolatile) {
        assert (!this.isHidden()) : String.valueOf(this) + " is hidden, use getHiddenObject";
        return (StaticObject)this.getObjectHelper(obj, forceVolatile);
    }

    public final void setObject(StaticObject obj, Object value) {
        this.setObject(obj, value, false);
    }

    public void setObject(StaticObject obj, Object value, boolean forceVolatile) {
        assert (!this.isHidden()) : String.valueOf(this) + " is hidden, use setHiddenObject";
        this.setObjectHelper(obj, value, forceVolatile);
    }

    public StaticObject getAndSetObject(StaticObject obj, StaticObject value) {
        obj.checkNotForeign();
        assert (!this.isHidden()) : String.valueOf(this) + " is hidden";
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return (StaticObject)this.linkedField.getAndSetObject(obj, value);
    }

    public boolean compareAndSwapObject(StaticObject obj, Object before, Object after) {
        obj.checkNotForeign();
        assert (!this.isHidden()) : String.valueOf(this) + " is hidden";
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapObject(obj, before, after);
    }

    public StaticObject compareAndExchangeObject(StaticObject obj, Object before, Object after) {
        obj.checkNotForeign();
        assert (!this.isHidden()) : String.valueOf(this) + " is hidden";
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return (StaticObject)this.linkedField.compareAndExchangeObject(obj, before, after);
    }

    public final Object getHiddenObject(StaticObject obj) {
        return this.getHiddenObject(obj, false);
    }

    public final Object getHiddenObject(StaticObject obj, boolean forceVolatile) {
        assert (this.isHidden()) : String.valueOf(this) + " is not hidden, use getObject";
        return this.getHiddenObjectHelper(obj, forceVolatile);
    }

    public final void setHiddenObject(StaticObject obj, Object value) {
        this.setHiddenObject(obj, value, false);
    }

    public final void setHiddenObject(StaticObject obj, Object value, boolean forceVolatile) {
        assert (this.isHidden()) : String.valueOf(this) + " is not hidden, use setObject";
        this.setObjectHelper(obj, value, forceVolatile);
    }

    public final boolean getBoolean(StaticObject obj) {
        return this.getBoolean(obj, false);
    }

    public boolean getBoolean(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getBooleanVolatile(obj);
        }
        return this.linkedField.getBoolean(obj);
    }

    public final void setBoolean(StaticObject obj, boolean value) {
        this.setBoolean(obj, value, false);
    }

    public void setBoolean(StaticObject obj, boolean value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setBooleanVolatile(obj, value);
        } else {
            this.linkedField.setBoolean(obj, value);
        }
    }

    public boolean compareAndSwapBoolean(StaticObject obj, boolean before, boolean after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapBoolean(obj, before, after);
    }

    public boolean compareAndExchangeBoolean(StaticObject obj, boolean before, boolean after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeBoolean(obj, before, after);
    }

    public final byte getByte(StaticObject obj) {
        return this.getByte(obj, false);
    }

    public byte getByte(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getByteVolatile(obj);
        }
        return this.linkedField.getByte(obj);
    }

    public final void setByte(StaticObject obj, byte value) {
        this.setByte(obj, value, false);
    }

    public void setByte(StaticObject obj, byte value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setByteVolatile(obj, value);
        } else {
            this.linkedField.setByte(obj, value);
        }
    }

    public boolean compareAndSwapByte(StaticObject obj, byte before, byte after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapByte(obj, before, after);
    }

    public byte compareAndExchangeByte(StaticObject obj, byte before, byte after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeByte(obj, before, after);
    }

    public final char getChar(StaticObject obj) {
        return this.getChar(obj, false);
    }

    public char getChar(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getCharVolatile(obj);
        }
        return this.linkedField.getChar(obj);
    }

    public final void setChar(StaticObject obj, char value) {
        this.setChar(obj, value, false);
    }

    public void setChar(StaticObject obj, char value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setCharVolatile(obj, value);
        } else {
            this.linkedField.setChar(obj, value);
        }
    }

    public boolean compareAndSwapChar(StaticObject obj, char before, char after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapChar(obj, before, after);
    }

    public char compareAndExchangeChar(StaticObject obj, char before, char after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeChar(obj, before, after);
    }

    public final double getDouble(StaticObject obj) {
        return this.getDouble(obj, false);
    }

    public double getDouble(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getDoubleVolatile(obj);
        }
        return this.linkedField.getDouble(obj);
    }

    public final void setDouble(StaticObject obj, double value) {
        this.setDouble(obj, value, false);
    }

    public void setDouble(StaticObject obj, double value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setDoubleVolatile(obj, value);
        } else {
            this.linkedField.setDouble(obj, value);
        }
    }

    public boolean compareAndSwapDouble(StaticObject obj, double before, double after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapDouble(obj, before, after);
    }

    public double compareAndExchangeDouble(StaticObject obj, double before, double after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeDouble(obj, before, after);
    }

    public final float getFloat(StaticObject obj) {
        return this.getFloat(obj, false);
    }

    public float getFloat(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getFloatVolatile(obj);
        }
        return this.linkedField.getFloat(obj);
    }

    public final void setFloat(StaticObject obj, float value) {
        this.setFloat(obj, value, false);
    }

    public void setFloat(StaticObject obj, float value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setFloatVolatile(obj, value);
        } else {
            this.linkedField.setFloat(obj, value);
        }
    }

    public boolean compareAndSwapFloat(StaticObject obj, float before, float after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapFloat(obj, before, after);
    }

    public float compareAndExchangeFloat(StaticObject obj, float before, float after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeFloat(obj, before, after);
    }

    public final int getInt(StaticObject obj) {
        return this.getInt(obj, false);
    }

    public int getInt(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getIntVolatile(obj);
        }
        return this.linkedField.getInt(obj);
    }

    public final void setInt(StaticObject obj, int value) {
        this.setInt(obj, value, false);
    }

    public void setInt(StaticObject obj, int value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setIntVolatile(obj, value);
        } else {
            this.linkedField.setInt(obj, value);
        }
    }

    public int getAndSetInt(StaticObject obj, int value) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.getAndSetInt(obj, value);
    }

    public boolean compareAndSwapInt(StaticObject obj, int before, int after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapInt(obj, before, after);
    }

    public int compareAndExchangeInt(StaticObject obj, int before, int after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeInt(obj, before, after);
    }

    public final long getLong(StaticObject obj) {
        return this.getLong(obj, false);
    }

    public long getLong(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        assert (this.getKind().needsTwoSlots());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getLongVolatile(obj);
        }
        return this.linkedField.getLong(obj);
    }

    public final void setLong(StaticObject obj, long value) {
        this.setLong(obj, value, false);
    }

    public void setLong(StaticObject obj, long value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        assert (this.getKind().needsTwoSlots());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setLongVolatile(obj, value);
        } else {
            this.linkedField.setLong(obj, value);
        }
    }

    public long getAndSetLong(StaticObject obj, long value) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        assert (this.getKind().needsTwoSlots());
        return this.linkedField.getAndSetLong(obj, value);
    }

    public boolean compareAndSwapLong(StaticObject obj, long before, long after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        assert (this.getKind().needsTwoSlots());
        return this.linkedField.compareAndSwapLong(obj, before, after);
    }

    public long compareAndExchangeLong(StaticObject obj, long before, long after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeLong(obj, before, after);
    }

    public final short getShort(StaticObject obj) {
        return this.getShort(obj, false);
    }

    public short getShort(StaticObject obj, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            return this.linkedField.getShortVolatile(obj);
        }
        return this.linkedField.getShort(obj);
    }

    public final void setShort(StaticObject obj, short value) {
        this.setShort(obj, value, false);
    }

    public void setShort(StaticObject obj, short value, boolean forceVolatile) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        if (this.isVolatile() || forceVolatile) {
            this.linkedField.setShortVolatile(obj, value);
        } else {
            this.linkedField.setShort(obj, value);
        }
    }

    public boolean compareAndSwapShort(StaticObject obj, short before, short after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndSwapShort(obj, before, after);
    }

    public short compareAndExchangeShort(StaticObject obj, short before, short after) {
        obj.checkNotForeign();
        assert (this.getDeclaringKlass().isAssignableFrom(obj.getKlass())) : String.valueOf(this) + " does not exist in " + String.valueOf(obj.getKlass());
        return this.linkedField.compareAndExchangeShort(obj, before, after);
    }

    @Override
    public final byte getTagConstant() {
        return this.getKind().toTagConstant();
    }

    @Override
    public final String getNameAsString() {
        return this.getName().toString();
    }

    @Override
    public final String getTypeAsString() {
        return this.getType().toString();
    }

    @Override
    public final String getGenericSignatureAsString() {
        Symbol<Symbol.ModifiedUTF8> signature = this.getGenericSignature();
        return signature.toString();
    }

    @Override
    public final Object getValue(Object self) {
        return this.get((StaticObject)self);
    }

    @Override
    public final void setValue(Object self, Object value) {
        this.set((StaticObject)self, value);
    }

    @Override
    public final boolean hasActiveBreakpoint() {
        return this.hasActiveBreakpoints.get();
    }

    @Override
    public final FieldBreakpoint[] getFieldBreakpointInfos() {
        return this.infos;
    }

    @Override
    public final void addFieldBreakpointInfo(FieldBreakpoint info) {
        if (this.infos == null) {
            this.infos = new FieldBreakpoint[]{info};
            this.hasActiveBreakpoints.set(true);
            return;
        }
        int length = this.infos.length;
        FieldBreakpoint[] temp = new FieldBreakpoint[length + 1];
        System.arraycopy(this.infos, 0, temp, 0, length);
        temp[length] = info;
        this.infos = temp;
        this.hasActiveBreakpoints.set(true);
    }

    @Override
    public final void removeFieldBreakpointInfo(int requestId) {
        switch (this.infos.length) {
            case 0: {
                throw new RuntimeException("Field: " + this.getNameAsString() + " should contain field breakpoint info");
            }
            case 1: {
                this.infos = null;
                this.hasActiveBreakpoints.set(false);
                return;
            }
            case 2: {
                FieldBreakpoint[] temp = new FieldBreakpoint[1];
                FieldBreakpoint info = this.infos[0];
                if (info.getRequestId() == requestId) {
                    temp[0] = this.infos[1];
                    this.infos = temp;
                    return;
                }
                info = this.infos[1];
                if (info.getRequestId() != requestId) break;
                temp[0] = this.infos[0];
                this.infos = temp;
                return;
            }
        }
    }

    public void setCompatibleField(Field field) {
    }

    public boolean hasCompatibleField() {
        return false;
    }

    public Field getCompatibleField() {
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public StaticObject makeMirror(Meta meta) {
        StaticObject runtimeVisibleTypeAnnotations;
        StaticObject instance = meta.java_lang_reflect_Field.allocateInstance(meta.getContext());
        Attribute rawRuntimeVisibleAnnotations = this.getAttribute(Symbol.Name.RuntimeVisibleAnnotations);
        StaticObject runtimeVisibleAnnotations = rawRuntimeVisibleAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleAnnotations.getData(), meta) : StaticObject.NULL;
        Attribute rawRuntimeVisibleTypeAnnotations = this.getAttribute(Symbol.Name.RuntimeVisibleTypeAnnotations);
        StaticObject staticObject = runtimeVisibleTypeAnnotations = rawRuntimeVisibleTypeAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleTypeAnnotations.getData(), meta) : StaticObject.NULL;
        if (meta.getJavaVersion().java15OrLater()) {
            meta.java_lang_reflect_Field_init.invokeDirect(instance, this.getDeclaringKlass().mirror(), meta.getStrings().intern(this.getName()), this.resolveTypeKlass().mirror(), this.getModifiers(), this.isTrustedFinal(), this.getSlot(), meta.toGuestString(this.getGenericSignature()), runtimeVisibleAnnotations);
        } else {
            meta.java_lang_reflect_Field_init.invokeDirect(instance, this.getDeclaringKlass().mirror(), meta.getStrings().intern(this.getName()), this.resolveTypeKlass().mirror(), this.getModifiers(), this.getSlot(), meta.toGuestString(this.getGenericSignature()), runtimeVisibleAnnotations);
        }
        meta.HIDDEN_FIELD_KEY.setHiddenObject(instance, this);
        meta.HIDDEN_FIELD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.setHiddenObject(instance, runtimeVisibleTypeAnnotations);
        return instance;
    }

    static final class StableBoolean {
        @CompilerDirectives.CompilationFinal
        private volatile Assumption unchanged;
        @CompilerDirectives.CompilationFinal
        private volatile boolean value;

        StableBoolean(boolean initialValue) {
            this.value = initialValue;
            this.unchanged = Truffle.getRuntime().createAssumption("Unchanged boolean");
        }

        @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="The get method returns a volatile field.")
        public boolean get() {
            if (!this.unchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.value;
        }

        @CompilerDirectives.TruffleBoundary
        public synchronized void set(boolean value) {
            if (this.value != value) {
                this.value = value;
                Assumption old = this.unchanged;
                this.unchanged = Truffle.getRuntime().createAssumption("Unchanged boolean");
                old.invalidate();
            }
        }
    }
}

