/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.staticobject.StaticShape;
import com.oracle.truffle.espresso.classfile.ImmutableConstantPool;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ContextDescription;
import com.oracle.truffle.espresso.impl.LinkedField;
import com.oracle.truffle.espresso.impl.LinkedKlassFieldLayout;
import com.oracle.truffle.espresso.impl.LinkedMethod;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.impl.ParserMethod;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.reflect.Modifier;

public final class LinkedKlass {
    public static final LinkedKlass[] EMPTY_ARRAY = new LinkedKlass[0];
    private final ParserKlass parserKlass;
    private final LinkedKlass superKlass;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LinkedKlass[] interfaces;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LinkedMethod[] methods;
    private final boolean hasFinalizer;
    private final StaticShape<StaticObject.StaticObjectFactory> instanceShape;
    private final StaticShape<StaticObject.StaticObjectFactory> staticShape;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LinkedField[] instanceFields;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LinkedField[] staticFields;
    final int fieldTableLength;

    private LinkedKlass(ParserKlass parserKlass, LinkedKlass superKlass, LinkedKlass[] interfaces, StaticShape<StaticObject.StaticObjectFactory> instanceShape, StaticShape<StaticObject.StaticObjectFactory> staticShape, LinkedField[] instanceFields, LinkedField[] staticFields, int fieldTableLength) {
        this.parserKlass = parserKlass;
        this.superKlass = superKlass;
        this.interfaces = interfaces;
        this.instanceShape = instanceShape;
        this.staticShape = staticShape;
        this.instanceFields = instanceFields;
        this.staticFields = staticFields;
        this.fieldTableLength = fieldTableLength;
        assert (superKlass == null || !Modifier.isInterface(superKlass.getFlags()));
        boolean bl = this.hasFinalizer = (parserKlass.getFlags() & 0x10000) != 0 || superKlass != null && (superKlass.getFlags() & 0x10000) != 0;
        assert (!this.hasFinalizer || !Symbol.Type.java_lang_Object.equals(parserKlass.getType())) : "java.lang.Object cannot be marked as finalizable";
        int methodCount = parserKlass.getMethods().length;
        LinkedMethod[] linkedMethods = new LinkedMethod[methodCount];
        for (int i = 0; i < methodCount; ++i) {
            ParserMethod parserMethod = parserKlass.getMethods()[i];
            linkedMethods[i] = new LinkedMethod(parserMethod);
        }
        this.methods = linkedMethods;
    }

    public static LinkedKlass create(ContextDescription description, ParserKlass parserKlass, LinkedKlass superKlass, LinkedKlass[] interfaces) {
        LinkedKlassFieldLayout fieldLayout = new LinkedKlassFieldLayout(description, parserKlass, superKlass);
        return new LinkedKlass(parserKlass, superKlass, interfaces, fieldLayout.instanceShape, fieldLayout.staticShape, fieldLayout.instanceFields, fieldLayout.staticFields, fieldLayout.fieldTableLength);
    }

    public static LinkedKlass redefine(ParserKlass parserKlass, LinkedKlass superKlass, LinkedKlass[] interfaces, LinkedKlass redefinedKlass) {
        return new LinkedKlass(parserKlass, superKlass, interfaces, redefinedKlass.instanceShape, redefinedKlass.staticShape, redefinedKlass.instanceFields, redefinedKlass.staticFields, redefinedKlass.fieldTableLength);
    }

    int getFlags() {
        int flags = this.parserKlass.getFlags();
        if (this.hasFinalizer) {
            flags |= 0x10000;
        }
        return flags;
    }

    ImmutableConstantPool getConstantPool() {
        return this.parserKlass.getConstantPool();
    }

    Attribute getAttribute(Symbol<Symbol.Name> name) {
        return this.parserKlass.getAttribute(name);
    }

    Symbol<Symbol.Type> getType() {
        return this.parserKlass.getType();
    }

    Symbol<Symbol.Name> getName() {
        return this.parserKlass.getName();
    }

    public ParserKlass getParserKlass() {
        return this.parserKlass;
    }

    LinkedKlass getSuperKlass() {
        return this.superKlass;
    }

    LinkedKlass[] getInterfaces() {
        return this.interfaces;
    }

    int getMajorVersion() {
        return this.getConstantPool().getMajorVersion();
    }

    int getMinorVersion() {
        return this.getConstantPool().getMinorVersion();
    }

    LinkedMethod[] getLinkedMethods() {
        return this.methods;
    }

    LinkedField[] getInstanceFields() {
        return this.instanceFields;
    }

    LinkedField[] getStaticFields() {
        return this.staticFields;
    }

    int getFieldTableLength() {
        return this.fieldTableLength;
    }

    public StaticShape<StaticObject.StaticObjectFactory> getShape(boolean isStatic) {
        return isStatic ? this.staticShape : this.instanceShape;
    }

    public String toString() {
        return "LinkedKlass<" + String.valueOf(this.getType()) + ">";
    }
}

