/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.api.staticobject.StaticShape;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ContextDescription;
import com.oracle.truffle.espresso.impl.LinkedField;
import com.oracle.truffle.espresso.impl.LinkedKlass;
import com.oracle.truffle.espresso.impl.ParserField;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.HashSet;
import java.util.Map;

final class LinkedKlassFieldLayout {
    final StaticShape<StaticObject.StaticObjectFactory> instanceShape;
    final StaticShape<StaticObject.StaticObjectFactory> staticShape;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LinkedField[] instanceFields;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LinkedField[] staticFields;
    final int fieldTableLength;

    LinkedKlassFieldLayout(ContextDescription description, ParserKlass parserKlass, LinkedKlass superKlass) {
        StaticShape.Builder instanceBuilder = StaticShape.newBuilder((TruffleLanguage)description.language);
        StaticShape.Builder staticBuilder = StaticShape.newBuilder((TruffleLanguage)description.language);
        FieldCounter fieldCounter = new FieldCounter(parserKlass, description.javaVersion);
        int nextInstanceFieldIndex = 0;
        int nextStaticFieldIndex = 0;
        int nextInstanceFieldSlot = superKlass == null ? 0 : superKlass.getFieldTableLength();
        int nextStaticFieldSlot = 0;
        this.staticFields = new LinkedField[fieldCounter.staticFields];
        this.instanceFields = new LinkedField[fieldCounter.instanceFields];
        LinkedField.IdMode idMode = LinkedKlassFieldLayout.getIdMode(parserKlass);
        for (ParserField parserField : parserKlass.getFields()) {
            if (parserField.isStatic()) {
                LinkedKlassFieldLayout.createAndRegisterLinkedField(parserKlass, parserField, nextStaticFieldSlot++, nextStaticFieldIndex++, idMode, staticBuilder, this.staticFields);
                continue;
            }
            LinkedKlassFieldLayout.createAndRegisterLinkedField(parserKlass, parserField, nextInstanceFieldSlot++, nextInstanceFieldIndex++, idMode, instanceBuilder, this.instanceFields);
        }
        for (HiddenField hiddenField : fieldCounter.hiddenFieldNames) {
            if (!hiddenField.versionRange.contains(description.javaVersion)) continue;
            ParserField hiddenParserField = new ParserField(0x10000 | hiddenField.additionalFlags, hiddenField.name, hiddenField.type, null);
            LinkedKlassFieldLayout.createAndRegisterLinkedField(parserKlass, hiddenParserField, nextInstanceFieldSlot++, nextInstanceFieldIndex++, idMode, instanceBuilder, this.instanceFields);
        }
        this.instanceShape = superKlass == null ? instanceBuilder.build(StaticObject.class, StaticObject.StaticObjectFactory.class) : instanceBuilder.build(superKlass.getShape(false));
        this.staticShape = staticBuilder.build(StaticObject.class, StaticObject.StaticObjectFactory.class);
        this.fieldTableLength = nextInstanceFieldSlot;
    }

    static LinkedField.IdMode getIdMode(ParserKlass parserKlass) {
        ParserField[] parserFields = parserKlass.getFields();
        boolean noDup = true;
        HashSet<String> present = new HashSet<String>(parserFields.length);
        for (ParserField parserField : parserFields) {
            if (present.add(parserField.getName().toString())) continue;
            noDup = false;
            break;
        }
        if (noDup) {
            return LinkedField.IdMode.REGULAR;
        }
        present.clear();
        for (ParserField parserField : parserFields) {
            String id = LinkedField.idFromNameAndType(parserField.getName(), parserField.getType());
            if (present.add(id)) continue;
            return LinkedField.IdMode.OBFUSCATED;
        }
        return LinkedField.IdMode.WITH_TYPE;
    }

    private static void createAndRegisterLinkedField(ParserKlass parserKlass, ParserField parserField, int slot, int index, LinkedField.IdMode idMode, StaticShape.Builder builder, LinkedField[] linkedFields) {
        LinkedField field = new LinkedField(parserField, slot, idMode);
        builder.property((StaticProperty)field, parserField.getPropertyType(), LinkedKlassFieldLayout.storeAsFinal(parserKlass, parserField));
        linkedFields[index] = field;
    }

    private static boolean storeAsFinal(ParserKlass klass, ParserField field) {
        Symbol<Symbol.Type> klassType = klass.getType();
        Symbol<Symbol.Name> fieldName = field.getName();
        if (klassType == Symbol.Type.java_lang_System && (fieldName == Symbol.Name.in || fieldName == Symbol.Name.out || fieldName == Symbol.Name.err)) {
            return false;
        }
        return field.isFinal();
    }

    private static final class FieldCounter {
        final HiddenField[] hiddenFieldNames;
        final int instanceFields;
        final int staticFields;

        FieldCounter(ParserKlass parserKlass, JavaVersion version) {
            int iFields = 0;
            int sFields = 0;
            for (ParserField f : parserKlass.getFields()) {
                if (f.isStatic()) {
                    ++sFields;
                    continue;
                }
                ++iFields;
            }
            this.hiddenFieldNames = HiddenField.getHiddenFields(parserKlass.getType(), version);
            this.instanceFields = iFields + this.hiddenFieldNames.length;
            this.staticFields = sFields;
        }
    }

    private static class HiddenField {
        private static final int NO_ADDITIONAL_FLAGS = 0;
        private static final HiddenField[] EMPTY = new HiddenField[0];
        private static final Map<Symbol<Symbol.Type>, HiddenField[]> REGISTRY = Map.ofEntries(Map.entry(Symbol.Type.java_lang_invoke_MemberName, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_VMTARGET), new HiddenField(Symbol.Name.HIDDEN_VMINDEX)}), Map.entry(Symbol.Type.java_lang_reflect_Method, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_METHOD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS), new HiddenField(Symbol.Name.HIDDEN_METHOD_KEY)}), Map.entry(Symbol.Type.java_lang_reflect_Constructor, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_CONSTRUCTOR_RUNTIME_VISIBLE_TYPE_ANNOTATIONS), new HiddenField(Symbol.Name.HIDDEN_CONSTRUCTOR_KEY)}), Map.entry(Symbol.Type.java_lang_reflect_Field, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_FIELD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS), new HiddenField(Symbol.Name.HIDDEN_FIELD_KEY)}), Map.entry(Symbol.Type.java_lang_ref_Reference, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_HOST_REFERENCE)}), Map.entry(Symbol.Type.java_lang_Throwable, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_FRAMES), new HiddenField(Symbol.Name.HIDDEN_EXCEPTION_WRAPPER)}), Map.entry(Symbol.Type.java_lang_Thread, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_INTERRUPTED, Symbol.Type._boolean, JavaVersion.VersionRange.lower(13), 0), new HiddenField(Symbol.Name.HIDDEN_HOST_THREAD), new HiddenField(Symbol.Name.HIDDEN_ESPRESSO_MANAGED, Symbol.Type._boolean, JavaVersion.VersionRange.ALL, 0), new HiddenField(Symbol.Name.HIDDEN_DEPRECATION_SUPPORT), new HiddenField(Symbol.Name.HIDDEN_THREAD_UNPARK_SIGNALS, Symbol.Type._int, JavaVersion.VersionRange.ALL, 64), new HiddenField(Symbol.Name.HIDDEN_THREAD_PARK_LOCK, Symbol.Type.java_lang_Object, JavaVersion.VersionRange.ALL, 16), new HiddenField(Symbol.Name.HIDDEN_THREAD_SCOPED_VALUE_CACHE), new HiddenField(Symbol.Name.HIDDEN_THREAD_PENDING_MONITOR), new HiddenField(Symbol.Name.HIDDEN_THREAD_WAITING_MONITOR), new HiddenField(Symbol.Name.HIDDEN_THREAD_BLOCKED_COUNT), new HiddenField(Symbol.Name.HIDDEN_THREAD_WAITED_COUNT), new HiddenField(Symbol.Name.HIDDEN_THREAD_DEPTH_FIRST_NUMBER)}), Map.entry(Symbol.Type.java_lang_Class, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_SIGNERS), new HiddenField(Symbol.Name.HIDDEN_MIRROR_KLASS, 16), new HiddenField(Symbol.Name.HIDDEN_PROTECTION_DOMAIN)}), Map.entry(Symbol.Type.java_lang_ClassLoader, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_CLASS_LOADER_REGISTRY)}), Map.entry(Symbol.Type.java_lang_Module, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_MODULE_ENTRY)}), Map.entry(Symbol.Type.java_util_regex_Pattern, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_TREGEX_MATCH), new HiddenField(Symbol.Name.HIDDEN_TREGEX_FULLMATCH), new HiddenField(Symbol.Name.HIDDEN_TREGEX_SEARCH), new HiddenField(Symbol.Name.HIDDEN_TREGEX_UNSUPPORTED)}), Map.entry(Symbol.Type.java_util_regex_Matcher, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_TREGEX_TSTRING), new HiddenField(Symbol.Name.HIDDEN_TREGEX_OLD_LAST_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_MOD_COUNT_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_TRANSPARENT_BOUNDS_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_ANCHORING_BOUNDS_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_FROM_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_TO_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_SEARCH_FROM_BACKUP), new HiddenField(Symbol.Name.HIDDEN_TREGEX_MATCHING_MODE_BACKUP)}), Map.entry(Symbol.Type.org_graalvm_continuations_ContinuationImpl, new HiddenField[]{new HiddenField(Symbol.Name.HIDDEN_CONTINUATION_FRAME_RECORD)}));
        private final Symbol<Symbol.Name> name;
        private final Symbol<Symbol.Type> type;
        private final JavaVersion.VersionRange versionRange;
        private final int additionalFlags;

        HiddenField(Symbol<Symbol.Name> name) {
            this(name, Symbol.Type.java_lang_Object, JavaVersion.VersionRange.ALL, 0);
        }

        HiddenField(Symbol<Symbol.Name> name, int additionalFlags) {
            this(name, Symbol.Type.java_lang_Object, JavaVersion.VersionRange.ALL, additionalFlags);
        }

        HiddenField(Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, JavaVersion.VersionRange versionRange, int additionalFlags) {
            this.name = name;
            this.type = type;
            this.versionRange = versionRange;
            this.additionalFlags = additionalFlags;
        }

        private boolean appliesTo(JavaVersion version) {
            return this.versionRange.contains(version);
        }

        static HiddenField[] getHiddenFields(Symbol<Symbol.Type> holder, JavaVersion version) {
            return HiddenField.applyFilter(HiddenField.getHiddenFieldsFull(holder), version);
        }

        private static HiddenField[] applyFilter(HiddenField[] hiddenFields, JavaVersion version) {
            int filtered = 0;
            for (HiddenField f : hiddenFields) {
                if (f.appliesTo(version)) continue;
                ++filtered;
            }
            if (filtered == 0) {
                return hiddenFields;
            }
            HiddenField[] result = new HiddenField[hiddenFields.length - filtered];
            int pos = 0;
            for (HiddenField f : hiddenFields) {
                if (!f.appliesTo(version)) continue;
                result[pos++] = f;
            }
            return result;
        }

        private static HiddenField[] getHiddenFieldsFull(Symbol<Symbol.Type> holder) {
            return REGISTRY.getOrDefault(holder, EMPTY);
        }
    }
}

