/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.ConnectionClosedException;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;

public final class SocketConnection
implements Runnable {
    private final Socket socket;
    private final OutputStream socketOutput;
    private final InputStream socketInput;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final Semaphore isOpen = new Semaphore(1);
    private final BlockingQueue<PacketStream> queue = new ArrayBlockingQueue<PacketStream>(4096);

    SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    public void close(DebuggerController controller) throws IOException {
        while (!this.queue.isEmpty()) {
            for (PacketStream packetStream : this.queue) {
                byte[] shipment = packetStream.prepareForShipment();
                try {
                    this.writePacket(shipment);
                }
                catch (ConnectionClosedException e) {
                    controller.finest(() -> "connection was closed when trying to flush queue");
                }
            }
        }
        this.socketOutput.flush();
        if (!this.isOpen.tryAcquire()) {
            return;
        }
        controller.fine(() -> "closing socket now");
        this.socketOutput.close();
        this.socketInput.close();
        this.socket.close();
        this.queue.clear();
    }

    public boolean isOpen() {
        return this.isOpen.availablePermits() > 0;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                PacketStream take = this.queue.take();
                byte[] shipment = take.prepareForShipment();
                this.writePacket(shipment);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException ex) {
                if (this.isOpen()) {
                    throw new RuntimeException("Failed sending packet to debugger instance", ex);
                }
                Thread.currentThread().interrupt();
            }
            catch (ConnectionClosedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void queuePacket(PacketStream stream) {
        if (this.isOpen()) {
            this.queue.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPacket() throws IOException, ConnectionClosedException {
        if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
            throw new ConnectionClosedException();
        }
        Object object = this.receiveLock;
        synchronized (object) {
            int b4;
            int b3;
            int b2;
            int b1;
            try {
                b1 = this.socketInput.read();
                b2 = this.socketInput.read();
                b3 = this.socketInput.read();
                b4 = this.socketInput.read();
            }
            catch (IOException ioe) {
                if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
                    throw new ConnectionClosedException();
                }
                throw ioe;
            }
            if (b1 < 0) {
                return new byte[0];
            }
            if (b2 < 0 || b3 < 0 || b4 < 0) {
                throw new IOException("protocol error - premature EOF");
            }
            int len = b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
            if (len < 0) {
                throw new IOException("protocol error - invalid length");
            }
            byte[] b = new byte[len];
            b[0] = (byte)b1;
            b[1] = (byte)b2;
            b[2] = (byte)b3;
            b[3] = (byte)b4;
            int off = 4;
            len -= off;
            while (len > 0) {
                int count;
                try {
                    count = this.socketInput.read(b, off, len);
                }
                catch (IOException ioe) {
                    if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
                        throw new ConnectionClosedException();
                    }
                    throw ioe;
                }
                if (count < 0) {
                    throw new IOException("protocol error - premature EOF");
                }
                len -= count;
                off += count;
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(byte[] b) throws IOException, ConnectionClosedException {
        if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
            throw new ConnectionClosedException();
        }
        if (b.length < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        int b0 = b[0] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b3 = b[3] & 0xFF;
        int len = b0 << 24 | b1 << 16 | b2 << 8 | b3 << 0;
        if (len < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        if (len > b.length) {
            throw new IllegalArgumentException("length mis-match");
        }
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.socketOutput.write(b, 0, len);
            }
            catch (IOException ioe) {
                if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
                    throw new ConnectionClosedException();
                }
                throw ioe;
            }
        }
    }

    public boolean isAvailable() {
        try {
            return this.socketInput.available() > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void sendVMDied(PacketStream stream, DebuggerController controller) {
        byte[] shipment = stream.prepareForShipment();
        try {
            this.writePacket(shipment);
            this.socketOutput.flush();
        }
        catch (Exception e) {
            controller.fine(() -> "sending VM_DEATH packet to client failed");
        }
    }
}

