/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.jdwp.api.CallFrame;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;

public class SuspendedInfo {
    protected final JDWPContext context;
    private final SuspendedEvent event;
    private final CallFrame[] stackFrames;
    private final Object thread;
    private final RootNode callerRootNode;
    private boolean forceEarlyInProgress;

    SuspendedInfo(JDWPContext context, SuspendedEvent event, CallFrame[] stackFrames, Object thread, RootNode callerRootNode) {
        this.context = context;
        this.event = event;
        this.stackFrames = stackFrames;
        this.thread = thread;
        this.callerRootNode = callerRootNode;
    }

    SuspendedInfo(JDWPContext context, CallFrame[] stackFrames, Object thread) {
        this.context = context;
        this.event = null;
        this.stackFrames = stackFrames;
        this.thread = thread;
        this.callerRootNode = null;
    }

    public SuspendedEvent getEvent() {
        return this.event;
    }

    public CallFrame[] getStackFrames() {
        return this.stackFrames;
    }

    public Object getThread() {
        return this.thread;
    }

    public RootNode getCallerRootNode() {
        return this.callerRootNode;
    }

    public Frame getCallerFrame() {
        return this.stackFrames.length > 1 ? this.stackFrames[1].getFrame() : null;
    }

    public void setForceEarlyReturnInProgress() {
        this.forceEarlyInProgress = true;
    }

    public boolean isForceEarlyReturnInProgress() {
        return this.forceEarlyInProgress;
    }
}

