/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.WeakHashMap;

public class WeakHandles<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final WeakHashMap<T, Integer> map;
    private final LinkedList<Integer> freeList = new LinkedList();
    private WeakReference<T>[] handles;

    public WeakHandles(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        this.map = new WeakHashMap(initialCapacity);
        this.handles = new WeakReference[initialCapacity];
    }

    public WeakHandles() {
        this(16);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized int handlify(T object) {
        Objects.requireNonNull(object);
        Integer handle = this.map.get(object);
        return handle != null ? handle.intValue() : this.addHandle(object);
    }

    public T getObject(long index) {
        if (index <= 0L) {
            throw new IllegalArgumentException("index");
        }
        WeakReference weakRef = (WeakReference)CompilerDirectives.castExact(this.handles[Math.toIntExact(index)], WeakReference.class);
        return weakRef != null ? (T)weakRef.get() : null;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized long getIndex(T object) {
        Integer index = this.map.get(Objects.requireNonNull(object));
        return index != null ? (long)index.intValue() : -1L;
    }

    @CompilerDirectives.TruffleBoundary
    private int getFreeSlot() {
        if (!this.freeList.isEmpty()) {
            return this.freeList.removeFirst();
        }
        for (int i = 1; i < this.handles.length; ++i) {
            if (this.handles[i] != null && this.handles[i].get() != null) continue;
            this.freeList.addLast(i);
        }
        return this.freeList.isEmpty() ? -1 : this.freeList.removeFirst();
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized int addHandle(T object) {
        Objects.requireNonNull(object);
        int index = this.getFreeSlot();
        if (index < 0) {
            WeakReference<T>[] newHandles = Arrays.copyOf(this.handles, 2 * this.handles.length);
            for (int i = this.handles.length; i < newHandles.length; ++i) {
                this.freeList.addLast(i);
            }
            this.handles = newHandles;
            index = this.freeList.removeFirst();
        }
        assert (index >= 0);
        this.handles[index] = new WeakReference<T>(object);
        this.map.put(object, index);
        return index;
    }
}

