/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jvmti;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.jni.NativeEnv;
import com.oracle.truffle.espresso.jvmti.JvmtiImpl;
import com.oracle.truffle.espresso.jvmti.JvmtiImplCollector;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.GenerateNativeEnv;
import java.util.List;

@GenerateNativeEnv(target=JvmtiImpl.class, prependEnv=true)
public final class JVMTIEnv
extends NativeEnv {
    private static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", JVMTIEnv.class);
    @CompilerDirectives.CompilationFinal
    private @Pointer TruffleObject jvmtiEnvPtr;
    @CompilerDirectives.CompilationFinal
    private int jvmtiVersion;
    private TruffleObject envLocalStorage = RawPointer.nullInstance();
    private static final List<CallableFromNative.Factory> JVMTI_IMPL_FACTORIES = JvmtiImplCollector.getInstances(CallableFromNative.Factory.class);

    JVMTIEnv(EspressoContext context, TruffleObject initializeJvmtiContext, int version) {
        super(context);
        this.jvmtiEnvPtr = this.initializeAndGetEnv(initializeJvmtiContext, version);
        this.jvmtiVersion = version;
        assert (this.getUncached().isPointer((Object)this.jvmtiEnvPtr));
        assert (this.jvmtiEnvPtr != null && !this.getUncached().isNull((Object)this.jvmtiEnvPtr));
    }

    void dispose(TruffleObject disposeJvmtiContext) {
        if (this.jvmtiEnvPtr != null) {
            try {
                this.getUncached().execute((Object)disposeJvmtiContext, new Object[]{this.jvmtiEnvPtr, this.jvmtiVersion, RawPointer.nullInstance()});
                this.jvmtiEnvPtr = null;
                this.jvmtiVersion = 0;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw EspressoError.shouldNotReachHere("Cannot dispose Espresso jvmti (mokapot).");
            }
        }
    }

    @Override
    protected TruffleLogger getLogger() {
        return LOGGER;
    }

    public TruffleObject getEnv() {
        return this.jvmtiEnvPtr;
    }

    @Override
    protected List<CallableFromNative.Factory> getCollector() {
        return JVMTI_IMPL_FACTORIES;
    }

    @Override
    protected String getName() {
        return "JVMTIEnv";
    }

    @JvmtiImpl
    public int Allocate(long byteCount, @Pointer TruffleObject memPtr) {
        TruffleObject alloc;
        if (byteCount < 0L) {
            return 103;
        }
        if (this.getUncached().isNull((Object)memPtr)) {
            return 103;
        }
        if (byteCount == 0L) {
            alloc = RawPointer.nullInstance();
        } else {
            alloc = this.getNativeAccess().allocateMemory(byteCount);
            if (this.getUncached().isNull((Object)alloc)) {
                return 110;
            }
        }
        NativeUtils.writeToPointerPointer(this.getUncached(), memPtr, alloc);
        return 0;
    }

    @JvmtiImpl
    public int Deallocate(@Pointer TruffleObject memPtr) {
        if (!this.getUncached().isNull((Object)memPtr)) {
            this.getNativeAccess().freeMemory(memPtr);
        }
        return 0;
    }

    @JvmtiImpl
    public int DisposeEnvironment() {
        this.getContext().getVM().getJvmti().dispose(this);
        return 0;
    }

    @JvmtiImpl
    public int SetEnvironmentLocalStorage(@Pointer TruffleObject data) {
        this.envLocalStorage = data;
        return 0;
    }

    @JvmtiImpl
    public int GetEnvironmentLocalStorage(@Pointer TruffleObject dataPtr) {
        if (this.getUncached().isNull((Object)dataPtr)) {
            return 103;
        }
        NativeUtils.writeToPointerPointer(this.getUncached(), dataPtr, this.envLocalStorage);
        return 0;
    }

    @JvmtiImpl
    public int GetPhase(@Pointer TruffleObject phasePtr) {
        if (this.getUncached().isNull((Object)phasePtr)) {
            return 103;
        }
        NativeUtils.writeToIntPointer(this.getUncached(), phasePtr, this.getVM().getJvmti().getPhase());
        return 0;
    }

    @JvmtiImpl
    public static int GetPotentialCapabilities(@Pointer TruffleObject cap) {
        return 0;
    }

    @JvmtiImpl
    public int GetVersionNumber(@Pointer TruffleObject versionPtr) {
        if (this.getUncached().isNull((Object)versionPtr)) {
            return 103;
        }
        NativeUtils.writeToIntPointer(this.getUncached(), versionPtr, this.jvmtiVersion);
        return 0;
    }
}

