/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import sun.misc.Unsafe;

public final class StringConversion {
    private static final Unsafe UNSAFE = UnsafeAccess.get();
    private final MaybeCopy maybeCopy;
    private final FromGuest fromGuest;
    private final ToHost toHost;
    private final ToGuest toGuest;

    public StringConversion(MaybeCopy maybeCopy, FromGuest fromGuest, ToGuest toGuest, ToHost toHost) {
        this.maybeCopy = maybeCopy;
        this.fromGuest = fromGuest;
        this.toHost = toHost;
        this.toGuest = toGuest;
    }

    public String toHost(StaticObject str, EspressoLanguage language, Meta meta) {
        return this.fromGuest.extract(str, language, meta, this.maybeCopy).toHost(this.toHost);
    }

    public StaticObject toGuest(String str, Meta meta) {
        return this.toGuest.hostToGuest(str, meta, this.maybeCopy);
    }

    static StringConversion select(EspressoContext context) {
        boolean sharing = (Boolean)context.getEnv().getOptions().get(EspressoOptions.StringSharing);
        boolean compactGuest = context.getJavaVersion().compactStringsEnabled();
        boolean compactHost = HostConstants.hostCompactStrings;
        return new StringConversion(sharing ? MaybeCopy.SHARING : MaybeCopy.NO_SHARING, compactGuest ? FromGuest.FROM_COMPACT : FromGuest.FROM_NOT_COMPACT, compactGuest ? ToGuest.TO_COMPACT : ToGuest.TO_NOT_COMPACT, compactHost ? ToHost.COMPACT_ENABLED : ToHost.COMPACT_DISABLED);
    }

    private static String allocateHost() {
        try {
            return (String)UNSAFE.allocateInstance(String.class);
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere();
        }
    }

    private static char[] extractGuestChars8(EspressoLanguage language, Meta meta, StaticObject str) {
        return (char[])meta.java_lang_String_value.getObject(str).unwrap(language);
    }

    private static byte[] extractGuestBytes11(EspressoLanguage language, Meta meta, StaticObject str) {
        return (byte[])meta.java_lang_String_value.getObject(str).unwrap(language);
    }

    private static int extractGuestHash(Meta meta, StaticObject str) {
        return meta.java_lang_String_hash.getInt(str);
    }

    private static byte extractGuestCoder(Meta meta, StaticObject str) {
        return meta.java_lang_String_coder.getByte(str);
    }

    private static byte[] extractHostBytes(String str) {
        return (byte[])UNSAFE.getObject(str, HostConstants.hostValueOffset);
    }

    private static int extractHostHash(String str) {
        return UNSAFE.getInt(str, HostConstants.hostHashOffset);
    }

    private static byte extractHostCoder(String str) {
        return UNSAFE.getByte(str, HostConstants.hostCoderOffset);
    }

    private static StaticObject produceGuestString8(Meta meta, char[] value, int hash) {
        StaticObject guestString = meta.java_lang_String.allocateInstance(meta.getContext());
        meta.java_lang_String_hash.set(guestString, hash);
        meta.java_lang_String_value.setObject(guestString, StaticObject.wrap(value, meta), true);
        return guestString;
    }

    private static StaticObject produceGuestString11(Meta meta, byte[] value, int hash, byte coder) {
        StaticObject guestString = meta.java_lang_String.allocateInstance(meta.getContext());
        meta.java_lang_String_coder.set(guestString, coder);
        meta.java_lang_String_hash.set(guestString, hash);
        meta.java_lang_String_value.setObject(guestString, StaticObject.wrap(value, meta), true);
        return guestString;
    }

    private static String produceHostString(byte[] value, int hash, byte coder) {
        String res = StringConversion.allocateHost();
        UNSAFE.putInt(res, HostConstants.hostHashOffset, hash);
        UNSAFE.putByte(res, HostConstants.hostCoderOffset, coder);
        UNSAFE.putObjectVolatile(res, HostConstants.hostValueOffset, value);
        return res;
    }

    private static interface MaybeCopy {
        public static final MaybeCopy NO_SHARING = rec$ -> (byte[])rec$.clone();
        public static final MaybeCopy SHARING = bytes -> bytes;

        public byte[] maybeCopy(byte[] var1);
    }

    private static interface FromGuest {
        public static final FromGuest FROM_COMPACT = (guest, language, meta, maybeCopy) -> new AlmostString(maybeCopy.maybeCopy(StringConversion.extractGuestBytes11(language, meta, guest)), StringConversion.extractGuestHash(meta, guest), StringConversion.extractGuestCoder(meta, guest));
        public static final FromGuest FROM_NOT_COMPACT = (guest, language, meta, maybeCopy) -> {
            char[] chars = StringConversion.extractGuestChars8(language, meta, guest);
            String host = FromGuest.newHostString(chars);
            return new AlmostString(StringConversion.extractHostBytes(host), StringConversion.extractHostHash(host), StringConversion.extractHostCoder(host));
        };

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String newHostString(char[] chars) {
            return new String(chars);
        }

        public AlmostString extract(StaticObject var1, EspressoLanguage var2, Meta var3, MaybeCopy var4);
    }

    @SuppressFBWarnings(value={"UCF"}, justification="javac introduces a jump to next instruction in <clinit>")
    private static interface ToHost {
        public static final ToHost COMPACT_ENABLED;
        public static final ToHost COMPACT_DISABLED;

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String newStringFromLatin1(byte[] bytes) {
            return new String(bytes, StandardCharsets.ISO_8859_1);
        }

        public String toHost(AlmostString var1);

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
            COMPACT_ENABLED = almostString -> StringConversion.produceHostString(almostString.bytes, almostString.hash, almostString.coder);
            COMPACT_DISABLED = almostString -> {
                if (almostString.coder == HostConstants.UTF16) {
                    return StringConversion.produceHostString(almostString.bytes, almostString.hash, almostString.coder);
                }
                if (!1.$assertionsDisabled && almostString.coder != HostConstants.LATIN1) {
                    throw new AssertionError();
                }
                return ToHost.newStringFromLatin1(almostString.bytes);
            };
        }
    }

    private static interface ToGuest {
        public static final ToGuest TO_COMPACT = (host, meta, maybeCopy) -> StringConversion.produceGuestString11(meta, maybeCopy.maybeCopy(StringConversion.extractHostBytes(host)), StringConversion.extractHostHash(host), StringConversion.extractHostCoder(host));
        public static final ToGuest TO_NOT_COMPACT = (host, meta, maybeCopy) -> StringConversion.produceGuestString8(meta, ToGuest.getCharArray(host), StringConversion.extractHostHash(host));

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static char[] getCharArray(String host) {
            return host.toCharArray();
        }

        public StaticObject hostToGuest(String var1, Meta var2, MaybeCopy var3);
    }

    private record AlmostString(byte[] bytes, int hash, byte coder) {
        public String toHost(ToHost toHost) {
            return toHost.toHost(this);
        }
    }

    private static final class HostConstants {
        static final long hostValueOffset;
        static final long hostHashOffset;
        static final long hostCoderOffset;
        static final boolean hostCompactStrings;
        static final byte LATIN1;
        static final byte UTF16;

        private HostConstants() {
        }

        private static long getStringFieldOffset(String name) throws NoSuchFieldException {
            return UNSAFE.objectFieldOffset(String.class.getDeclaredField(name));
        }

        private static boolean hostUsesCompact() {
            try {
                Field compactStringsField = String.class.getDeclaredField("COMPACT_STRINGS");
                return UNSAFE.getBoolean(UNSAFE.staticFieldBase(compactStringsField), UNSAFE.staticFieldOffset(compactStringsField));
            }
            catch (NoSuchFieldException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        private static byte hostCoderValue(String name) {
            try {
                Field compactStringsField = String.class.getDeclaredField(name);
                return UNSAFE.getByte(UNSAFE.staticFieldBase(compactStringsField), UNSAFE.staticFieldOffset(compactStringsField));
            }
            catch (NoSuchFieldException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        static {
            try {
                hostValueOffset = HostConstants.getStringFieldOffset("value");
                hostHashOffset = HostConstants.getStringFieldOffset("hash");
                hostCoderOffset = HostConstants.getStringFieldOffset("coder");
                hostCompactStrings = HostConstants.hostUsesCompact();
                LATIN1 = HostConstants.hostCoderValue("LATIN1");
                UTF16 = HostConstants.hostCoderValue("UTF16");
            }
            catch (NoSuchFieldException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

