/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.EspressoScope;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Utf8ConstantTable;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.AbstractInstrumentableBytecodeNodeWrapper;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableNode;
import java.util.ArrayList;
import java.util.HashMap;

@ExportLibrary(value=NodeLibrary.class)
@GenerateWrapper
abstract class AbstractInstrumentableBytecodeNode
extends EspressoInstrumentableNode {
    AbstractInstrumentableBytecodeNode() {
    }

    abstract Object execute(VirtualFrame var1);

    abstract void initializeFrame(VirtualFrame var1);

    abstract Method.MethodVersion getMethodVersion();

    public final Method getMethod() {
        return this.getMethodVersion().getMethod();
    }

    protected abstract boolean isTrivial();

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return new AbstractInstrumentableBytecodeNodeWrapper(this, probeNode);
    }

    public SourceSection getSourceSection() {
        return this.getRootNode().getSourceSection();
    }

    @ExportMessage
    public final boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public final Object getScope(Frame frame, boolean nodeEnter) {
        return this.getScopeSlowPath(frame != null ? frame.materialize() : null);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getScopeSlowPath(MaterializedFrame frame) {
        Method method = this.getMethodVersion().getMethod();
        Local[] liveLocals = method.getLocalVariableTable().getLocalsAt(this.getBci((Frame)frame));
        boolean allParamsIncluded = AbstractInstrumentableBytecodeNode.checkLocals(liveLocals, method);
        if (!allParamsIncluded) {
            ArrayList<Local> constructedLiveLocals = new ArrayList<Local>();
            HashMap<Integer, Local> slotToLocal = new HashMap<Integer, Local>(liveLocals.length);
            for (Local liveLocal : liveLocals) {
                slotToLocal.put(liveLocal.getSlot(), liveLocal);
            }
            boolean hasReceiver = !method.isStatic();
            int localCount = hasReceiver ? 1 : 0;
            localCount += method.getParameterCount();
            Utf8ConstantTable utf8Constants = method.getLanguage().getUtf8ConstantTable();
            int startslot = 0;
            if (hasReceiver) {
                if (!slotToLocal.containsKey(startslot)) {
                    constructedLiveLocals.add(new Local(utf8Constants.getOrCreate(Symbol.Name.thiz), utf8Constants.getOrCreate(method.getDeclaringKlass().getType()), 0, 65535, 0));
                } else {
                    constructedLiveLocals.add((Local)slotToLocal.get(startslot));
                }
                slotToLocal.remove(startslot);
                ++startslot;
            }
            Symbol<Symbol.Type>[] parsedSignature = method.getParsedSignature();
            for (int i = startslot; i < localCount; ++i) {
                Symbol<Symbol.Type> paramType;
                Symbol<Symbol.Type> symbol = paramType = hasReceiver ? Signatures.parameterType(parsedSignature, i - 1) : Signatures.parameterType(parsedSignature, i);
                if (slotToLocal.containsKey(i)) continue;
                constructedLiveLocals.add(new Local(utf8Constants.getOrCreate(ByteSequence.create("arg_" + i)), utf8Constants.getOrCreate(paramType), 0, 65535, i));
                slotToLocal.remove(i);
            }
            constructedLiveLocals.addAll(slotToLocal.values());
            liveLocals = constructedLiveLocals.toArray(Local.EMPTY_ARRAY);
        }
        return EspressoScope.createVariables(liveLocals, (Frame)frame, method.getName());
    }

    private static boolean checkLocals(Local[] liveLocals, Method method) {
        if (liveLocals.length == 0) {
            return false;
        }
        int expectedParameterSlots = !method.isStatic() ? 1 + method.getParameterCount() : method.getParameterCount();
        boolean[] localPresent = new boolean[expectedParameterSlots];
        if (liveLocals.length < expectedParameterSlots) {
            return false;
        }
        for (Local liveLocal : liveLocals) {
            if (liveLocal.getSlot() >= expectedParameterSlots) continue;
            localPresent[liveLocal.getSlot()] = true;
        }
        for (boolean present : localPresent) {
            if (present) continue;
            return false;
        }
        return true;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.RootBodyTag.class;
    }
}

