/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNode;

@GeneratedBy(value=EspressoInstrumentableRootNode.class)
final class EspressoInstrumentableRootNodeWrapper
extends EspressoInstrumentableRootNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private EspressoInstrumentableRootNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    EspressoInstrumentableRootNodeWrapper(EspressoInstrumentableRootNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public EspressoInstrumentableRootNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    Object execute(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }

    @Override
    Method.MethodVersion getMethodVersion() {
        return this.delegateNode.getMethodVersion();
    }

    @Override
    public SourceSection getSourceSection() {
        return this.delegateNode.getSourceSection();
    }

    @Override
    boolean canSplit() {
        return this.delegateNode.canSplit();
    }

    @Override
    EspressoInstrumentableRootNode split() {
        return this.delegateNode.split();
    }

    @Override
    boolean isTrivial() {
        return this.delegateNode.isTrivial();
    }

    @Override
    public String toString() {
        return this.delegateNode.toString();
    }
}

