/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.ArrayList;

public abstract class AbstractLookupNode
extends EspressoNode {
    public static final char METHOD_SELECTION_SEPARATOR = '/';

    abstract Method.MethodVersion[] getMethodArray(Klass var1);

    @CompilerDirectives.TruffleBoundary
    Method[] doLookup(Klass klass, String key, boolean publicOnly, boolean isStatic, int arity) throws ArityException {
        String methodName;
        EspressoContext ctx = this.getContext();
        ArrayList<Method> result = new ArrayList<Method>();
        String signature = null;
        int separatorIndex = key.indexOf(47);
        if (separatorIndex >= 0) {
            methodName = key.substring(0, separatorIndex);
            signature = key.substring(separatorIndex + 1);
        } else {
            methodName = key;
        }
        Symbol<Symbol.Name> name = ctx.getNames().lookup(methodName);
        if (name == null) {
            return null;
        }
        Symbol<Symbol.Signature> sig = null;
        if (signature != null && (sig = ctx.getSignatures().lookupValidSignature(signature)) == null) {
            return null;
        }
        int minOverallArity = Integer.MAX_VALUE;
        int maxOverallArity = -1;
        boolean skipArityCheck = arity == -1;
        for (Method.MethodVersion m : this.getMethodArray(klass)) {
            if (!AbstractLookupNode.matchMethod(m.getMethod(), name, sig, isStatic, publicOnly)) continue;
            int matchArity = m.getMethod().getParameterCount();
            minOverallArity = Math.min(minOverallArity, matchArity);
            maxOverallArity = Math.max(maxOverallArity, matchArity);
            if (matchArity != arity && !skipArityCheck && (!m.getMethod().isVarargs() || arity < matchArity - 1)) continue;
            result.add(m.getMethod());
        }
        if (!skipArityCheck && result.isEmpty() && maxOverallArity >= 0) {
            throw ArityException.create((int)minOverallArity, (int)maxOverallArity, (int)arity);
        }
        return result.isEmpty() ? null : result.toArray(new Method[0]);
    }

    private static boolean matchMethod(Method m, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, boolean isStatic, boolean publicOnly) {
        return !(publicOnly && !m.isPublic() || m.isStatic() != isStatic || m.isSignaturePolymorphicDeclared() || methodName != m.getName() || signature != null && signature != m.getRawSignature());
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean isInvocable(Klass klass, String key, boolean publicOnly, boolean isStatic) {
        String methodName;
        String signature = null;
        int separatorIndex = key.indexOf(47);
        if (separatorIndex >= 0) {
            methodName = key.substring(0, separatorIndex);
            signature = key.substring(separatorIndex + 1);
        } else {
            methodName = key;
        }
        EspressoContext ctx = this.getContext();
        Symbol<Symbol.Name> name = ctx.getNames().lookup(methodName);
        if (name == null) {
            return false;
        }
        Symbol<Symbol.Signature> sig = null;
        if (signature != null && (sig = ctx.getSignatures().lookupValidSignature(signature)) == null) {
            return false;
        }
        for (Method.MethodVersion m : this.getMethodArray(klass)) {
            if (!AbstractLookupNode.matchMethod(m.getMethod(), name, sig, isStatic, publicOnly)) continue;
            return true;
        }
        return false;
    }
}

