/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.VM;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.options.OptionMap;

public class PolyglotTypeMappings {
    private static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", PolyglotTypeMappings.class);
    private static final String GUEST_TYPE_CONVERSION_INTERFACE = "com.oracle.truffle.espresso.polyglot.GuestTypeConversion";
    private final boolean hasInterfaceMappings;
    private final List<String> interfaceMappings;
    private UnmodifiableEconomicMap<String, ObjectKlass> mappedInterfaces;
    private final OptionMap<String> typeConverters;
    private UnmodifiableEconomicMap<String, TypeConverter> typeConverterFunctions;
    private UnmodifiableEconomicMap<String, ObjectKlass> espressoForeignCollections;
    private UnmodifiableEconomicMap<String, InternalTypeConverter> internalTypeConverterFunctions;
    private final boolean builtinCollections;

    public PolyglotTypeMappings(List<String> interfaceMappings, OptionMap<String> typeConverters, boolean builtinCollections) {
        this.interfaceMappings = interfaceMappings;
        this.hasInterfaceMappings = !interfaceMappings.isEmpty();
        this.typeConverters = typeConverters;
        this.builtinCollections = builtinCollections;
    }

    @CompilerDirectives.TruffleBoundary
    public void resolve(EspressoContext context) {
        EconomicMap temp;
        Set converters;
        assert (this.interfaceMappings != null);
        if (this.hasInterfaceMappings) {
            EconomicMap temp2 = EconomicMap.create((int)this.interfaceMappings.size());
            StaticObject bindingsLoader = context.getBindingsLoader();
            for (String mapping : this.interfaceMappings) {
                Klass parent = context.getMeta().loadKlassOrNull(context.getTypes().fromClassGetName(mapping), bindingsLoader, StaticObject.NULL);
                if (parent != null && parent.isInterface()) {
                    temp2.put((Object)mapping, (Object)((ObjectKlass)parent));
                    parent.typeConversionState = (byte)3;
                    continue;
                }
                throw new IllegalStateException("invalid interface type mapping specified: " + mapping);
            }
            this.mappedInterfaces = EconomicMap.create((UnmodifiableEconomicMap)temp2);
        }
        if (!(converters = this.typeConverters.entrySet()).isEmpty()) {
            temp = EconomicMap.create((int)converters.size());
            StaticObject bindingsLoader = context.getBindingsLoader();
            Symbol<Symbol.Name> name = Symbol.Name.toGuest;
            Symbol<Symbol.Signature> desc = Symbol.Signature.Object_Object;
            Klass conversionInterface = context.getMeta().loadKlassOrNull(context.getTypes().fromClassGetName(GUEST_TYPE_CONVERSION_INTERFACE), bindingsLoader, StaticObject.NULL);
            if (conversionInterface == null) {
                throw new IllegalStateException("Missing expected guest type conversion interface in polyglot.jar");
            }
            for (Map.Entry entry : converters) {
                String type = (String)entry.getKey();
                String conversionHandler = (String)entry.getValue();
                ObjectKlass conversionKlass = (ObjectKlass)context.getMeta().loadKlassOrNull(context.getTypes().fromClassGetName(conversionHandler), bindingsLoader, StaticObject.NULL);
                if (conversionKlass == null) {
                    throw new IllegalStateException("Class not found for polyglot type conversion handler: " + conversionHandler);
                }
                if (!conversionInterface.isAssignableFrom(conversionKlass)) {
                    throw new IllegalStateException("ConversionHandler does not implement the polyglot type conversion interface: com.oracle.truffle.espresso.polyglot.GuestTypeConversion");
                }
                Method conversionMethod = conversionKlass.requireDeclaredMethod(name, desc);
                StaticObject conversionReceiver = context.getAllocator().createNew(conversionKlass);
                temp.put((Object)type, (Object)new TypeConverterImpl(conversionReceiver, DirectCallNode.create((CallTarget)conversionMethod.getCallTarget())));
            }
            this.typeConverterFunctions = EconomicMap.create((UnmodifiableEconomicMap)temp);
        }
        this.addInternalConverters(context.getMeta());
        if (this.builtinCollections) {
            temp = EconomicMap.create((int)6);
            this.addInternalEspressoCollections((EconomicMap<String, ObjectKlass>)temp, context.getMeta());
            this.espressoForeignCollections = EconomicMap.create((UnmodifiableEconomicMap)temp);
        }
    }

    private void addInternalConverters(Meta meta) {
        EconomicMap converters = EconomicMap.create((int)2);
        String current = "java.util.Optional";
        if (!this.isCustomMapped(current)) {
            converters.put((Object)current, (Object)new OptionalTypeConverter());
        } else {
            PolyglotTypeMappings.warn(current);
        }
        current = "java.math.BigDecimal";
        if (!this.isCustomMapped(current)) {
            converters.put((Object)current, (Object)new BigDecimalTypeConverter());
        } else {
            PolyglotTypeMappings.warn(current);
        }
        converters.put((Object)"byte[]", (Object)new BuiltinArrayTypeConverter(meta._byte_array));
        converters.put((Object)"boolean[]", (Object)new BuiltinArrayTypeConverter(meta._boolean_array));
        converters.put((Object)"char[]", (Object)new BuiltinArrayTypeConverter(meta._char_array));
        converters.put((Object)"short[]", (Object)new BuiltinArrayTypeConverter(meta._short_array));
        converters.put((Object)"int[]", (Object)new BuiltinArrayTypeConverter(meta._int_array));
        converters.put((Object)"long[]", (Object)new BuiltinArrayTypeConverter(meta._long_array));
        converters.put((Object)"float[]", (Object)new BuiltinArrayTypeConverter(meta._float_array));
        converters.put((Object)"double[]", (Object)new BuiltinArrayTypeConverter(meta._double_array));
        converters.put((Object)"java.lang.String[]", (Object)new BuiltinArrayTypeConverter(meta.java_lang_String_array));
        converters.put((Object)"java.lang.ClassCastException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ClassCastException));
        converters.put((Object)"java.lang.IllegalArgumentException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_IllegalArgumentException));
        converters.put((Object)"java.lang.ClassNotFoundException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ClassNotFoundException));
        converters.put((Object)"java.lang.IllegalStateException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_IllegalStateException));
        converters.put((Object)"java.util.NoSuchElementException", (Object)new BuiltinExceptionTypeConverter(meta.java_util_NoSuchElementException));
        converters.put((Object)"java.lang.NullPointerException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_NullPointerException));
        converters.put((Object)"java.lang.NumberFormatException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_NumberFormatException));
        converters.put((Object)"java.lang.UnsupportedOperationException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_UnsupportedOperationException));
        converters.put((Object)"java.lang.NoSuchMethodException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_NoSuchMethodException));
        converters.put((Object)"java.lang.NoSuchFieldException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_NoSuchFieldException));
        converters.put((Object)"java.lang.LinkageError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_LinkageError));
        converters.put((Object)"java.lang.ArithmeticException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ArithmeticException));
        converters.put((Object)"java.lang.SecurityException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_SecurityException));
        converters.put((Object)"java.lang.CloneNotSupportedException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_CloneNotSupportedException));
        converters.put((Object)"java.lang.InstantiationError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_InstantiationError));
        converters.put((Object)"java.lang.InstantiationException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_InstantiationException));
        converters.put((Object)"java.lang.ExceptionInInitializerError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ExceptionInInitializerError));
        converters.put((Object)"java.lang.StringIndexOutOfBoundsException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_StringIndexOutOfBoundsException));
        converters.put((Object)"java.lang.ArrayIndexOutOfBoundsException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ArrayIndexOutOfBoundsException));
        converters.put((Object)"java.lang.IndexOutOfBoundsException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_IndexOutOfBoundsException));
        converters.put((Object)"java.lang.ArrayStoreException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ArrayStoreException));
        converters.put((Object)"java.lang.UnsatisfiedLinkError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_UnsatisfiedLinkError));
        converters.put((Object)"java.lang.ClassCircularityError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ClassCircularityError));
        converters.put((Object)"java.lang.ClassFormatError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_ClassFormatError));
        converters.put((Object)"java.lang.VerifyError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_VerifyError));
        converters.put((Object)"java.lang.InternalError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_InternalError));
        converters.put((Object)"java.lang.AbstractMethodError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_AbstractMethodError));
        converters.put((Object)"java.lang.OutOfMemoryError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_OutOfMemoryError));
        converters.put((Object)"java.lang.StackOverflowError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_StackOverflowError));
        converters.put((Object)"java.lang.InterruptedException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_InterruptedException));
        converters.put((Object)"java.lang.NoClassDefFoundError", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_NoClassDefFoundError));
        converters.put((Object)"java.lang.IllegalMonitorStateException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_IllegalMonitorStateException));
        converters.put((Object)"java.lang.NegativeArraySizeException", (Object)new BuiltinExceptionTypeConverter(meta.java_lang_NegativeArraySizeException));
        this.internalTypeConverterFunctions = EconomicMap.create((UnmodifiableEconomicMap)converters);
    }

    private void addInternalEspressoCollections(EconomicMap<String, ObjectKlass> map, Meta meta) {
        String current = "java.lang.Iterable";
        if (!this.isCustomMapped(current)) {
            map.put((Object)current, (Object)meta.polyglot.EspressoForeignIterable);
        } else {
            PolyglotTypeMappings.warn(current);
        }
        current = "java.util.List";
        if (!this.isCustomMapped(current)) {
            map.put((Object)current, (Object)meta.polyglot.EspressoForeignList);
        } else {
            PolyglotTypeMappings.warn(current);
        }
        current = "java.util.Collection";
        if (!this.isCustomMapped(current)) {
            map.put((Object)current, (Object)meta.polyglot.EspressoForeignCollection);
        } else {
            PolyglotTypeMappings.warn(current);
        }
        current = "java.util.Iterator";
        if (!this.isCustomMapped(current)) {
            map.put((Object)current, (Object)meta.polyglot.EspressoForeignIterator);
        } else {
            PolyglotTypeMappings.warn(current);
        }
        current = "java.util.Map";
        if (!this.isCustomMapped(current)) {
            map.put((Object)current, (Object)meta.polyglot.EspressoForeignMap);
        } else {
            PolyglotTypeMappings.warn(current);
        }
        current = "java.util.Set";
        if (!this.isCustomMapped(current)) {
            map.put((Object)current, (Object)meta.polyglot.EspressoForeignSet);
        } else {
            PolyglotTypeMappings.warn(current);
        }
    }

    private static void warn(String mapping) {
        LOGGER.warning("Custom type mapping is used where there's a builtin type conversion available. Remove the [" + mapping + "] to enable the builtin converter.");
    }

    private boolean isCustomMapped(String mapping) {
        if (this.interfaceMappings != null && this.interfaceMappings.contains(mapping)) {
            return true;
        }
        return this.typeConverterFunctions != null && this.typeConverterFunctions.containsKey((Object)mapping);
    }

    public ObjectKlass mapEspressoForeignCollection(String metaName) {
        return (ObjectKlass)this.espressoForeignCollections.get((Object)metaName);
    }

    public ObjectKlass mapEspressoForeignCollection(Klass klass) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.espressoForeignCollections == null) {
            return null;
        }
        String name = klass.getNameAsString().replace('/', '.');
        return this.mapEspressoForeignCollection(name);
    }

    @CompilerDirectives.TruffleBoundary
    public ObjectKlass mapInterfaceName(String name) {
        assert (this.mappedInterfaces != null);
        return (ObjectKlass)this.mappedInterfaces.get((Object)name);
    }

    public boolean hasMappings() {
        return this.hasInterfaceMappings || this.typeConverterFunctions != null || this.internalTypeConverterFunctions != null;
    }

    public boolean hasInterfaceMappings() {
        return this.hasInterfaceMappings;
    }

    @CompilerDirectives.TruffleBoundary
    public TypeConverter mapTypeConversion(String metaName) {
        if (this.typeConverterFunctions == null) {
            return null;
        }
        return (TypeConverter)this.typeConverterFunctions.get((Object)metaName);
    }

    public TypeConverter mapTypeConversion(Klass klass) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.typeConverterFunctions == null) {
            return null;
        }
        String name = klass.getNameAsString().replace('/', '.');
        return this.mapTypeConversion(name);
    }

    @CompilerDirectives.TruffleBoundary
    public InternalTypeConverter mapInternalTypeConversion(String metaName) {
        if (this.internalTypeConverterFunctions == null) {
            return null;
        }
        return (InternalTypeConverter)this.internalTypeConverterFunctions.get((Object)metaName);
    }

    public InternalTypeConverter mapInternalTypeConversion(Klass klass) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.internalTypeConverterFunctions == null) {
            return null;
        }
        String name = klass.getNameAsString().replace('/', '.');
        return this.mapInternalTypeConversion(name);
    }

    public static class TypeConverterImpl
    implements TypeConverter {
        private final Object receiver;
        private final DirectCallNode callNode;

        TypeConverterImpl(Object receiver, DirectCallNode callNode) {
            this.receiver = receiver;
            this.callNode = callNode;
        }

        @Override
        public Object convert(StaticObject foreign) {
            return this.callNode.call(new Object[]{this.receiver, foreign});
        }
    }

    public static final class OptionalTypeConverter
    implements InternalTypeConverter {
        @Override
        public StaticObject convertInternal(InteropLibrary interop, Object value, Meta meta, ToReference.DynamicToReference toEspresso) throws UnsupportedTypeException {
            try {
                Object result = interop.invokeMember(value, "orElse", new Object[]{StaticObject.NULL});
                if (interop.isNull(result)) {
                    return (StaticObject)meta.java_util_Optional_EMPTY.get(meta.java_util_Optional.getStatics());
                }
                StaticObject guestOptional = toEspresso.getAllocator().createNew(meta.java_util_Optional);
                meta.java_util_Optional_value.setObject(guestOptional, toEspresso.execute(result, meta.java_lang_Object));
                return guestOptional;
            }
            catch (InteropException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"Could not cast foreign object to Optional", (Throwable)e);
            }
        }
    }

    public static final class BigDecimalTypeConverter
    implements InternalTypeConverter {
        @Override
        public StaticObject convertInternal(InteropLibrary interop, Object value, Meta meta, ToReference.DynamicToReference toEspresso) throws UnsupportedTypeException {
            try {
                int scale = interop.asInt(interop.invokeMember(value, "scale", new Object[0]));
                int precision = interop.asInt(interop.invokeMember(value, "precision", new Object[0]));
                BigInteger bigInteger = interop.asBigInteger(interop.invokeMember(value, "unscaledValue", new Object[0]));
                StaticObject guestMathContext = toEspresso.getAllocator().createNew(meta.java_math_MathContext);
                meta.java_math_MathContext_init.invokeDirect(guestMathContext, precision);
                StaticObject guestBigInteger = toEspresso.getAllocator().createNew(meta.java_math_BigInteger);
                meta.java_math_BigInteger_init.invokeDirect(guestBigInteger, BigDecimalTypeConverter.toByteArray(bigInteger, meta));
                StaticObject guestBigDecimal = toEspresso.getAllocator().createNew(meta.java_math_BigDecimal);
                meta.java_math_BigDecimal_init.invokeDirect(guestBigDecimal, guestBigInteger, scale, guestMathContext);
                return guestBigDecimal;
            }
            catch (InteropException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"Could not cast foreign object to BigDecimal", (Throwable)e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static StaticObject toByteArray(BigInteger bigInteger, Meta meta) {
            return StaticObject.wrap(bigInteger.toByteArray(), meta);
        }
    }

    public static final class BuiltinArrayTypeConverter
    implements InternalTypeConverter {
        private final ArrayKlass klass;

        public BuiltinArrayTypeConverter(ArrayKlass klass) {
            this.klass = klass;
        }

        @Override
        public StaticObject convertInternal(InteropLibrary interop, Object value, Meta meta, ToReference.DynamicToReference toEspresso) throws UnsupportedTypeException {
            if (!interop.hasArrayElements(value)) {
                this.boundaryThrow(value);
            }
            return StaticObject.createForeign(toEspresso.getLanguage(), this.klass, value, interop);
        }

        @CompilerDirectives.TruffleBoundary
        private void boundaryThrow(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: %s", this.klass.getNameAsString(), "foreign object has no array elements"));
        }
    }

    public static final class BuiltinExceptionTypeConverter
    implements InternalTypeConverter {
        private final ObjectKlass exceptionKlass;
        private final Method messageConstructor;

        public BuiltinExceptionTypeConverter(ObjectKlass klass) {
            this.exceptionKlass = klass;
            this.messageConstructor = klass.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_String, Klass.LookupMode.INSTANCE_ONLY);
        }

        @Override
        public StaticObject convertInternal(InteropLibrary interop, Object value, Meta meta, ToReference.DynamicToReference toEspresso) throws UnsupportedTypeException {
            StaticObject guestMessage;
            if (!interop.isException(value)) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: %s", this.exceptionKlass.getNameAsString(), "foreign object is not an exception"));
            }
            EspressoContext context = meta.getContext();
            StaticObject foreignException = value instanceof StaticObject ? (StaticObject)value : StaticObject.createForeignException(context, value, interop);
            StaticObject result = context.getAllocator().createNew(this.exceptionKlass);
            try {
                String message = interop.asString(interop.getExceptionMessage((Object)foreignException));
                guestMessage = meta.toGuestString(message);
            }
            catch (UnsupportedMessageException e) {
                guestMessage = StaticObject.NULL;
            }
            this.messageConstructor.invokeDirect(result, guestMessage);
            meta.java_lang_Throwable_backtrace.setObject(result, meta.java_lang_Throwable_backtrace.getObject(foreignException));
            if (meta.getJavaVersion().java9OrLater()) {
                meta.java_lang_Throwable_depth.setInt(result, meta.java_lang_Throwable_depth.getInt(foreignException));
            }
            meta.java_lang_Throwable_stackTrace.setObject(result, StaticObject.NULL);
            meta.HIDDEN_FRAMES.setHiddenObject(result, VM.StackTrace.FOREIGN_MARKER_STACK_TRACE);
            return result;
        }
    }

    public static interface TypeConverter {
        public Object convert(StaticObject var1);
    }

    public static interface InternalTypeConverter {
        public StaticObject convertInternal(InteropLibrary var1, Object var2, Meta var3, ToReference.DynamicToReference var4) throws UnsupportedTypeException;
    }
}

