/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.FloatArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.FloatArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class FloatArrayLoadQuickNode
extends QuickNode {
    static final int stackEffectOf_FALOAD = Bytecodes.stackEffectOf(48);
    @Node.Child
    FloatArrayLoad.WithoutNullCheck floatArrayLoad = FloatArrayLoadNodeGen.WithoutNullCheckNodeGen.create();

    public FloatArrayLoadQuickNode(int top, int callerBCI) {
        super(top, callerBCI);
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        int index = EspressoFrame.popInt((Frame)frame, this.top - 1);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 2));
        EspressoFrame.putFloat((Frame)frame, this.top - 2, this.floatArrayLoad.execute(array, index));
        return stackEffectOf_FALOAD;
    }
}

