/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractSetFieldNode;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class QuickenedPutFieldNode
extends QuickNode {
    private final int slotCount;
    private final int statementIndex;
    @Node.Child
    AbstractSetFieldNode setFieldNode;

    public QuickenedPutFieldNode(int top, int callerBCI, Field field, int statementIndex) {
        super(top, callerBCI);
        assert (!field.isStatic());
        this.setFieldNode = AbstractSetFieldNode.create(field);
        this.slotCount = field.getKind().getSlotCount();
        this.statementIndex = statementIndex;
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        BytecodeNode root = this.getBytecodeNode();
        StaticObject receiver = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 1 - this.slotCount));
        this.setFieldNode.setField(frame, root, receiver, this.top, this.statementIndex);
        return -this.slotCount - 1;
    }
}

