/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.ContinuableMethodWithBytecode;
import com.oracle.truffle.espresso.nodes.ContinuableMethodWithBytecodeFactory;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.vm.continuation.HostFrameRecord;
import com.oracle.truffle.espresso.vm.continuation.UnwindContinuationException;

public class InvokeContinuableNode
extends InvokeQuickNode {
    @Node.Child
    InvokeQuickNode original;
    @Node.Child
    ContinuableMethodWithBytecode.ResumeNextContinuationNode resumeNext;

    public InvokeContinuableNode(int top, int curBCI, InvokeQuickNode original) {
        super(original.method, top, curBCI);
        this.original = original;
        this.resumeNext = ContinuableMethodWithBytecodeFactory.ResumeNextContinuationNodeGen.create();
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        if (isContinuationResume) {
            return this.resumeContinuation(frame);
        }
        return this.original.execute(frame, false);
    }

    private int resumeContinuation(VirtualFrame frame) {
        ContinuableMethodWithBytecode continuableNode = this.getContinuableNode();
        HostFrameRecord hfr = continuableNode.getFrameRecords(frame);
        EspressoFrameDescriptor fd = continuableNode.getFD();
        CompilerAsserts.partialEvaluationConstant((Object)fd);
        fd.exportToFrame(frame, hfr.objects, hfr.primitives);
        HostFrameRecord next = hfr.next;
        hfr.next = null;
        try {
            return this.pushResult(frame, this.resumeNext.execute(next));
        }
        catch (UnwindContinuationException unwind) {
            if (EspressoFrame.isTainted((Frame)frame)) {
                fd.importFromFrame(frame, hfr.objects, hfr.primitives);
                hfr.untaint();
            }
            hfr.next = unwind.head;
            unwind.head = hfr;
            throw new BytecodeNode.EspressoOSRReturnException((Throwable)((Object)unwind));
        }
    }

    @ExplodeLoop
    public final ContinuableMethodWithBytecode getContinuableNode() {
        Node parent = this.getParent();
        while (!(parent instanceof ContinuableMethodWithBytecode)) {
            parent = parent.getParent();
        }
        return (ContinuableMethodWithBytecode)parent;
    }
}

