/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.EspressoThreadLocalState;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class InvokeDynamicCallSiteNode
extends QuickNode {
    private final StaticObject appendix;
    private final boolean hasAppendix;
    private final Symbol<Symbol.Type> returnType;
    private final JavaKind returnKind;
    @Node.Child
    private DirectCallNode callNode;
    final int resultAt;
    final boolean returnsPrimitiveType;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Symbol<Symbol.Type>[] parsedSignature;

    public InvokeDynamicCallSiteNode(StaticObject memberName, StaticObject appendix, Symbol<Symbol.Type>[] parsedSignature, Meta meta, int top, int curBCI) {
        super(top, curBCI);
        Method target = (Method)meta.HIDDEN_VMTARGET.getHiddenObject(memberName);
        this.appendix = appendix;
        this.parsedSignature = parsedSignature;
        this.returnType = Signatures.returnType(parsedSignature);
        this.returnKind = Signatures.returnKind(parsedSignature);
        this.hasAppendix = !StaticObject.isNull(appendix);
        this.callNode = DirectCallNode.create((CallTarget)target.getCallTarget());
        this.resultAt = top - Signatures.slotsForParameters(parsedSignature);
        this.returnsPrimitiveType = Types.isPrimitive(this.returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        Object result;
        int argCount = Signatures.parameterCount(this.parsedSignature);
        Object[] args = EspressoFrame.popBasicArgumentsWithArray(frame, this.top, this.parsedSignature, false, new Object[argCount + (this.hasAppendix ? 1 : 0)]);
        if (this.hasAppendix) {
            args[args.length - 1] = this.appendix;
        }
        EspressoThreadLocalState tls = this.getLanguage().getThreadLocalState();
        tls.blockContinuationSuspension();
        try {
            result = this.callNode.call(args);
        }
        finally {
            tls.unblockContinuationSuspension();
        }
        if (!this.returnsPrimitiveType) {
            this.getBytecodeNode().checkNoForeignObjectAssumption((StaticObject)result);
        }
        return this.getResultAt() - this.top + EspressoFrame.putKind(frame, this.getResultAt(), InvokeDynamicCallSiteNode.unbasic(result, this.returnType), this.returnKind);
    }

    private int getResultAt() {
        return this.resultAt;
    }

    public static Object unbasic(Object arg, Symbol<Symbol.Type> t) {
        if (t == Symbol.Type._boolean) {
            return (Integer)arg != 0;
        }
        if (t == Symbol.Type._short) {
            int value = (Integer)arg;
            return (short)value;
        }
        if (t == Symbol.Type._byte) {
            int value = (Integer)arg;
            return (byte)value;
        }
        if (t == Symbol.Type._char) {
            int value = (Integer)arg;
            return Character.valueOf((char)value);
        }
        return arg;
    }
}

