/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class InvokeQuickNode
extends QuickNode {
    private static final Object[] EMPTY_ARGS = new Object[0];
    public final Method.MethodVersion method;
    protected final int resultAt;
    protected final int stackEffect;
    private final boolean returnsPrimitive;

    public InvokeQuickNode(Method m, int top, int callerBCI) {
        super(top, callerBCI);
        this.method = m.getMethodVersion();
        this.resultAt = top - (Signatures.slotsForParameters(m.getParsedSignature()) + (m.hasReceiver() ? 1 : 0));
        this.stackEffect = this.resultAt - top + m.getReturnKind().getSlotCount();
        this.returnsPrimitive = m.getReturnKind().isPrimitive();
    }

    public InvokeQuickNode(Method.MethodVersion version, int top, int callerBCI) {
        super(top, callerBCI);
        this.method = version;
        Method m = version.getMethod();
        this.resultAt = top - (Signatures.slotsForParameters(m.getParsedSignature()) + (m.hasReceiver() ? 1 : 0));
        this.stackEffect = this.resultAt - top + m.getReturnKind().getSlotCount();
        this.returnsPrimitive = m.getReturnKind().isPrimitive();
    }

    public final StaticObject peekReceiver(VirtualFrame frame) {
        return EspressoFrame.peekReceiver(frame, this.top, this.method.getMethod());
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        return 0;
    }

    protected Object[] getArguments(VirtualFrame frame) {
        if (this.method.isStatic() && this.method.getMethod().getParameterCount() == 0) {
            return EMPTY_ARGS;
        }
        return EspressoFrame.popArguments(frame, this.top, !this.method.isStatic(), this.method.getMethod().getParsedSignature());
    }

    public final int pushResult(VirtualFrame frame, int result) {
        EspressoFrame.putInt((Frame)frame, this.resultAt, result);
        return this.stackEffect;
    }

    public final int pushResult(VirtualFrame frame, long result) {
        EspressoFrame.putLong((Frame)frame, this.resultAt, result);
        return this.stackEffect;
    }

    public final int pushResult(VirtualFrame frame, float result) {
        EspressoFrame.putFloat((Frame)frame, this.resultAt, result);
        return this.stackEffect;
    }

    public final int pushResult(VirtualFrame frame, double result) {
        EspressoFrame.putDouble((Frame)frame, this.resultAt, result);
        return this.stackEffect;
    }

    public final int pushResult(VirtualFrame frame, StaticObject result) {
        this.getBytecodeNode().checkNoForeignObjectAssumption(result);
        EspressoFrame.putObject((Frame)frame, this.resultAt, result);
        return this.stackEffect;
    }

    public final int pushResult(VirtualFrame frame, Object result) {
        if (!this.returnsPrimitive) {
            this.getBytecodeNode().checkNoForeignObjectAssumption((StaticObject)result);
        }
        EspressoFrame.putKind(frame, this.resultAt, result, this.method.getMethod().getReturnKind());
        return this.stackEffect;
    }

    @Override
    public final boolean removedByRedefinition() {
        if (this.method.getRedefineAssumption().isValid()) {
            return false;
        }
        return this.method.getMethod().isRemovedByRedefinition();
    }

    public final String toString() {
        return "INVOKE: " + this.method.getDeclaringKlass().getExternalName() + "." + this.method.getNameAsString() + ":" + String.valueOf(this.method.getRawSignature());
    }
}

