/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.ConditionalInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.GuardedInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodPredicate;

public final class GuardedConditionalInlinedMethodNode
extends InlinedMethodNode {
    private final ConditionalInlinedMethodNode.Recipes recipes;
    @Node.Child
    InvokeQuickNode fallbackNode;
    private final InlinedMethodPredicate condition;
    private final InlinedMethodPredicate guard;

    public GuardedConditionalInlinedMethodNode(Method.MethodVersion inlinedMethod, int top, int opcode, int callerBCI, int statementIndex, ConditionalInlinedMethodNode.Recipes recipes, InlinedMethodPredicate condition, InlinedMethodPredicate guard) {
        super(inlinedMethod, top, opcode, callerBCI, statementIndex, null);
        this.fallbackNode = (InvokeQuickNode)this.insert(ConditionalInlinedMethodNode.getFallback(inlinedMethod.getMethod(), top, callerBCI, opcode));
        this.condition = condition;
        this.guard = guard;
        this.recipes = recipes;
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        this.preludeChecks(frame);
        if (this.guard.isValid(this.getContext(), this.method, frame, this)) {
            if (this.condition.isValid(this.getContext(), this.method, frame, this)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                InlinedMethodNode replacement = GuardedConditionalInlinedMethodNode.getDefinitiveNode(this.recipes, this.guard, this.inlinedMethod(), this.top, this.opcode, this.getCallerBCI(), this.statementIndex);
                return this.getBytecodeNode().replaceQuickAt(frame, this.opcode, this.getCallerBCI(), this, replacement);
            }
            return this.fallbackNode.execute(frame, false);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.getBytecodeNode().reQuickenInvoke(frame, this.top, this.opcode, this.getCallerBCI(), this.statementIndex, this.method.getMethod());
    }

    public static InlinedMethodNode getDefinitiveNode(ConditionalInlinedMethodNode.Recipes recipes, InlinedMethodPredicate oldGuard, Method.MethodVersion method, int top, int opcode, int callerBci, int statementIndex) {
        InlinedMethodNode.BodyNode newBody = recipes.cookBody();
        InlinedMethodPredicate cookedGuard = recipes.cookGuard();
        InlinedMethodPredicate newGuard = cookedGuard == null ? oldGuard : (ctx, m, f, node) -> cookedGuard.isValid(ctx, m, f, node) && oldGuard.isValid(ctx, m, f, node);
        GuardedInlinedMethodNode replacement = new GuardedInlinedMethodNode(method, top, opcode, callerBci, statementIndex, newBody, newGuard);
        return replacement;
    }
}

